/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.auth.controller;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.ruoyi.auth.form.WxLoginBody;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.service.TokenService;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.api.RemoteUserService;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import io.swagger.annotations.ApiOperation;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/wxapp"})
@RestController
public class WxappController {
    private static final Logger log = LoggerFactory.getLogger(WxappController.class);
    @Autowired
    private WxMaService wxMaService;
    @Autowired
    private RemoteUserService remoteUserService;
    @Autowired
    private TokenService tokenService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8fopenid\u767b\u5f55\u8ba4\u8bc1", notes="\u7528\u6237\u9700\u8981\u7ed1\u5b9aopenid\u540e\u4f7f\u7528")
    @GetMapping(value={"codeLogin"})
    public R login(@RequestParam(required=true) String code) throws WxErrorException {
        if (StringUtils.isEmpty((String)code)) {
            return R.fail((String)"\u767b\u5f55\u6388\u6743code\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WxMaJscode2SessionResult sessionInfo = this.wxMaService.getUserService().getSessionInfo(code);
        R userResult = this.remoteUserService.getByUserOpenidOrUnionid(sessionInfo.getOpenid(), sessionInfo.getUnionid(), "inner");
        if (StringUtils.isNull((Object)userResult) || StringUtils.isNull((Object)userResult.getData())) {
            throw new ServiceException("\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\uff0c\u8bf7\u5148\u7ed1\u5b9a\u7528\u6237\uff01");
        }
        if (R.FAIL == userResult.getCode()) {
            throw new ServiceException(userResult.getMsg());
        }
        LoginUser userInfo = (LoginUser)userResult.getData();
        return R.ok((Object)this.tokenService.createToken(userInfo));
    }

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7code\u767b\u5f55\u8ba4\u8bc1")
    @PostMapping(value={"phoneLogin"})
    public R phoneLogin(@RequestBody WxLoginBody body) throws WxErrorException {
        if (StringUtils.isEmpty((String)body.getPhoneCode())) {
            return R.fail((String)"\u767b\u5f55\u6388\u6743code\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SysUser user = new SysUser();
        if (StringUtils.isNotEmpty((String)body.getLoginCode())) {
            WxMaJscode2SessionResult sessionInfo = this.wxMaService.getUserService().getSessionInfo(body.getLoginCode());
            user.setUnionid(sessionInfo.getUnionid());
            user.setOpenid(sessionInfo.getOpenid());
        }
        WxMaPhoneNumberInfo phoneNumber = this.wxMaService.getUserService().getPhoneNumber(body.getPhoneCode());
        log.info("phoneLogin--\u83b7\u53d6\u5230\u7684\u624b\u673a\u53f7\u7801\u4e3a\uff1a{}", (Object)phoneNumber.getPhoneNumber());
        R userResult = this.remoteUserService.getUserInfoByPhoneNumber(phoneNumber.getPhoneNumber(), user, "inner");
        if (StringUtils.isNull((Object)userResult) || StringUtils.isNull((Object)userResult.getData())) {
            user.setUserName(phoneNumber.getPhoneNumber());
            user.setPhone(phoneNumber.getPhoneNumber());
            user.setPhonenumber(phoneNumber.getPhoneNumber());
            user.setPassword("123456");
            user.setUserType("02");
            user.setNickName(phoneNumber.getPhoneNumber());
            user.setPassword(SecurityUtils.encryptPassword((String)"123456"));
            R registerResult = this.remoteUserService.registerUserInfo(user, "inner");
            if (R.FAIL == registerResult.getCode()) {
                throw new ServiceException(registerResult.getMsg());
            }
            userResult = this.remoteUserService.getUserInfoByPhoneNumber(phoneNumber.getPhoneNumber(), user, "inner");
        }
        if (R.FAIL == userResult.getCode()) {
            throw new ServiceException(userResult.getMsg());
        }
        LoginUser userInfo = (LoginUser)userResult.getData();
        return R.ok((Object)this.tokenService.createToken(userInfo));
    }

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7code\u83b7\u53d6\u624b\u673a\u53f7\u7801")
    @GetMapping(value={"getPhoneNumber"})
    public R getPhoneNumber(@RequestParam String code) throws WxErrorException {
        if (StringUtils.isEmpty((String)code)) {
            return R.fail((String)"\u767b\u5f55\u6388\u6743code\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WxMaPhoneNumberInfo phoneNumber = this.wxMaService.getUserService().getPhoneNumber(code);
        return R.ok((Object)phoneNumber.getPhoneNumber());
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55session\u4fe1\u606f")
    @GetMapping(value={"getSessionKey"})
    public R getSessionKey(@RequestParam String code) throws WxErrorException {
        if (StringUtils.isEmpty((String)code)) {
            return R.fail((String)"\u767b\u5f55\u6388\u6743code\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WxMaJscode2SessionResult sessionInfo = this.wxMaService.getUserService().getSessionInfo(code);
        return R.ok((Object)sessionInfo);
    }

    @ApiOperation(value="\u89e3\u5bc6\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"getUserInfo"})
    public R getUserInfo(@RequestParam String sessionKey, @RequestParam String encryptedData, @RequestParam String ivStr) throws WxErrorException {
        WxMaUserInfo userInfo = this.wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, ivStr);
        return R.ok((Object)userInfo);
    }

    @GetMapping(value={"/verify"})
    public String verify(String signature, String timestamp, String nonce, String echostr) throws Exception {
        if (!this.wxMaService.checkSignature(timestamp, nonce, signature)) {
            return null;
        }
        return echostr;
    }
}

