/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.config;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.feignClientApi.AuthClient;
import com.ruoyi.feignClientApi.LoginUserInfo;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class TokenFeignInterceptor
implements RequestInterceptor {
    @Resource
    private AuthClient authClient;
    private static AuthClient organizationService;

    @PostConstruct
    public void init() {
        organizationService = this.authClient;
    }

    public void apply(RequestTemplate template) {
        block5: {
            try {
                if (ObjectUtil.isNotEmpty((Object)SecurityUtils.getToken())) {
                    template.header("token", new String[]{SecurityUtils.getToken()});
                } else {
                    LoginUserInfo loginUserInfo = new LoginUserInfo();
                    JSONObject login = organizationService.login(loginUserInfo);
                    if ("200".equals(login.getString("code"))) {
                        String token = login.getJSONObject("data").getString("access_token");
                        template.header("token", new String[]{token});
                    }
                }
            }
            catch (Exception e) {
                LoginUserInfo loginUserInfo = new LoginUserInfo();
                JSONObject login = organizationService.login(loginUserInfo);
                if (!"200".equals(login.getString("code"))) break block5;
                String token = login.getJSONObject("data").getString("access_token");
                template.header("token", new String[]{token});
            }
        }
    }
}

