/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.packagescan.resource.ClassPathResource;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.controller.InvoiceApplyController;
import com.ruoyi.dto.FlowNoticeEvent;
import com.ruoyi.dto.InvoiceApplyExcel;
import com.ruoyi.dto.InvoiceApplyOtherRequest;
import com.ruoyi.dto.InvoiceApplyQueryRequest;
import com.ruoyi.dto.InvoiceApplyRequest;
import com.ruoyi.dto.WorkFlowCallBackVO;
import com.ruoyi.entity.InvoiceApply;
import com.ruoyi.entity.PaymentDetail;
import com.ruoyi.feignClientApi.CustomBrandFilesClient;
import com.ruoyi.feignClientApi.CustomerDataByCategoryDTO;
import com.ruoyi.service.IInvoiceApplyService;
import com.ruoyi.service.IPaymentDetailService;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5f00\u7968\u7533\u8bf7"})
@RestController
@RequestMapping(value={"/financial-management/invoice-apply"})
public class InvoiceApplyController {
    private static final Logger log = LoggerFactory.getLogger(InvoiceApplyController.class);
    @Resource
    private IInvoiceApplyService invoiceApplyService;
    @Resource
    private IPaymentDetailService paymentDetailService;
    @Resource
    private CustomBrandFilesClient customBrandFilesClient;

    @ApiOperation(value="\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5206\u9875")
    @PostMapping(value={"/queryInvoiceApplyPage"})
    public R<Page<InvoiceApply>> queryInvoiceApplyPage(@RequestBody InvoiceApplyQueryRequest invoiceApplyQueryRequest) {
        return R.ok((Object)this.invoiceApplyService.queryInvoiceApplyPage(invoiceApplyQueryRequest));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryDetail"})
    public R<InvoiceApplyRequest> queryDetail(@RequestParam(value="id") Long id) {
        return R.ok((Object)this.invoiceApplyService.queryDetail(id));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryPrintDetail"})
    public R<InvoiceApply> queryPrintDetail(@RequestParam(value="id") Long id) {
        return R.ok((Object)this.invoiceApplyService.queryPrintDetail(id));
    }

    @ApiOperation(value="\u65b0\u5efa\u5f00\u7968\u7533\u8bf7")
    @PostMapping(value={"/addInvoiceApply"})
    public R<Boolean> addInvoiceApply(@RequestBody InvoiceApplyRequest invoiceApplyRequest) {
        LoginUser loginUser;
        SysUser sysUser;
        List<String> longs;
        if (StringUtils.equals((CharSequence)invoiceApplyRequest.getState(), (CharSequence)"2") && !(longs = Arrays.asList("185", "186", "187", "171", "177", "169", "173", "170", "172", "176")).contains((sysUser = (loginUser = UserUtils.getLoginUser()).getSysUser()).getDeptId().toString())) {
            return R.failed((String)"\u65b0\u5efa\u5f00\u7968\u7533\u8bf7\u5931\u8d25,\u65e0\u6743\u9650");
        }
        try {
            return R.ok((Object)this.invoiceApplyService.addInvoiceApply(invoiceApplyRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("InvoiceApplyController-addInvoiceApply:{}", (Object)JSON.toJSONString((Object)e));
            return R.failed((String)"\u5f00\u7968\u7533\u8bf7\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0a\u7ea7\u9886\u5bfc")
    @PostMapping(value={"/leader"})
    public R<String> leader(@RequestBody LoginUser loginUser) {
        try {
            return R.ok((Object)this.invoiceApplyService.leader(loginUser));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("InvoiceApplyController-leader:{}", (Object)JSON.toJSONString((Object)e));
            return R.failed((String)"\u67e5\u8be2\u4e0a\u7ea7\u9886\u5bfc\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5f00\u7968\u7533\u8bf7\u5ba1\u6279\u901a\u8fc7\u6284\u9001")
    @GetMapping(value={"/fwd"})
    public R<Boolean> fwd(Long id) {
        return R.ok((Object)this.invoiceApplyService.fwd(id));
    }

    @ApiOperation(value="\u4e0a\u4f20\u5f00\u7968\u51ed\u8bc1")
    @PostMapping(value={"/uploadInvoice"})
    public R<Boolean> uploadInvoice(@RequestBody InvoiceApplyOtherRequest i) {
        return R.ok((Object)this.invoiceApplyService.uploadInvoice(i));
    }

    @ApiOperation(value="\u9000\u6b3e\u7533\u8bf7\u4e0b\u8f7dexcel\u6587\u4ef6")
    @PostMapping(value={"/downInvoiceApplyExcel"})
    public void downInvoiceApplyExcel(@RequestBody InvoiceApplyQueryRequest invoiceApplyQueryRequest, HttpServletResponse response) throws IOException {
        List refundApplyExcelList = this.invoiceApplyService.downData2Excel(invoiceApplyQueryRequest);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u5f00\u7968\u7533\u8bf7", "\u5f00\u7968\u7533\u8bf7", ExcelType.XSSF), InvoiceApplyExcel.class, (Collection)refundApplyExcelList);
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u5f00\u7968\u7533\u8bf7");
    }

    @PostMapping(value={"/workFlowCallBack"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFlowCallBack(@RequestBody FlowNoticeEvent vo) {
        try {
            log.info("workFlowCallBack:" + JSON.toJSON((Object)vo));
            String event = vo.getEvent();
            String businessKey = vo.getBody().getBusinessKey();
            InvoiceApply invoiceApply = (InvoiceApply)this.invoiceApplyService.getById((Serializable)Long.valueOf(businessKey));
            Map map = vo.getBody().getTaskVariables();
            String approveStatus = null;
            if (MapUtils.isNotEmpty((Map)map) && map.get("approveStatus") != null) {
                approveStatus = map.get("approveStatus").toString();
            }
            switch (1.$SwitchMap$com$ruoyi$dto$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
                case 1: {
                    if (invoiceApply.getPaymentDetailId() == null) break;
                    PaymentDetail paymentDetail = new PaymentDetail();
                    paymentDetail.setId(invoiceApply.getPaymentDetailId());
                    paymentDetail.setInvoiceFlag(Integer.valueOf(1));
                    this.paymentDetailService.updateById((Object)paymentDetail);
                    break;
                }
                case 2: {
                    if (!StringUtils.equals((CharSequence)approveStatus, (CharSequence)"2")) break;
                    invoiceApply.setState("3");
                    invoiceApply.setRejectReason(StringUtils.replace((String)vo.getBody().getTaskComment(), (String)"_\u9a73\u56de\u8df3\u8f6c\u8282\u70b9", (String)""));
                    this.invoiceApplyService.updateById((Object)invoiceApply);
                    break;
                }
                case 3: {
                    invoiceApply.setState("2");
                    this.invoiceApplyService.updateById((Object)invoiceApply);
                    break;
                }
                case 4: {
                    InvoiceApplyRequest invoiceApplyRequest = (InvoiceApplyRequest)JSONObject.parseObject((String)JSONObject.toJSONString(vo.getBody().getProcessVariables().get("formData")), InvoiceApplyRequest.class);
                    if (ObjectUtil.isNotEmpty((Object)invoiceApplyRequest.getAmountCollected())) {
                        invoiceApply.setAmountCollected(invoiceApplyRequest.getAmountCollected());
                    }
                    invoiceApply.setState("5");
                    this.invoiceApplyService.updateById((Object)invoiceApply);
                    if (invoiceApply.getPaymentDetailId() == null) break;
                    PaymentDetail paymentDetail = new PaymentDetail();
                    paymentDetail.setId(invoiceApply.getPaymentDetailId());
                    paymentDetail.setInvoiceFlag(Integer.valueOf(2));
                    this.paymentDetailService.updateById((Object)paymentDetail);
                    break;
                }
                case 5: {
                    invoiceApply.setState("4");
                    this.invoiceApplyService.updateById((Object)invoiceApply);
                }
            }
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/downloadTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5f00\u7968\u660e\u7ec6.xls", "UTF-8"));
        InputStream input = null;
        OutputStream output = null;
        try {
            InputStream inputStream;
            ClassPathResource classPathResource = new ClassPathResource("5.xls");
            input = inputStream = classPathResource.getInputStream();
            output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5f00\u7968\u660e\u7ec6\u5bfc\u5165")
    public R<Object> uniqueCodeStock(MultipartFile file) {
        try {
            ImportParams importParams = new ImportParams();
            importParams.setNeedVerify(true);
            ExcelImportResult importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), InvoiceApplyRequest.InvoiceDetail.class, (ImportParams)importParams);
            List list = importResult.getList();
            if (ObjectUtil.isNotEmpty((Object)list)) {
                List<String> types = Arrays.asList("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968", "\u7535\u5b50\u53d1\u7968(\u666e\u901a\u53d1\u7968)", "\u7535\u5b50\u53d1\u7968(\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968)");
                R totalCustomer = this.customBrandFilesClient.getTotalCustomer();
                List data = (List)totalCustomer.getData();
                List customerNames = data.stream().map(CustomerDataByCategoryDTO::getCustomerCode).collect(Collectors.toList());
                for (int i = 0; i < list.size(); ++i) {
                    InvoiceApplyRequest.InvoiceDetail materialArchivesImportVO = (InvoiceApplyRequest.InvoiceDetail)list.get(i);
                    if (ObjectUtil.isNotEmpty((Object)materialArchivesImportVO.getProjectCode())) {
                        if (!customerNames.contains(materialArchivesImportVO.getProjectCode())) {
                            return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u9879\u76ee\u7f16\u7801\u4e0d\u5b58\u5728"));
                        }
                        CustomerDataByCategoryDTO customerDataByCategoryDTO = data.stream().filter(f -> materialArchivesImportVO.getProjectCode().equals(f.getCustomerCode())).findFirst().orElse(new CustomerDataByCategoryDTO());
                        materialArchivesImportVO.setProjects(customerDataByCategoryDTO.getCustomerName());
                    }
                    if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getContent())) {
                        return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u5f00\u7968\u5185\u5bb9\u65e0\u6570\u636e"));
                    }
                    if (ObjectUtil.isNotEmpty((Object)materialArchivesImportVO.getTypes()) && !types.contains(materialArchivesImportVO.getTypes())) {
                        return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u53d1\u7968\u7c7b\u578b\u4fe1\u606f\u9519\u8bef"));
                    }
                    if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getQuantity())) {
                        return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u6570\u91cf\u65e0\u6570\u636e"));
                    }
                    if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getPrice())) {
                        return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u5355\u4ef7\u65e0\u6570\u636e"));
                    }
                    if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getIssuance())) {
                        return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u5f00\u7968\u91d1\u989d\u65e0\u6570\u636e"));
                    }
                    if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getRise())) {
                        return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u8d2d\u65b9\u62ac\u5934\u65e0\u6570\u636e"));
                    }
                    if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getIdentification())) {
                        return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u65e0\u6570\u636e"));
                    }
                    if (!ObjectUtil.isEmpty((Object)materialArchivesImportVO.getRemarks())) continue;
                    return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u53d1\u7968\u5907\u6ce8\u65e0\u6570\u636e"));
                }
            }
            return R.ok((Object)list);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u5f00\u7968\u660e\u7ec6\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(@RequestBody List<InvoiceApplyRequest.InvoiceDetail> invoiceApplyQueryRequest, HttpServletResponse response) throws IOException {
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), InvoiceApplyRequest.InvoiceDetail.class, invoiceApplyQueryRequest);
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u5f00\u7968\u660e\u7ec6");
    }
}

