/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.nacos.common.packagescan.resource.ClassPathResource;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.dto.EditPackageInfoRequest;
import com.ruoyi.dto.SimpleUserManagerQueryRequest;
import com.ruoyi.dto.SpeedPackageRequest;
import com.ruoyi.dto.UploadUserManagerExcel;
import com.ruoyi.dto.UserManagerExcel;
import com.ruoyi.dto.UserManagerQueryRequest;
import com.ruoyi.dto.UserManagerRequest;
import com.ruoyi.dto.UserManagerVo;
import com.ruoyi.dto.UserUpdateEndTimeRequest;
import com.ruoyi.entity.UserManager;
import com.ruoyi.feignClientApi.CustomBrandFilesClient;
import com.ruoyi.listener.UploadUserManagerListener;
import com.ruoyi.service.ISubPackageGroupManagerService;
import com.ruoyi.service.IUserManagerService;
import com.ruoyi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/bill-system/user-manager"})
public class UserManagerController {
    @Autowired
    private IUserManagerService userManagerService;
    @Autowired
    private ISubPackageGroupManagerService subPackageGroupManagerService;
    @Autowired
    private CustomBrandFilesClient customBrandFilesClient;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7ba1\u7406\u5206\u9875")
    @PostMapping(value={"/queryUserManagerPage"})
    public R<Page<UserManager>> queryUserManagerPage(@RequestBody UserManagerQueryRequest userManagerQueryRequest) {
        return R.ok((Object)this.userManagerService.queryUserManagerPage(userManagerQueryRequest));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u67e5\u8be2\u6570\u636e")
    @PostMapping(value={"/queryUserManagerPageUser"})
    public R<UserManager> queryUserManagerPageUser(@RequestBody UserManagerQueryRequest userManagerQueryRequest) {
        return R.ok((Object)this.userManagerService.queryUserManagerPageUser(userManagerQueryRequest));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237code\u67e5\u8be2\u6570\u636e")
    @PostMapping(value={"/queryUserManagerPageCode"})
    public R<UserManagerVo> queryUserManagerPageCode(@RequestBody UserManagerQueryRequest userManagerQueryRequest) {
        return R.ok((Object)this.userManagerService.queryUserManagerPageCode(userManagerQueryRequest));
    }

    @ApiOperation(value="\u7528\u6237\u767b\u5f55")
    @PostMapping(value={"/logOn"})
    public R<Boolean> logOn(@RequestBody SimpleUserManagerQueryRequest s) {
        return R.ok((Object)this.userManagerService.logOn(s));
    }

    @ApiOperation(value="\u65b0\u5efa\u7528\u6237\u7ba1\u7406")
    @PostMapping(value={"/addUserManager"})
    public R<Boolean> addUserManager(@RequestBody UserManagerRequest userManagerRequest) {
        return R.ok((Object)this.userManagerService.addUserManager(userManagerRequest));
    }

    @ApiOperation(value="\u7f16\u8f91\u7528\u6237\u7ba1\u7406")
    @PostMapping(value={"/editUserManager"})
    public R<Boolean> editUserManager(@RequestBody UserManagerRequest userManagerRequest) {
        this.userManagerService.kickOffLine(userManagerRequest.getId());
        return R.ok((Object)this.userManagerService.editUserManager(userManagerRequest));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryDetail"})
    public R<UserManagerRequest> queryDetail(@RequestParam(value="id") Long id) {
        return R.ok((Object)this.userManagerService.queryDetail(id));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u8fc7\u671f\u65f6\u95f4")
    @PostMapping(value={"/updateEndTime"})
    public R updateEndTime(@RequestBody UserUpdateEndTimeRequest request) {
        this.userManagerService.updateEndTime(request.getIds(), request.getEndTime());
        if (ObjectUtils.isNotEmpty((Object)request) && ObjectUtils.isNotEmpty((Object)request.getIds())) {
            for (Long id : request.getIds()) {
                this.userManagerService.kickOffLine(id);
            }
        }
        return new R().setMsg("\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u65b0\u5efa\u52a0\u901f\u5957\u9910")
    @PostMapping(value={"/addSpeedPackage"})
    public R<Boolean> addSpeedPackage(@RequestBody SpeedPackageRequest speedPackageRequest) {
        return R.ok((Object)this.userManagerService.addSpeedPackage(speedPackageRequest));
    }

    @ApiOperation(value="\u4fee\u6539\u5957\u9910")
    @PostMapping(value={"/editPackage"})
    public R<Boolean> editPackage(@RequestBody EditPackageInfoRequest e) {
        this.userManagerService.kickOffLine(e.getId());
        return R.ok((Object)this.userManagerService.editPackage(e));
    }

    @ApiOperation(value="\u63d0\u4e0b\u7ebf")
    @GetMapping(value={"/kickOffLine"})
    public R<Boolean> kickOffLine(@RequestParam(value="id") Long id) {
        return R.ok((Object)this.userManagerService.kickOffLine(id));
    }

    @ApiOperation(value="\u7528\u6237\u7ba1\u7406\u4e0b\u8f7dexcel\u6587\u4ef6")
    @PostMapping(value={"/downUserExcel"})
    public void downNasExcel(@RequestBody UserManagerQueryRequest userManagerQueryRequest, HttpServletResponse response) throws IOException {
        List packageGroupManagerExcelList = this.userManagerService.downData2Excel(userManagerQueryRequest);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u7528\u6237\u7ba1\u7406", "\u7528\u6237\u7ba1\u7406", ExcelType.XSSF), UserManagerExcel.class, (Collection)packageGroupManagerExcelList);
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u7528\u6237\u7ba1\u7406");
    }

    @ApiOperation(value="excel\u5bfc\u5165")
    @PostMapping(value={"/uploadUserExcel/{projectType}"})
    public R<String> uploadUserExcel(@RequestParam(value="file") MultipartFile file, @PathVariable(value="projectType") String projectType) throws IOException {
        UploadUserManagerListener u = new UploadUserManagerListener(this.userManagerService, this.subPackageGroupManagerService, this.customBrandFilesClient, projectType);
        EasyExcel.read((InputStream)file.getInputStream(), UploadUserManagerExcel.class, (ReadListener)u).sheet().doRead();
        List errorList = u.getErrorList();
        if (CollectionUtils.isEmpty((Collection)errorList)) {
            return R.ok((Object)"excel\u89e3\u6790\u6210\u529f\uff01");
        }
        return R.failed((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u683c\u5f0f\uff0c\u9879\u76ee\u540d\u79f0\uff0c\u5957\u9910\u540d\u79f0\u662f\u5426\u5b58\u5728");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/downloadTemplate"})
    @ApiOperation(value="\u5546\u5199\u5bbd\u5e26\u7528\u6237\u6a21\u7248\u4e0b\u8f7d")
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u5199\u5bbd\u5e26\u7528\u6237\u6a21\u7248.xls", "UTF-8"));
        InputStream input = null;
        OutputStream output = null;
        try {
            InputStream inputStream;
            ClassPathResource classPathResource = new ClassPathResource("\u5546\u5199\u5bbd\u5e26\u7528\u6237\u6a21\u7248.xls");
            input = inputStream = classPathResource.getInputStream();
            output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/sendCheckCode"})
    public R<Boolean> sendCheckCode(@RequestParam(value="phone") String phone) {
        return R.ok((Object)this.userManagerService.sendCheckCode(phone));
    }

    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/register"})
    public R<Boolean> register(@RequestBody SimpleUserManagerQueryRequest s) {
        return R.ok((Object)this.userManagerService.register(s));
    }
}

