/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.inboyu.iot.internal;

import com.alibaba.fastjson.JSON;
import com.ruoyi.inboyu.iot.IotConfig;
import com.ruoyi.inboyu.iot.IotException;
import com.ruoyi.inboyu.iot.comm.ServiceClient;
import com.ruoyi.inboyu.iot.model.request.BaseRequest;
import com.ruoyi.inboyu.iot.model.response.BaseResponse;
import com.ruoyi.inboyu.iot.utils.SignUtils;
import com.ruoyi.inboyu.iot.utils.UUIDUtils;

public abstract class Operation {
    protected ServiceClient client;
    protected IotConfig iotConfig;

    protected Operation(IotConfig iotConfig, ServiceClient client) {
        this.iotConfig = iotConfig;
        this.client = client;
    }

    protected BaseResponse doOperation(BaseRequest request, String path) {
        this.createBaseRequest((Object)request);
        BaseResponse response = this.client.sendPostRequest(path, JSON.toJSONString((Object)request));
        return response;
    }

    protected <T> BaseRequest<T> createBaseRequest(T data) {
        BaseRequest request = new BaseRequest();
        long timestamp = System.currentTimeMillis();
        request.setAppKey(this.iotConfig.getAppKey());
        request.setTimeStamp(Long.valueOf(timestamp));
        request.setRequestId(UUIDUtils.get());
        request.setData(data);
        String sign = SignUtils.sign((String)this.iotConfig.getReqPriKey(), (String)this.iotConfig.getAppKey(), data, (long)timestamp);
        request.setSig(sign);
        return request;
    }

    protected void checkSign(BaseResponse response) {
        boolean result = SignUtils.checkSign((String)this.iotConfig.getRespPubKey(), (BaseResponse)response);
        if (!result) {
            throw new IotException("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
        }
    }
}

