/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.inboyu.iot.utils;

import com.alibaba.fastjson.JSON;
import com.ruoyi.inboyu.iot.IotException;
import com.ruoyi.inboyu.iot.model.response.BaseResponse;
import com.ruoyi.inboyu.iot.utils.MapUtil;
import com.ruoyi.inboyu.iot.utils.RSAUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import org.apache.poi.ss.formula.functions.T;

public class SignUtils {
    public static final String NULL_JSON = "null";

    public static String sign(String reqPriKey, String appKey, Object data, long timestamp) {
        String sign;
        String jsonStr = data instanceof String ? (String)data : JSON.toJSONString((Object)data);
        Map map = (Map)JSON.parseObject((String)jsonStr, Map.class);
        String msg = appKey + MapUtil.sortMapByKey((Map)map) + timestamp;
        try {
            sign = RSAUtil.sign((PrivateKey)RSAUtil.generatePrivateKey((String)reqPriKey), (String)msg);
        }
        catch (Exception e) {
            throw new IotException("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
        return sign;
    }

    public static String sign(String reqPriKey, String appKey, String data, long timestamp) {
        String sign;
        Map map = (Map)JSON.parseObject((String)data, Map.class);
        String msg = appKey + MapUtil.sortMapByKey((Map)map) + timestamp;
        try {
            sign = RSAUtil.sign((PrivateKey)RSAUtil.generatePrivateKey((String)reqPriKey), (String)msg);
        }
        catch (Exception e) {
            throw new IotException("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
        return sign;
    }

    public static boolean checkSign(String respPubKey, BaseResponse response) {
        boolean result;
        try {
            PublicKey publicKey = RSAUtil.getPublicKeyFromString((String)respPubKey);
            String appKey = response.getAppKey();
            Long timestamp = response.getTimeStamp();
            T data = response.getData();
            String jsonStr = JSON.toJSONString((Object)data);
            Map map = null;
            if (!NULL_JSON.equals(jsonStr)) {
                map = (Map)JSON.parseObject((String)jsonStr, Map.class);
            }
            String sortStr = null;
            if (map != null) {
                sortStr = MapUtil.sortMapByKey((Map)map);
            }
            String msg = appKey + sortStr + timestamp;
            result = RSAUtil.verify((PublicKey)publicKey, (String)msg, (String)response.getSig());
        }
        catch (Exception e) {
            throw new IotException("\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }
}

