/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.listener;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.util.ListUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.dto.TempProjectDto;
import com.ruoyi.dto.UploadUserManagerExcel;
import com.ruoyi.entity.SubPackageGroupManager;
import com.ruoyi.entity.UserManager;
import com.ruoyi.feignClientApi.CustomBrandFilesClient;
import com.ruoyi.feignClientApi.CustomProjectArchiveInformationDTO;
import com.ruoyi.service.ISubPackageGroupManagerService;
import com.ruoyi.service.IUserManagerService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadUserManagerListener
implements ReadListener<UploadUserManagerExcel> {
    private static final Logger log = LoggerFactory.getLogger(UploadUserManagerListener.class);
    private static final int BATCH_COUNT = 100;
    private List<UploadUserManagerExcel> cachedDataList = ListUtils.newArrayListWithExpectedSize((int)100);
    private List<UploadUserManagerExcel> errorList = new ArrayList();
    private final IUserManagerService userManagerService;
    private final CustomBrandFilesClient customBrandFilesClient;
    private final String projectType;
    private final ISubPackageGroupManagerService subPackageGroupManagerService;

    public List<UploadUserManagerExcel> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(List<UploadUserManagerExcel> errorList) {
        this.errorList = errorList;
    }

    public UploadUserManagerListener(IUserManagerService userManagerService, ISubPackageGroupManagerService subPackageGroupManagerService, CustomBrandFilesClient customBrandFilesClient, String projectType) {
        this.userManagerService = userManagerService;
        this.projectType = projectType;
        this.subPackageGroupManagerService = subPackageGroupManagerService;
        this.customBrandFilesClient = customBrandFilesClient;
    }

    public void invoke(UploadUserManagerExcel data, AnalysisContext context) {
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 100) {
            List userManagerList = this.cachedDataList.stream().map(m -> {
                TempProjectDto tempProjectDto = this.userManagerService.queryProjectNameService(m.getProjectName());
                UserManager userManager = new UserManager();
                if (tempProjectDto == null) {
                    userManager.setDataFlag(true);
                    this.errorList.add(m);
                } else {
                    userManager.setProjectCode(tempProjectDto.getProjectCode());
                }
                SubPackageGroupManager s = (SubPackageGroupManager)this.subPackageGroupManagerService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(SubPackageGroupManager::getSubPackageGroupName, (Object)m.getPackageName())).eq(SubPackageGroupManager::getIsDeleted, (Object)0)).eq(SubPackageGroupManager::getStatus, (Object)"1"), false);
                if (s == null) {
                    userManager.setDataFlag(true);
                    this.errorList.add(m);
                } else {
                    userManager.setPackageCode(s.getSubPackageGroupCode());
                    userManager.setPackageName(s.getSubPackageGroupName());
                    userManager.setPrice(s.getStandardTariff());
                }
                R allCustomProjectArchiveInformation = this.customBrandFilesClient.getAllCustomProjectArchiveInformation();
                if (allCustomProjectArchiveInformation == null || ObjectUtil.isEmpty((Object)allCustomProjectArchiveInformation.getData())) {
                    userManager.setDataFlag(true);
                    this.errorList.add(m);
                } else {
                    List data1 = (List)allCustomProjectArchiveInformation.getData();
                    CustomProjectArchiveInformationDTO customProjectArchiveInformationDTO = data1.stream().filter(f -> f.getProjectName().equals(m.getProjectName())).findFirst().orElse(new CustomProjectArchiveInformationDTO());
                    userManager.setCity(customProjectArchiveInformationDTO.getCity());
                }
                userManager.setProjectName(m.getProjectName());
                userManager.setRoomNo(m.getRoomNo());
                userManager.setBroadbandUser(m.getBroadbandUser());
                userManager.setBroadbandPassword(m.getBroadbandPassword());
                userManager.setPackageName(m.getPackageName());
                try {
                    userManager.setBeginTime(LocalDateTime.parse(m.getBeginTime(), DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm")));
                    userManager.setEndTime(LocalDateTime.parse(m.getEndTime(), DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm")));
                }
                catch (Exception e) {
                    userManager.setDataFlag(true);
                    this.errorList.add(m);
                }
                if (StringUtils.equals((CharSequence)this.projectType, (CharSequence)"0")) {
                    userManager.setProjectType("\u516c\u5bd3");
                } else {
                    userManager.setProjectType("\u5546\u5199");
                }
                return userManager;
            }).filter(f -> !f.isDataFlag()).collect(Collectors.toList());
            List broadbandUserList = userManagerList.stream().map(UserManager::getBroadbandUser).collect(Collectors.toList());
            this.userManagerService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().in(UserManager::getBroadbandUser, broadbandUserList)).eq(UserManager::getIsDeleted, (Object)0));
            this.userManagerService.saveBatch(userManagerList);
            this.cachedDataList = ListUtils.newArrayListWithExpectedSize((int)100);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (CollectionUtils.isNotEmpty((Collection)this.cachedDataList)) {
            List userManagerList = this.cachedDataList.stream().map(m -> {
                TempProjectDto tempProjectDto = this.userManagerService.queryProjectNameService(m.getProjectName());
                UserManager userManager = new UserManager();
                if (tempProjectDto == null) {
                    userManager.setDataFlag(true);
                    this.errorList.add(m);
                } else {
                    userManager.setPackageCode(tempProjectDto.getProjectCode());
                }
                SubPackageGroupManager s = (SubPackageGroupManager)this.subPackageGroupManagerService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(SubPackageGroupManager::getSubPackageGroupName, (Object)m.getPackageName())).eq(SubPackageGroupManager::getIsDeleted, (Object)0)).eq(SubPackageGroupManager::getStatus, (Object)"1"), false);
                if (s == null) {
                    userManager.setDataFlag(true);
                    this.errorList.add(m);
                } else {
                    userManager.setPrice(s.getStandardTariff());
                }
                R allCustomProjectArchiveInformation = this.customBrandFilesClient.getAllCustomProjectArchiveInformation();
                if (allCustomProjectArchiveInformation == null || ObjectUtil.isEmpty((Object)allCustomProjectArchiveInformation.getData())) {
                    userManager.setDataFlag(true);
                    this.errorList.add(m);
                } else {
                    List data1 = (List)allCustomProjectArchiveInformation.getData();
                    CustomProjectArchiveInformationDTO customProjectArchiveInformationDTO = data1.stream().filter(f -> f.getProjectName().equals(m.getProjectName())).findFirst().orElse(new CustomProjectArchiveInformationDTO());
                    userManager.setCity(customProjectArchiveInformationDTO.getCity());
                }
                userManager.setProjectName(m.getProjectName());
                userManager.setRoomNo(m.getRoomNo());
                userManager.setBroadbandUser(m.getBroadbandUser());
                userManager.setBroadbandPassword(m.getBroadbandPassword());
                userManager.setPackageName(m.getPackageName());
                try {
                    userManager.setBeginTime(LocalDateTime.parse(m.getBeginTime(), DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm")));
                    userManager.setEndTime(LocalDateTime.parse(m.getEndTime(), DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm")));
                }
                catch (Exception e) {
                    userManager.setDataFlag(true);
                    this.errorList.add(m);
                }
                if (StringUtils.equals((CharSequence)this.projectType, (CharSequence)"0")) {
                    userManager.setProjectType("\u516c\u5bd3");
                } else {
                    userManager.setProjectType("\u5546\u5199");
                }
                return userManager;
            }).filter(f -> !f.isDataFlag()).collect(Collectors.toList());
            this.userManagerService.saveBatch(userManagerList);
        }
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }
}

