/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.portal.packet;

import com.ruoyi.portal.PortalException;
import com.ruoyi.portal.utils.PortalUtils;

public class PortalAttribute {
    private int attributeType = -1;
    private byte[] attributeData = null;

    public PortalAttribute() {
    }

    public PortalAttribute(int attributeType, byte[] attributeData) {
        this.attributeType = attributeType;
        this.attributeData = attributeData;
    }

    public int getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(int attributeType) {
        if (attributeType < 0 || attributeType > 255) {
            throw new IllegalArgumentException("attribute type invalid: " + attributeType);
        }
        this.attributeType = attributeType;
    }

    public byte[] getAttributeData() {
        return this.attributeData;
    }

    public void setAttributeData(byte[] attributeData) {
        if (attributeData == null) {
            throw new NullPointerException("attribute data is null");
        }
        this.attributeData = attributeData;
    }

    public void setAttributeValue(String value) {
        throw new RuntimeException("cannot set the value of attribute " + this.attributeType + " as a string");
    }

    public String getAttributeValue() {
        return PortalUtils.getHexString((byte[])this.getAttributeData());
    }

    public String getAttributeAsStr() {
        return PortalUtils.decodeString((byte[])this.getAttributeData());
    }

    public byte[] encodeAttribute() {
        if (this.getAttributeType() == -1) {
            throw new IllegalArgumentException("attribute type not set");
        }
        if (this.attributeData == null) {
            throw new NullPointerException("attribute data not set");
        }
        byte[] attr = new byte[2 + this.attributeData.length];
        attr[0] = (byte)this.getAttributeType();
        attr[1] = (byte)(2 + this.attributeData.length);
        System.arraycopy(this.attributeData, 0, attr, 2, this.attributeData.length);
        return attr;
    }

    public void decodeAttribute(byte[] data, int offset, int length) throws PortalException {
        if (length < 2) {
            throw new PortalException("attribute length too small: " + length);
        }
        int attrType = data[offset] & 0xFF;
        int attrLen = data[offset + 1] & 0xFF;
        byte[] attrData = new byte[attrLen - 2];
        System.arraycopy(data, offset + 2, attrData, 0, attrLen - 2);
        this.setAttributeType((int)((byte)attrType));
        this.setAttributeData(attrData);
    }

    protected String getTypeName(int type) {
        switch (type) {
            case 10: {
                return "BasIp";
            }
            case 255: {
                return "Mac";
            }
            case 4: {
                return "ChapPassword";
            }
            case 2: {
                return "Password";
            }
            case 1: {
                return "Username";
            }
            case 3: {
                return "Challenge";
            }
            case 8: {
                return "Port";
            }
            case 5: {
                return "Textinfo";
            }
        }
        return String.format("Unknow Type (%s)", type);
    }

    public String toString() {
        String fmt = "%s (len=%s):%s";
        int attrlen = this.attributeData.length + 2;
        switch (this.getAttributeType()) {
            case 10: {
                return String.format(fmt, this.getTypeName(this.attributeType), attrlen, PortalUtils.decodeIpv4((byte[])this.getAttributeData()));
            }
            case 255: {
                return String.format(fmt, this.getTypeName(this.attributeType), attrlen, PortalUtils.decodeMacAddr((byte[])this.getAttributeData()));
            }
            case 4: {
                return String.format(fmt, this.getTypeName(this.attributeType), attrlen, this.getAttributeValue());
            }
            case 2: {
                return String.format(fmt, this.getTypeName(this.attributeType), attrlen, PortalUtils.decodeString((byte[])this.getAttributeData()));
            }
            case 1: {
                return String.format(fmt, this.getTypeName(this.attributeType), attrlen, PortalUtils.decodeString((byte[])this.getAttributeData()));
            }
            case 3: {
                return String.format(fmt, this.getTypeName(this.attributeType), attrlen, this.getAttributeValue());
            }
            case 8: {
                return String.format(fmt, this.getTypeName(this.attributeType), attrlen, PortalUtils.decodeShort((byte[])this.getAttributeData()));
            }
            case 5: {
                return String.format(fmt, this.getTypeName(this.attributeType), attrlen, PortalUtils.decodeString((byte[])this.getAttributeData()));
            }
        }
        return String.format(fmt, this.getTypeName(this.attributeType), attrlen, this.getAttributeValue());
    }
}

