/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.portal.packet;

import com.ruoyi.portal.PortalException;
import com.ruoyi.portal.ValidateUtil;
import com.ruoyi.portal.packet.PortalAttribute;
import com.ruoyi.portal.utils.PortalUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalPacket {
    public static final int REQ_CHALLENGE = 1;
    public static final int ACK_CHALLENGE = 2;
    public static final int REQ_AUTH = 3;
    public static final int ACK_AUTH = 4;
    public static final int REQ_LOGOUT = 5;
    public static final int ACK_LOGOUT = 6;
    public static final int AFF_ACK_AUTH = 7;
    public static final int NTF_LOGOUT = 8;
    public static final int REQ_INFO = 9;
    public static final int ACK_INFO = 10;
    public static final int NTF_USERDISCOVER = 11;
    public static final int NTF_USERIPCHANGE = 12;
    public static final int AFF_NTF_USERIPCHAN = 13;
    public static final int ACK_NTF_LOGOUT = 14;
    public static final int NTF_HEARTBEAT = 15;
    public static final int NTF_USER_HEARTBEAT = 16;
    public static final int ACK_NTF_USER_HEARTBEAT = 17;
    public static final int NTF_CHALLENGE = 18;
    public static final int NTF_USER_NOTIFY = 19;
    public static final int AFF_NTF_USER_NOTIFY = 20;
    public static final int AUTH_CHAP = 0;
    public static final int AUTH_PAP = 1;
    public static final int ATTRIBUTE_MAC_TYPE = 255;
    public static final int ATTRIBUTE_USERNAME_TYPE = 1;
    public static final int ATTRIBUTE_PASSWORD_TYPE = 2;
    public static final int ATTRIBUTE_CHALLENGE_TYPE = 3;
    public static final int ATTRIBUTE_CHAP_PWD_TYPE = 4;
    public static final int ATTRIBUTE_TEXT_INFO_TYPE = 5;
    public static final int ATTRIBUTE_UP_LINK_TYPE = 6;
    public static final int ATTRIBUTE_DOWN_LINK_TYPE = 7;
    public static final int ATTRIBUTE_PORT_TYPE = 8;
    public static final int ATTRIBUTE_BASIP_TYPE = 10;
    public static final int CMCCV1_TYPE = 1;
    public static final int CMCCV2_TYPE = 1;
    public static final int HUAWEIV1_TYPE = 1;
    public static final int HUAWEIV2_TYPE = 2;
    public static final int MAX_PACKET_LENGTH = 1024;
    public static final Map<Integer, String> ACK_CHALLENGE_ERRORS = new HashMap();
    public static final Map<Integer, String> ACK_AUTH_ERRORS = new HashMap();
    public static final Map<Integer, String> ACK_LOGOUT_ERRORS = new HashMap();
    public static final Map<Integer, String> ACK_INFO_ERRORS = new HashMap();
    private int ver = 1;
    private int type;
    private int isChap = 1;
    private int rsv = 0;
    private short serialNo = 0;
    private short reqId = 0;
    private String userIp;
    private short userPort = 0;
    private int errCode = 0;
    private int attrNum = 0;
    private byte[] authenticator;
    private String secret;
    private List<PortalAttribute> attributes = new ArrayList();
    private static AtomicInteger nextSerialNo;
    private static AtomicInteger nextReqId;
    private static SecureRandom random;
    private MessageDigest md5Digest = null;

    public static short getNextSerialNo() {
        int val = nextSerialNo.incrementAndGet();
        if (val >= Short.MAX_VALUE) {
            nextSerialNo.set(0);
            val = 0;
        }
        return (short)val;
    }

    public static short getNextReqId() {
        int val = nextReqId.incrementAndGet();
        if (val >= Short.MAX_VALUE) {
            nextReqId.set(0);
            val = 0;
        }
        return (short)val;
    }

    public String getErrMessage() {
        if (this.getType() == 1 || this.getType() == 3 || this.getType() == 7) {
            return "";
        }
        switch (this.getType()) {
            case 2: {
                return (String)ACK_CHALLENGE_ERRORS.get(this.getErrCode());
            }
            case 4: {
                return (String)ACK_AUTH_ERRORS.get(this.getErrCode());
            }
            case 6: {
                return (String)ACK_LOGOUT_ERRORS.get(this.getErrCode());
            }
            case 10: {
                return (String)ACK_INFO_ERRORS.get(this.getErrCode());
            }
        }
        return "";
    }

    public static int getVerbyName(String name) {
        switch (name) {
            case "cmccv1": {
                return 1;
            }
            case "cmccv2": {
                return 1;
            }
            case "huaweiv1": {
                return 1;
            }
            case "huaweuiv2": {
                return 2;
            }
        }
        return 1;
    }

    public String getPacketTypeName() {
        switch (this.getType()) {
            case 1: {
                return "REQ_CHALLENGE";
            }
            case 2: {
                return "ACK_CHALLENGE";
            }
            case 3: {
                return "REQ_AUTH";
            }
            case 4: {
                return "ACK_AUTH";
            }
            case 5: {
                return "REQ_LOGOUT";
            }
            case 6: {
                return "ACK_LOGOUT";
            }
            case 7: {
                return "AFF_ACK_AUTH";
            }
            case 8: {
                return "NTF_LOGOUT";
            }
            case 9: {
                return "REQ_INFO";
            }
            case 10: {
                return "ACK_INFO";
            }
            case 11: {
                return "NTF_USERDISCOVER";
            }
            case 12: {
                return "NTF_USERIPCHANGE";
            }
            case 13: {
                return "AFF_NTF_USERIPCHAN";
            }
            case 14: {
                return "ACK_NTF_LOGOUT";
            }
            case 15: {
                return "NTF_HEARTBEAT";
            }
            case 16: {
                return "NTF_USER_HEARTBEAT";
            }
            case 17: {
                return "ACK_NTF_USER_HEARTBEAT";
            }
            case 18: {
                return "NTF_CHALLENGE";
            }
            case 19: {
                return "NTF_USER_NOTIFY";
            }
            case 20: {
                return "AFF_NTF_USER_NOTIFY";
            }
        }
        return "Unknown (" + this.getType() + ")";
    }

    public PortalPacket() {
    }

    public PortalPacket(byte[] src) throws PortalException {
        this.decodePacket(IoBuffer.wrap((byte[])src));
    }

    public PortalPacket(int ver, int type, String userIp, short serialNo, short reqId, String secret, int isChap) {
        this.setVer(ver);
        this.setType(type);
        this.setUserIp(userIp);
        this.setSerialNo(serialNo);
        this.setReqId(reqId);
        this.setSecret(secret);
        this.setIsChap(isChap);
    }

    public IoBuffer encodePacket() throws PortalException {
        IoBuffer buffer = IoBuffer.allocate((int)16);
        buffer.setAutoExpand(true);
        buffer.put((byte)this.getVer());
        buffer.put((byte)this.getType());
        buffer.put((byte)this.getIsChap());
        buffer.put((byte)this.getRsv());
        buffer.putShort(this.getSerialNo());
        buffer.putShort(this.getReqId());
        buffer.put(PortalUtils.encodeIpV4((String)this.getUserIp()));
        buffer.putShort(this.getUserPort());
        buffer.put((byte)this.getErrCode());
        buffer.put((byte)this.getAttrNum());
        if (this.getVer() == 2) {
            byte[] auth = this.getAuthenticator();
            if (auth == null) {
                throw new PortalException("Request authenticator is empty");
            }
            buffer.put(this.getAuthenticator());
        }
        for (PortalAttribute attr : this.getAttributes()) {
            buffer.put(attr.encodeAttribute());
        }
        buffer.flip();
        return buffer;
    }

    public void decodePacket(IoBuffer buff) throws PortalException {
        buff.rewind();
        if (buff.remaining() > 1024) {
            throw new PortalException("Packet size is too large");
        }
        byte ver = buff.get();
        if (ver != 1 && ver != 2) {
            throw new PortalException("Packet ver error");
        }
        this.setVer((int)ver);
        this.setType((int)buff.get());
        byte ischap = buff.get();
        if (ischap != 0 && ischap != 1) {
            throw new PortalException("Packet chap/pap error");
        }
        this.setIsChap((int)ischap);
        this.setRsv((int)buff.get());
        this.setSerialNo(buff.getShort());
        this.setReqId(buff.getShort());
        byte[] userIpdata = new byte[4];
        buff.get(userIpdata);
        this.setUserIp(PortalUtils.decodeIpv4((byte[])userIpdata));
        this.setUserPort(buff.getShort());
        this.setErrCode((int)buff.get());
        this.setAttrNum((int)buff.get());
        if (this.getVer() == 2) {
            byte[] auth = new byte[16];
            buff.get(auth);
            this.setAuthenticator(auth);
        }
        for (int i = 0; i < this.getAttrNum(); ++i) {
            PortalAttribute attr = new PortalAttribute();
            attr.setAttributeType((int)buff.get());
            byte len = buff.get();
            if (len == 2 || len == 0) continue;
            byte[] attrdata = new byte[len - 2];
            buff.get(attrdata);
            attr.setAttributeData(attrdata);
        }
    }

    protected byte[] createRequestAuthenticator(String sharedSecret) {
        byte[] secretBytes = PortalUtils.encodeString((String)sharedSecret);
        byte[] randomBytes = new byte[16];
        MessageDigest md5 = this.getMd5Digest();
        md5.reset();
        md5.update((byte)this.getVer());
        md5.update((byte)this.getType());
        md5.update((byte)this.getIsChap());
        md5.update((byte)this.getRsv());
        md5.update(PortalUtils.encodeShort((short)this.getSerialNo()));
        md5.update(PortalUtils.encodeShort((short)this.getReqId()));
        md5.update(PortalUtils.encodeIpV4((String)this.getUserIp()));
        md5.update(PortalUtils.encodeShort((short)this.getUserPort()));
        md5.update((byte)this.getErrCode());
        md5.update((byte)this.attributes.size());
        md5.update(randomBytes);
        for (PortalAttribute attr : this.attributes) {
            md5.update(attr.encodeAttribute());
        }
        md5.update(PortalUtils.encodeString((String)sharedSecret));
        return md5.digest();
    }

    protected void updateRequestAuthenticator(String secret) {
        if (this.getVer() == 2) {
            this.setAuthenticator(this.createRequestAuthenticator(secret));
        }
    }

    public void updateResponseAuthenticator(String secret) {
        if (this.getVer() == 2) {
            this.setAuthenticator(this.createRequestAuthenticator(secret));
        }
    }

    protected byte[] createResponseAuthenticator(String sharedSecret, byte[] requestAuthenticator) {
        MessageDigest md5 = this.getMd5Digest();
        md5.reset();
        md5.update((byte)this.getVer());
        md5.update((byte)this.getType());
        md5.update((byte)this.getIsChap());
        md5.update((byte)this.getRsv());
        md5.update(PortalUtils.encodeShort((short)this.getSerialNo()));
        md5.update(PortalUtils.encodeShort((short)this.getReqId()));
        md5.update(PortalUtils.encodeIpV4((String)this.getUserIp()));
        md5.update(PortalUtils.encodeShort((short)this.getUserPort()));
        md5.update((byte)this.getErrCode());
        md5.update((byte)this.attributes.size());
        md5.update(requestAuthenticator);
        for (PortalAttribute attr : this.attributes) {
            md5.update(attr.encodeAttribute());
        }
        md5.update(PortalUtils.encodeString((String)sharedSecret));
        return md5.digest();
    }

    public void checkResponseAuthenticator(String sharedSecret, byte[] requestAuthenticator) throws PortalException {
        if (requestAuthenticator == null) {
            return;
        }
        byte[] authenticator = this.createResponseAuthenticator(sharedSecret, requestAuthenticator);
        byte[] receivedAuth = this.getAuthenticator();
        for (int i = 0; i < 16; ++i) {
            if (authenticator[i] == receivedAuth[i]) continue;
            throw new PortalException("response authenticator invalid");
        }
    }

    public static PortalPacket createMessage(int ver, int type, String userIp, short serialNo, short reqId, String secret, int isChap) {
        PortalPacket message = new PortalPacket(ver, type, userIp, serialNo, reqId, secret, isChap);
        message.updateRequestAuthenticator(secret);
        return message;
    }

    public static PortalPacket createReqChallenge(int ver, String userIp, String secret, String mac) {
        PortalPacket message = PortalPacket.createMessage((int)ver, (int)1, (String)userIp, (short)PortalPacket.getNextSerialNo(), (short)0, (String)secret, (int)0);
        if (ValidateUtil.isMacAddress((String)mac)) {
            message.addAttribute(new PortalAttribute(255, PortalUtils.encodeMacAddr((String)mac)));
        }
        return message;
    }

    public static PortalPacket createReqAuth(int ver, String userIp, String username, String password, short reqId, byte[] challenge, String secret, String basIp, int isChap, String mac) {
        PortalPacket message = PortalPacket.createMessage((int)ver, (int)3, (String)userIp, (short)PortalPacket.getNextSerialNo(), (short)reqId, (String)secret, (int)isChap);
        message.addAttribute(new PortalAttribute(1, PortalUtils.encodeString((String)username)));
        if (isChap == 0) {
            byte[] userPassword = PortalUtils.chapEncryption((String)password, (int)reqId, (byte[])challenge);
            message.addAttribute(new PortalAttribute(4, userPassword));
        } else {
            message.addAttribute(new PortalAttribute(2, PortalUtils.encodeString((String)password)));
        }
        if (ValidateUtil.isMacAddress((String)mac)) {
            message.addAttribute(new PortalAttribute(255, PortalUtils.encodeMacAddr((String)mac)));
        }
        if (ValidateUtil.isIP((String)basIp)) {
            message.addAttribute(new PortalAttribute(10, PortalUtils.encodeIpV4((String)basIp)));
        }
        return message;
    }

    public static PortalPacket createReqLogout(int ver, String userIp, String secret, String basIp, short serialNo, int isChap, String mac) {
        short _serialNo = serialNo == -1 ? PortalPacket.getNextSerialNo() : serialNo;
        PortalPacket message = PortalPacket.createMessage((int)ver, (int)5, (String)userIp, (short)_serialNo, (short)0, (String)secret, (int)isChap);
        if (ValidateUtil.isMacAddress((String)mac)) {
            message.addAttribute(new PortalAttribute(255, PortalUtils.encodeMacAddr((String)mac)));
        }
        if (ValidateUtil.isIP((String)basIp)) {
            message.addAttribute(new PortalAttribute(10, PortalUtils.encodeIpV4((String)basIp)));
        }
        return message;
    }

    public static PortalPacket createAffAckAuth(int ver, String userIp, String secret, String basIp, short serialNo, short reqId, int isChap, String mac) {
        short _serialNo = serialNo == -1 ? PortalPacket.getNextSerialNo() : serialNo;
        PortalPacket message = PortalPacket.createMessage((int)ver, (int)7, (String)userIp, (short)_serialNo, (short)reqId, (String)secret, (int)isChap);
        if (ValidateUtil.isMacAddress((String)mac)) {
            message.addAttribute(new PortalAttribute(255, PortalUtils.encodeMacAddr((String)mac)));
        }
        if (ValidateUtil.isIP((String)basIp)) {
            message.addAttribute(new PortalAttribute(10, PortalUtils.encodeIpV4((String)basIp)));
        }
        return message;
    }

    public static PortalPacket createReqInfo(int ver, String userIp, String secret, String basIp, short serialNo, int isChap, String mac) {
        short _serialNo = serialNo == -1 ? PortalPacket.getNextSerialNo() : serialNo;
        PortalPacket message = PortalPacket.createMessage((int)ver, (int)9, (String)userIp, (short)_serialNo, (short)0, (String)secret, (int)isChap);
        if (ValidateUtil.isMacAddress((String)mac)) {
            message.addAttribute(new PortalAttribute(255, PortalUtils.encodeMacAddr((String)mac)));
        }
        if (ValidateUtil.isIP((String)basIp)) {
            message.addAttribute(new PortalAttribute(10, PortalUtils.encodeIpV4((String)basIp)));
        }
        return message;
    }

    public static PortalPacket createNtfHeart(int ver, String secret, String basIp, int isChap, String mac) {
        PortalPacket message = PortalPacket.createMessage((int)ver, (int)15, (String)"0.0.0.0", (short)PortalPacket.getNextSerialNo(), (short)0, (String)secret, (int)isChap);
        if (ValidateUtil.isMacAddress((String)mac)) {
            message.addAttribute(new PortalAttribute(255, PortalUtils.encodeMacAddr((String)mac)));
        }
        if (ValidateUtil.isIP((String)basIp)) {
            message.addAttribute(new PortalAttribute(10, PortalUtils.encodeIpV4((String)basIp)));
        }
        return message;
    }

    public String getUsername() {
        for (PortalAttribute attr : this.attributes) {
            if (attr.getAttributeType() != 1) continue;
            return attr.getAttributeAsStr();
        }
        return null;
    }

    public String getPassword() {
        for (PortalAttribute attr : this.attributes) {
            if (attr.getAttributeType() != 2) continue;
            return attr.getAttributeAsStr();
        }
        return null;
    }

    public byte[] getChallenge() {
        for (PortalAttribute attr : this.attributes) {
            if (attr.getAttributeType() != 3) continue;
            return attr.getAttributeData();
        }
        return null;
    }

    public byte[] getChapPassword() {
        for (PortalAttribute attr : this.attributes) {
            if (attr.getAttributeType() != 4) continue;
            return attr.getAttributeData();
        }
        return null;
    }

    public String getTextInfo() {
        for (PortalAttribute attr : this.attributes) {
            if (attr.getAttributeType() != 4) continue;
            return attr.getAttributeAsStr();
        }
        return null;
    }

    public String getBasIp() {
        for (PortalAttribute attr : this.attributes) {
            if (attr.getAttributeType() != 10) continue;
            return PortalUtils.decodeIpv4((byte[])attr.getAttributeData());
        }
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(String.format("%s -> ", this.getPacketTypeName()));
        s.append(String.format("Ver=%s,", this.getVer()));
        s.append(String.format("Type=%s,", this.getType()));
        s.append(String.format("Chap/Pap=%s,", this.getIsChap()));
        s.append(String.format("SerialNo=%s,", this.getSerialNo()));
        s.append(String.format("ReqId=%s,", this.getReqId()));
        s.append(String.format("UserIp=%s,", this.getUserIp()));
        s.append(String.format("UserPort=%s,", this.getUserPort()));
        s.append(String.format("ErrCode=%s,", this.getErrCode()));
        s.append(String.format("AttrNum=%s,", this.attributes.size()));
        s.append("\nAttributes::::");
        for (PortalAttribute attr : this.attributes) {
            s.append("\n");
            s.append(String.format("\t%s", attr.toString()));
        }
        return s.toString();
    }

    public byte[] getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(byte[] authenticator) {
        this.authenticator = authenticator;
    }

    public List<PortalAttribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(PortalAttribute attribute) {
        this.attributes.add(attribute);
    }

    public int getVer() {
        return this.ver;
    }

    public void setVer(int ver) {
        this.ver = ver;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getIsChap() {
        return this.isChap;
    }

    public void setIsChap(int isChap) {
        this.isChap = isChap;
    }

    public int getRsv() {
        return this.rsv;
    }

    public void setRsv(int rsv) {
        this.rsv = rsv;
    }

    public short getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(short serialNo) {
        this.serialNo = serialNo;
    }

    public short getReqId() {
        return this.reqId;
    }

    public void setReqId(short reqId) {
        this.reqId = reqId;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public short getUserPort() {
        return this.userPort;
    }

    public void setUserPort(short userPort) {
        this.userPort = userPort;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public int getAttrNum() {
        return this.attributes.size();
    }

    public void setAttrNum(int attrNum) {
        this.attrNum = attrNum;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    protected MessageDigest getMd5Digest() {
        if (this.md5Digest == null) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("md5 digest not available", nsae);
            }
        }
        return this.md5Digest;
    }

    static {
        ACK_CHALLENGE_ERRORS.put(0, "\u8bf7\u6c42Challenge\u6210\u529f");
        ACK_CHALLENGE_ERRORS.put(1, "\u8bf7\u6c42Challenge\u88ab\u62d2\u7edd");
        ACK_CHALLENGE_ERRORS.put(2, "\u94fe\u63a5\u5df2\u7ecf\u5efa\u7acb");
        ACK_CHALLENGE_ERRORS.put(3, "\u6709\u4e00\u4e2a\u7528\u6237\u6b63\u5728\u8ba4\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        ACK_CHALLENGE_ERRORS.put(4, "\u8bf7\u6c42Challenge\u5931\u8d25");
        ACK_AUTH_ERRORS.put(0, "\u7528\u6237\u8ba4\u8bc1\u8bf7\u6c42\u6210\u529f");
        ACK_AUTH_ERRORS.put(1, "\u7528\u6237\u8ba4\u8bc1\u8bf7\u6c42\u88ab\u62d2\u7edd");
        ACK_AUTH_ERRORS.put(2, "\u94fe\u63a5\u5df2\u7ecf\u5efa\u7acb");
        ACK_AUTH_ERRORS.put(3, "\u6709\u4e00\u4e2a\u7528\u6237\u6b63\u5728\u8ba4\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        ACK_AUTH_ERRORS.put(4, "\u7528\u6237\u8ba4\u8bc1\u5931\u8d25");
        ACK_LOGOUT_ERRORS.put(0, "\u7528\u6237\u4e0b\u7ebf\u6210\u529f");
        ACK_LOGOUT_ERRORS.put(1, "\u7528\u6237\u4e0b\u7ebf\u88ab\u62d2\u7edd");
        ACK_LOGOUT_ERRORS.put(2, "\u7528\u6237\u4e0b\u7ebf\u5931\u8d25");
        ACK_LOGOUT_ERRORS.put(3, "\u7528\u6237\u5df2\u7ecf\u79bb\u7ebf");
        ACK_INFO_ERRORS.put(0, "SUCCESS");
        ACK_INFO_ERRORS.put(1, "\u529f\u80fd\u4e0d\u88ab\u652f\u6301");
        ACK_INFO_ERRORS.put(2, "\u6d88\u606f\u5904\u7406\u5931\u8d25");
        nextSerialNo = new AtomicInteger(0);
        nextReqId = new AtomicInteger(0);
        random = new SecureRandom();
    }
}

