/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.radius;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.entity.SubPackageGroupManager;
import com.ruoyi.entity.UserManager;
import com.ruoyi.radius.RadiusAcceptThread;
import com.ruoyi.service.INasManagerService;
import com.ruoyi.service.ISubPackageGroupManagerService;
import com.ruoyi.service.IUserManagerService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tinyradius.packet.AccessRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class RadiusAcceptThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RadiusAcceptThread.class);
    @Autowired
    private IUserManagerService userManagerService;
    @Autowired
    private ISubPackageGroupManagerService subPackageGroupManagerService;
    @Autowired
    private INasManagerService nasManagerService;

    @PostConstruct
    public void init() {
        new Thread((Runnable)this).start();
    }

    @Override
    public void run() {
        1 server = new /* Unavailable Anonymous Inner Class!! */;
        server.start(true, true);
        log.info("Radius Server started.");
        try {
            log.info("\u5f53\u524d\u670d\u52a1\u5668\u7684\u5730\u5740\u662f:{}", (Object)InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private UserManager updateUserInfo(String userName, String nasIp, String acctSessionId, String framedIpAddress, String callingStationId, String nasIdentifier, String acctStatusType) {
        UserManager userManager = (UserManager)this.userManagerService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(UserManager::getBroadbandUser, (Object)userName)).eq(UserManager::getIsDeleted, (Object)0), false);
        if (userManager.getBoyuBroadbandStatus() == 1) {
            return null;
        }
        Boolean bindMacFlag = userManager.getBindMac();
        Boolean bindNasIpFlag = userManager.getBindNasIp();
        Boolean bindNasIdFlag = userManager.getBindNasId();
        UserManager updateUserManager = new UserManager();
        if (bindMacFlag != null && bindMacFlag.booleanValue() && StringUtils.isBlank((CharSequence)userManager.getMacIp())) {
            updateUserManager.setMacIp(callingStationId);
        } else if (bindMacFlag == null || !bindMacFlag.booleanValue()) {
            updateUserManager.setMacIp(callingStationId);
        }
        if (bindNasIpFlag != null && bindNasIpFlag.booleanValue() && StringUtils.isBlank((CharSequence)userManager.getNasIp())) {
            updateUserManager.setNasIp(nasIp);
        } else if (bindNasIpFlag == null || !bindNasIpFlag.booleanValue()) {
            updateUserManager.setNasIp(nasIp);
        }
        if (bindNasIdFlag != null && bindNasIdFlag.booleanValue() && StringUtils.isBlank((CharSequence)userManager.getNasIdentifier())) {
            updateUserManager.setNasIdentifier(nasIdentifier);
        } else if (bindNasIdFlag == null || !bindNasIdFlag.booleanValue()) {
            updateUserManager.setNasIdentifier(nasIdentifier);
        }
        updateUserManager.setId(userManager.getId());
        updateUserManager.setAcctSessionId(acctSessionId);
        updateUserManager.setFramedIpAddress(framedIpAddress);
        updateUserManager.setStatus(StringUtils.equalsAnyIgnoreCase((CharSequence)acctStatusType, (CharSequence[])new CharSequence[]{"Start", "Alive"}) ? "1" : "0");
        this.userManagerService.updateById((Object)updateUserManager);
        return updateUserManager;
    }

    private Result queryBaseInfo(String userName, String callingStationId, String nasIdentifier, String nasIp) {
        String nasIdentifierDB;
        String nasAddressDb;
        String macDb;
        UserManager userManager = (UserManager)this.userManagerService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(UserManager::getBroadbandUser, (Object)userName)).eq(UserManager::getIsDeleted, (Object)0), false);
        if (userManager == null) {
            return Result.builder().flag(false).build();
        }
        Boolean bindMacFlag = userManager.getBindMac();
        Boolean bindNasIpFlag = userManager.getBindNasIp();
        Boolean bindNasIdFlag = userManager.getBindNasId();
        if (bindMacFlag != null && bindMacFlag.booleanValue() && StringUtils.isNotBlank((CharSequence)(macDb = userManager.getMacIp())) && !StringUtils.equals((CharSequence)macDb, (CharSequence)callingStationId)) {
            return Result.builder().flag(false).build();
        }
        if (bindNasIpFlag != null && bindNasIpFlag.booleanValue() && StringUtils.isNotBlank((CharSequence)(nasAddressDb = userManager.getNasIp())) && !StringUtils.equals((CharSequence)nasAddressDb, (CharSequence)nasIp)) {
            return Result.builder().flag(false).build();
        }
        if (bindNasIdFlag != null && bindNasIdFlag.booleanValue() && StringUtils.isNotBlank((CharSequence)(nasIdentifierDB = userManager.getNasIdentifier())) && !StringUtils.equals((CharSequence)nasIdentifierDB, (CharSequence)nasIdentifier)) {
            return Result.builder().flag(false).build();
        }
        Result r = this.queryUserInfoPackage(userManager);
        if (r == null) {
            return Result.builder().flag(false).build();
        }
        long upload = r.getUp() * 128L;
        long down = r.getDown() * 128L;
        return Result.builder().flag(true).expireSec(r.getExpireSec()).down(down).up(upload).upAndDown(upload + "/" + down).build();
    }

    private Result queryUserInfoPackage(UserManager u) {
        String speedPackageCode = u.getSpeedPackageCode();
        if (StringUtils.isNotBlank((CharSequence)speedPackageCode)) {
            long expireTime = Duration.between(LocalDateTime.now(), u.getSpeedPackageEndTime()).getSeconds();
            return this.packageResult(speedPackageCode, expireTime);
        }
        String packageCode = u.getPackageCode();
        long expireTime = Duration.between(LocalDateTime.now(), u.getEndTime()).getSeconds();
        return this.packageResult(packageCode, expireTime);
    }

    private Result packageResult(String packageCode, long expireTime) {
        if (expireTime > 0L) {
            SubPackageGroupManager s = (SubPackageGroupManager)this.subPackageGroupManagerService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(SubPackageGroupManager::getSubPackageGroupCode, (Object)packageCode)).eq(SubPackageGroupManager::getIsDeleted, (Object)0), false);
            return Result.builder().expireSec(expireTime).down(Long.parseLong(s.getDownload())).up(Long.parseLong(s.getUpload())).build();
        }
        return null;
    }

    private boolean verifyPassword(AccessRequest a, String password) {
        if (a.getAuthProtocol().equals("chap")) {
            String chapPassword = a.getAttribute(3).getAttributeValue().replace("0x", "");
            String chapId = StringUtils.substring((String)chapPassword, (int)0, (int)2);
            String chapChallenge = a.getAttribute(60).getAttributeValue().replace("0x", "");
            String md5PassWord = RadiusAcceptThread.calculateMD5((String)(chapId + RadiusAcceptThread.byteArrayToHexString((byte[])password.getBytes()) + chapChallenge));
            String subStrChapPassword = StringUtils.substring((String)chapPassword, (int)(chapPassword.length() - 16));
            String subStrMd5PassWord = StringUtils.substring((String)md5PassWord, (int)(md5PassWord.length() - 16));
            return StringUtils.equalsIgnoreCase((CharSequence)subStrChapPassword, (CharSequence)subStrMd5PassWord);
        }
        return a.getUserPassword().equals(password);
    }

    public static String calculateMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(RadiusAcceptThread.hexStringToByteArray((String)input));
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("calculateMD5\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u662f:", (Throwable)e);
            return "";
        }
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    static /* synthetic */ INasManagerService access$000(RadiusAcceptThread x0) {
        return x0.nasManagerService;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ IUserManagerService access$200(RadiusAcceptThread x0) {
        return x0.userManagerService;
    }

    static /* synthetic */ boolean access$300(RadiusAcceptThread x0, AccessRequest x1, String x2) {
        return x0.verifyPassword(x1, x2);
    }

    static /* synthetic */ Result access$400(RadiusAcceptThread x0, String x1, String x2, String x3, String x4) {
        return x0.queryBaseInfo(x1, x2, x3, x4);
    }

    static /* synthetic */ UserManager access$500(RadiusAcceptThread x0, String x1, String x2, String x3, String x4, String x5, String x6, String x7) {
        return x0.updateUserInfo(x1, x2, x3, x4, x5, x6, x7);
    }
}

