/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.dto.PayAccountManagerRequest;
import com.ruoyi.dto.PayAccountManagerVo;
import com.ruoyi.entity.PayAccountManager;
import com.ruoyi.mapper.PayAccountManagerMapper;
import com.ruoyi.service.IPayAccountManagerService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PayAccountManagerServiceImpl
extends ServiceImpl<PayAccountManagerMapper, PayAccountManager>
implements IPayAccountManagerService {
    public PayAccountManagerVo queryAccount() {
        PayAccountManagerVo payAccountManagerVo = new PayAccountManagerVo();
        List payAccountManagerList = this.list((Wrapper)Wrappers.query().lambda().eq(PayAccountManager::getIsDeleted, (Object)0));
        Map<String, List<PayAccountManager>> map = payAccountManagerList.stream().collect(Collectors.groupingBy(PayAccountManager::getAccountType));
        if (CollectionUtils.isNotEmpty((Collection)map.get("1"))) {
            PayAccountManager p = map.get("1").get(0);
            PayAccountManagerVo.SubAccountManagerVo defaultPayAccount = PayAccountManagerVo.SubAccountManagerVo.builder().id(p.getId()).accountType(p.getAccountType()).mchId(p.getMchId()).privateKey(p.getPrivateKey()).publicKey(p.getPublicKey()).projectCode(p.getProjectCode()).projectName(p.getProjectName()).build();
            payAccountManagerVo.setDefaultPayAccount(defaultPayAccount);
        }
        if (CollectionUtils.isNotEmpty((Collection)map.get("2"))) {
            List projectPayAccountList = map.get("2").stream().map(m -> PayAccountManagerVo.SubAccountManagerVo.builder().id(m.getId()).accountType(m.getAccountType()).mchId(m.getMchId()).privateKey(m.getPrivateKey()).publicKey(m.getPublicKey()).projectCode(m.getProjectCode()).projectName(m.getProjectName()).build()).collect(Collectors.toList());
            payAccountManagerVo.setProjectPayAccountList(projectPayAccountList);
        }
        return payAccountManagerVo;
    }

    public boolean addPayNo(PayAccountManagerRequest p) {
        PayAccountManager payAccountManager = PayAccountManager.builder().accountType(p.getAccountType()).mchId(p.getMchId()).privateKey(p.getPrivateKey()).publicKey(p.getPublicKey()).projectCode(p.getProjectCode()).projectName(p.getProjectName()).createName(SecurityUtils.getLoginUser().getUsername()).createUser(SecurityUtils.getLoginUser().getUserid()).build();
        this.save((Object)payAccountManager);
        return true;
    }

    public boolean editPayNo(PayAccountManagerRequest p) {
        PayAccountManager payAccountManager = PayAccountManager.builder().id(p.getId()).accountType(p.getAccountType()).mchId(p.getMchId()).privateKey(p.getPrivateKey()).publicKey(p.getPublicKey()).projectCode(p.getProjectCode()).projectName(p.getProjectName()).createName(SecurityUtils.getLoginUser().getUsername()).createUser(SecurityUtils.getLoginUser().getUserid()).build();
        this.updateById((Object)payAccountManager);
        return true;
    }

    public Boolean deletePayNo(Long id) {
        return this.updateById((Object)PayAccountManager.builder().id(id).isDeleted(Integer.valueOf(1)).build());
    }
}

