/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.entity.PaymentFeeSetting;
import com.ruoyi.entity.SeparateAccountsAllocation;
import com.ruoyi.mapper.PaymentFeeSettingMapper;
import com.ruoyi.mapper.SeparateAccountsAllocationMapper;
import com.ruoyi.query.PaymentFeeSettingQuery;
import com.ruoyi.service.PaymentFeeSettingService;
import com.ruoyi.service.SeparateAccountsAllocationService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentFeeSettingServiceImpl
extends ServiceImpl<PaymentFeeSettingMapper, PaymentFeeSetting>
implements PaymentFeeSettingService {
    private static final Logger log = LoggerFactory.getLogger(PaymentFeeSettingServiceImpl.class);
    @Resource
    private SeparateAccountsAllocationService separateAccountsAllocationService;
    @Resource
    private SeparateAccountsAllocationMapper accountsAllocationMapper;

    public Page<PaymentFeeSetting> getPage(PaymentFeeSettingQuery query) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)query.getProjectName()), PaymentFeeSetting::getProjectName, (Object)query.getProjectName())).and(ObjectUtil.isNotEmpty((Object)query.getBrandName()), wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrap.like(PaymentFeeSetting::getBrandName, (Object)query.getBrandName())).or()).like(PaymentFeeSetting::getSubbrandName, (Object)query.getBrandName()))).orderByAsc(PaymentFeeSetting::getBrandCode)).orderByAsc(PaymentFeeSetting::getSubbrandCode)).orderByAsc(PaymentFeeSetting::getProjectCode);
        Page page = (Page)this.page((IPage)new Page(query.getPageNum(), query.getPageSize()), (Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)page.getRecords())) {
            for (PaymentFeeSetting record : page.getRecords()) {
                String brandName = this.accountsAllocationMapper.getBrandName(record.getBrandCode());
                record.setBrandName(brandName);
                if (ObjectUtil.isNotEmpty((Object)record.getSubbrandCode())) {
                    String subbrandName = this.accountsAllocationMapper.getSubBrandName(record.getSubbrandCode());
                    record.setSubbrandName(subbrandName);
                }
                if (!ObjectUtil.isNotEmpty((Object)record.getProjectCode())) continue;
                String projectName = this.accountsAllocationMapper.getProjectName(record.getProjectCode());
                record.setProjectName(projectName);
            }
        }
        return page;
    }

    public void export(PaymentFeeSettingQuery query, HttpServletResponse response) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)query.getProjectName()), PaymentFeeSetting::getProjectName, (Object)query.getProjectName())).and(ObjectUtil.isNotEmpty((Object)query.getBrandName()), wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrap.like(PaymentFeeSetting::getBrandName, (Object)query.getBrandName())).or()).like(PaymentFeeSetting::getSubbrandName, (Object)query.getBrandName()))).orderByAsc(PaymentFeeSetting::getBrandCode)).orderByAsc(PaymentFeeSetting::getSubbrandCode)).orderByAsc(PaymentFeeSetting::getProjectCode);
        Page page = (Page)this.page((IPage)new Page(query.getPageNum(), query.getPageSize()), (Wrapper)wrapper);
        List records = page.getRecords();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ExcelWriter writer = null;
        ServletOutputStream outputStream = null;
        try {
            if (CollectionUtil.isNotEmpty((Collection)records)) {
                writer = ExcelUtil.getWriterWithSheet((String)"\u652f\u4ed8\u624b\u7eed\u8d39\u914d\u7f6e");
                writer.writeCellValue(0, 0, (Object)"\u54c1\u724c");
                writer.writeCellValue(1, 0, (Object)"\u5b50\u54c1\u724c");
                writer.writeCellValue(2, 0, (Object)"\u9879\u76ee");
                writer.writeCellValue(3, 0, (Object)"\u652f\u4ed8\u624b\u7eed\u8d39\u6bd4\u4f8b\uff08%\uff09");
                writer.writeCellValue(4, 0, (Object)"\u72b6\u6001");
                writer.writeCellValue(5, 0, (Object)"\u64cd\u4f5c\u4eba");
                writer.writeCellValue(6, 0, (Object)"\u64cd\u4f5c\u65f6\u95f4");
                writer.setColumnWidth(0, 22);
                writer.setColumnWidth(1, 22);
                writer.setColumnWidth(2, 22);
                writer.setColumnWidth(3, 22);
                writer.setColumnWidth(4, 22);
                writer.setColumnWidth(5, 22);
                writer.setColumnWidth(6, 22);
                int num = 0;
                for (PaymentFeeSetting allocation : records) {
                    writer.writeCellValue(0, num + 1, (Object)allocation.getBrandName());
                    writer.writeCellValue(1, num + 1, (Object)(Objects.isNull(allocation.getSubbrandName()) ? "" : allocation.getSubbrandName()));
                    writer.writeCellValue(2, num + 1, (Object)(Objects.isNull(allocation.getProjectName()) ? "" : allocation.getProjectName()));
                    writer.writeCellValue(3, num + 1, (Object)(Objects.isNull(allocation.getProjectName()) ? "" : allocation.getProjectName()));
                    writer.writeCellValue(3, num + 1, (Object)(Objects.isNull(allocation.getPaymentFeeRate()) ? "" : allocation.getPaymentFeeRate() + "%"));
                    writer.writeCellValue(4, num + 1, (Object)(allocation.getStatus().toString().equals("1") ? "\u751f\u6548\u4e2d" : "\u672a\u751f\u6548"));
                    writer.writeCellValue(5, num + 1, (Object)(Objects.isNull(allocation.getUpdateName()) ? "" : allocation.getUpdateName()));
                    writer.writeCellValue(6, num + 1, (Object)(Objects.isNull(allocation.getUpdateTime()) ? "" : sdf.format(allocation.getUpdateTime())));
                    ++num;
                }
                String fileName = URLEncoder.encode("\u652f\u4ed8\u624b\u7eed\u8d39\u914d\u7f6e", "UTF-8");
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
                outputStream = response.getOutputStream();
                writer.flush((OutputStream)outputStream, true);
            }
        }
        catch (IOException e) {
            log.error("\u652f\u4ed8\u624b\u7eed\u8d39\u914d\u7f6e\u5bfc\u51fa\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    public PaymentFeeSetting getPaymentFeeSetting(String projectCode) {
        LambdaQueryWrapper wrapperPaymentFeeSetting = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(PaymentFeeSetting::getStatus, (Object)1)).eq(PaymentFeeSetting::getProjectCode, (Object)projectCode);
        PaymentFeeSetting paymentFeeSetting = (PaymentFeeSetting)this.getOne((Wrapper)wrapperPaymentFeeSetting);
        if (paymentFeeSetting != null) {
            return paymentFeeSetting;
        }
        String customSubbrandCode = this.getCustomSubbrandCode(projectCode);
        LambdaQueryWrapper wrapperPaymentFeeSetting1 = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(PaymentFeeSetting::getStatus, (Object)1)).eq(PaymentFeeSetting::getSubbrandCode, (Object)customSubbrandCode);
        PaymentFeeSetting paymentFeeSetting1 = (PaymentFeeSetting)this.getOne((Wrapper)wrapperPaymentFeeSetting1);
        if (paymentFeeSetting1 != null) {
            return paymentFeeSetting1;
        }
        String brandNo = this.getBrandNo(projectCode);
        LambdaQueryWrapper wrapperPaymentFeeSetting2 = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(PaymentFeeSetting::getStatus, (Object)1)).eq(PaymentFeeSetting::getBrandCode, (Object)brandNo);
        PaymentFeeSetting paymentFeeSetting2 = (PaymentFeeSetting)this.getOne((Wrapper)wrapperPaymentFeeSetting2);
        if (paymentFeeSetting2 != null) {
            return paymentFeeSetting2;
        }
        return null;
    }

    public SeparateAccountsAllocation getSeparateAccountsAllocation(String projectCode) {
        LambdaQueryWrapper wrapperPaymentFeeSetting = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(SeparateAccountsAllocation::getStatus, (Object)1)).eq(SeparateAccountsAllocation::getProjectCode, (Object)projectCode);
        SeparateAccountsAllocation separateAccountsAllocation = (SeparateAccountsAllocation)this.separateAccountsAllocationService.getOne((Wrapper)wrapperPaymentFeeSetting);
        if (separateAccountsAllocation != null) {
            return this.separateAccountsAllocationService.getDetails(separateAccountsAllocation.getId());
        }
        String customSubbrandCode = this.getCustomSubbrandCode(projectCode);
        LambdaQueryWrapper wrapperPaymentFeeSetting1 = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(SeparateAccountsAllocation::getStatus, (Object)1)).eq(SeparateAccountsAllocation::getSubbrandCode, (Object)customSubbrandCode);
        SeparateAccountsAllocation separateAccountsAllocation1 = (SeparateAccountsAllocation)this.separateAccountsAllocationService.getOne((Wrapper)wrapperPaymentFeeSetting1);
        if (separateAccountsAllocation1 != null) {
            return this.separateAccountsAllocationService.getDetails(separateAccountsAllocation1.getId());
        }
        String brandNo = this.getBrandNo(projectCode);
        LambdaQueryWrapper wrapperPaymentFeeSetting2 = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(SeparateAccountsAllocation::getStatus, (Object)1)).eq(SeparateAccountsAllocation::getBrandCode, (Object)brandNo);
        SeparateAccountsAllocation separateAccountsAllocation2 = (SeparateAccountsAllocation)this.separateAccountsAllocationService.getOne((Wrapper)wrapperPaymentFeeSetting2);
        if (separateAccountsAllocation2 != null) {
            return this.separateAccountsAllocationService.getDetails(separateAccountsAllocation2.getId());
        }
        return null;
    }

    public String getCustomSubbrandCode(String projectCode) {
        return ((PaymentFeeSettingMapper)this.baseMapper).getCustomSubbrandCode(projectCode);
    }

    public String getBrandNo(String projectCode) {
        return ((PaymentFeeSettingMapper)this.baseMapper).getBrandNo(projectCode);
    }
}

