/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.ProcessDTO;
import com.ruoyi.dto.RefundApplyExcel;
import com.ruoyi.dto.RefundApplyQueryRequest;
import com.ruoyi.dto.RefundApplyRequest;
import com.ruoyi.entity.RefundApply;
import com.ruoyi.feignClientApi.JsonRootDTO;
import com.ruoyi.feignClientApi.SystemClient;
import com.ruoyi.feignClientApi.WorkFlowService;
import com.ruoyi.mapper.RefundApplyMapper;
import com.ruoyi.service.IRefundApplyService;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.DataPermissionsUtils;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.util.UserUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@RefreshScope
public class RefundApplyServiceImpl
extends ServiceImpl<RefundApplyMapper, RefundApply>
implements IRefundApplyService {
    private static final Logger log = LoggerFactory.getLogger(RefundApplyServiceImpl.class);
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private SystemClient systemClient;
    @Resource
    private DataPermissionsUtils dataPermissionsUtils;
    @Value(value="${leader.leader}")
    private String defLeader;
    @Value(value="${leader.185}")
    private String leader185;
    @Value(value="${leader.186}")
    private String leader186;
    @Value(value="${leader.187}")
    private String leader187;
    @Value(value="${leader.171}")
    private String leader171;

    public Page<RefundApply> queryRefundApplyPage(RefundApplyQueryRequest refundApplyQueryRequest) {
        List permissions = this.dataPermissionsUtils.permissions(Arrays.asList("171"));
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().like(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getRefundApplyNo()), RefundApply::getRefundApplyNo, (Object)refundApplyQueryRequest.getRefundApplyNo())).eq(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getRefundType()), RefundApply::getRefundType, (Object)refundApplyQueryRequest.getRefundType())).eq(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getRefundAmount()), RefundApply::getRefundAmount, (Object)refundApplyQueryRequest.getRefundAmount())).eq(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getState()), RefundApply::getState, (Object)refundApplyQueryRequest.getState())).eq(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getRefundType()), RefundApply::getRefundType, (Object)refundApplyQueryRequest.getRefundType())).like(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getTitleName()), RefundApply::getTitleName, (Object)refundApplyQueryRequest.getTitleName())).ge(refundApplyQueryRequest.getPayDeadlineBegin() != null, RefundApply::getPayDeadline, (Object)refundApplyQueryRequest.getPayDeadlineBegin())).le(refundApplyQueryRequest.getPayDeadlineEnd() != null, RefundApply::getPayDeadline, (Object)refundApplyQueryRequest.getPayDeadlineEnd())).like(ObjectUtil.isNotEmpty((Object)refundApplyQueryRequest.getRoomNumber()), RefundApply::getRoomNumber, (Object)refundApplyQueryRequest.getRoomNumber())).in(ObjectUtil.isNotEmpty((Object)permissions), RefundApply::getCreateUser, (Collection)permissions)).eq(RefundApply::getIsDeleted, (Object)0)).orderByDesc(RefundApply::getId);
        Page page = (Page)this.page((IPage)new Page(refundApplyQueryRequest.getPageNum(), refundApplyQueryRequest.getPageSize()), (Wrapper)wrapper);
        List records = page.getRecords();
        for (RefundApply record : records) {
            if (!StringUtils.isNotBlank((CharSequence)record.getCustomerPaymentScreenshot())) continue;
            JSONArray jsonArray = JSON.parseArray((String)record.getCustomerPaymentScreenshot());
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String name = jsonObject.getString("name");
                names.add(name);
            }
            String join = StringUtils.join(names, (String)",");
            record.setCustomerPaymentScreenshot(join);
        }
        return page;
    }

    public List<RefundApplyExcel> downData2Excel(RefundApplyQueryRequest refundApplyQueryRequest) {
        List permissions = this.dataPermissionsUtils.permissions(Arrays.asList("171"));
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getRefundApplyNo()), RefundApply::getRefundApplyNo, (Object)refundApplyQueryRequest.getRefundApplyNo())).eq(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getRefundType()), RefundApply::getRefundType, (Object)refundApplyQueryRequest.getRefundType())).eq(StringUtils.isNotBlank((CharSequence)refundApplyQueryRequest.getTitleName()), RefundApply::getTitleName, (Object)refundApplyQueryRequest.getTitleName())).le(refundApplyQueryRequest.getPayDeadlineBegin() != null, RefundApply::getPayDeadline, (Object)refundApplyQueryRequest.getPayDeadlineBegin())).ge(refundApplyQueryRequest.getPayDeadlineEnd() != null, RefundApply::getPayDeadline, (Object)refundApplyQueryRequest.getPayDeadlineEnd())).in(ObjectUtil.isNotEmpty((Object)permissions), RefundApply::getCreateUser, (Collection)permissions)).eq(RefundApply::getIsDeleted, (Object)0);
        List refundApplyList = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)refundApplyList)) {
            return Collections.emptyList();
        }
        return refundApplyList.stream().map(m -> {
            String stateDesc = "";
            if (StringUtils.equals((CharSequence)m.getState(), (CharSequence)"0")) {
                stateDesc = "\u8349\u7a3f";
            } else if (StringUtils.equals((CharSequence)m.getState(), (CharSequence)"1")) {
                stateDesc = "\u5b8c\u6210";
            } else if (StringUtils.equals((CharSequence)m.getState(), (CharSequence)"2")) {
                stateDesc = "\u5ba1\u6279\u4e2d";
            } else if (StringUtils.equals((CharSequence)m.getState(), (CharSequence)"3")) {
                stateDesc = "\u9a73\u56de";
            } else if (StringUtils.equals((CharSequence)m.getState(), (CharSequence)"4")) {
                stateDesc = "\u53d6\u6d88";
            }
            return RefundApplyExcel.builder().payDeadline(m.getPayDeadline() == null ? null : m.getPayDeadline().format(DateTimeFormatter.ofPattern("yyyy.MM.dd"))).refundAmount(m.getRefundAmount()).refundApplyNo(m.getRefundApplyNo()).refundType(StringUtils.equals((CharSequence)m.getRefundType(), (CharSequence)"0") ? "\u6574\u6708\u9000\u8d39" : "\u975e\u6574\u6708\u9000\u8d39").titleName(m.getTitleName()).state(stateDesc).build();
        }).collect(Collectors.toList());
    }

    public RefundApplyRequest queryDetail(Long id) {
        RefundApply r = (RefundApply)this.getById((Serializable)id);
        RefundApplyRequest.RefundApplyPersonInfo a = RefundApplyRequest.RefundApplyPersonInfo.builder().applyDate(r.getApplyDate() == null ? null : Date.from(r.getApplyDate().atZone(ZoneId.systemDefault()).toInstant())).applyUser(r.getApplyUser()).department(r.getDepartment()).build();
        RefundApplyRequest.RefundBasicInfo b = RefundApplyRequest.RefundBasicInfo.builder().refundContent(r.getRefundContent()).refundReason(r.getRefundReason()).refundType(r.getRefundType()).titleName(r.getTitleName()).refundMethod(ObjectUtil.isNotEmpty((Object)r.getRefundMethod()) ? r.getRefundMethod() : null).roomNumber(ObjectUtil.isNotEmpty((Object)r.getRoomNumber()) ? r.getRoomNumber() : null).projectName(r.getProjectName()).projectCode(r.getProjectCode()).projectCodeString(r.getProjectCodeString()).processInstId(r.getProcessInstId()).build();
        RefundApplyRequest.RefundCostInfo c = RefundApplyRequest.RefundCostInfo.builder().alipayAccountNo(r.getAlipayAccountNo()).alipayRealName(r.getAlipayRealName()).customerPaymentScreenshot(r.getCustomerPaymentScreenshot()).payDeadline(r.getPayDeadline() == null ? null : Date.from(r.getPayDeadline().atZone(ZoneId.systemDefault()).toInstant())).refundAmount(r.getRefundAmount()).build();
        return RefundApplyRequest.builder().id(r.getId()).state(r.getState()).applyPersonInfo(a).basicInfo(b).costInfo(c).build();
    }

    public RefundApply queryPrintDetail(Long id) {
        JSONObject dictList;
        JSONObject jsonObject;
        RefundApply record = (RefundApply)this.getById((Serializable)id);
        if (StringUtils.isNotBlank((CharSequence)record.getCustomerPaymentScreenshot())) {
            JSONArray jsonArray = JSON.parseArray((String)record.getCustomerPaymentScreenshot());
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                jsonObject = jsonArray.getJSONObject(i);
                String name = jsonObject.getString("name");
                names.add(name);
            }
            String join = StringUtils.join(names, (String)",");
            record.setCustomerPaymentScreenshot(join);
        }
        if ("0".equals(record.getRefundType())) {
            record.setRefundType("\u6574\u6708\u9000\u6b3e");
        } else if ("1".equals(record.getRefundType())) {
            record.setRefundType("\u975e\u6574\u6708\u9000\u6b3e");
        } else {
            record.setRefundType("\u5176\u4ed6");
        }
        if (StringUtils.isNotBlank((CharSequence)record.getRefundReason()) && "200".equals((dictList = this.systemClient.getDictListByDictType(Integer.valueOf(1), Integer.valueOf(9999), "refund_reason")).getString("code"))) {
            JSONArray rows = dictList.getJSONArray("rows");
            for (int i = 0; i < rows.size(); ++i) {
                jsonObject = rows.getJSONObject(i);
                if (!record.getRefundReason().equals(jsonObject.getString("dictValue"))) continue;
                record.setRefundReason(jsonObject.getString("dictLabel"));
            }
        }
        return record;
    }

    public String leader(LoginUser loginUser) {
        SysUser sysUser = loginUser.getSysUser();
        String deptId = sysUser.getDeptId().toString();
        String userid = loginUser.getUserid().toString();
        String leader = "1";
        switch (deptId) {
            case "185": {
                if (userid.equals(this.leader185)) {
                    leader = this.defLeader;
                    break;
                }
                leader = this.leader185;
                break;
            }
            case "186": {
                if (userid.equals(this.leader186)) {
                    leader = this.defLeader;
                    break;
                }
                leader = this.leader186;
                break;
            }
            case "187": {
                if (userid.equals(this.leader187)) {
                    leader = this.defLeader;
                    break;
                }
                leader = this.leader187;
                break;
            }
            case "171": {
                leader = this.leader171;
            }
        }
        return leader;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean addRefundApply(RefundApplyRequest refundApplyRequest) throws Exception {
        Long id = refundApplyRequest.getId() == null ? this.add(refundApplyRequest) : this.edit(refundApplyRequest);
        if (StringUtils.equals((CharSequence)refundApplyRequest.getState(), (CharSequence)"2")) {
            ProcessDTO processDTO = new ProcessDTO();
            LoginUser loginUser = UserUtils.getLoginUser();
            SysUser sysUser = loginUser.getSysUser();
            HashMap<String, Object> stringStringHashMap = new HashMap<String, Object>();
            stringStringHashMap.put("deptId", sysUser.getDeptId());
            stringStringHashMap.put("loginUserId", loginUser.getUserid());
            stringStringHashMap.put("refundAmount", refundApplyRequest.getCostInfo().getRefundAmount());
            stringStringHashMap.put("leader", this.leader(loginUser));
            processDTO.setFormData(stringStringHashMap);
            processDTO.setBusinessKey(id + "");
            processDTO.setFormUrl("/backend/#/financialManagement/refundApplication/approve?id=" + id);
            processDTO.setProcessInstanceName(refundApplyRequest.getBasicInfo().getTitleName());
            processDTO.setProcessDefinitionKey("refund_apply");
            processDTO.setProjectName(refundApplyRequest.getBasicInfo().getProjectName());
            log.info("addRefundApply\u5de5\u4f5c\u6d41\u8fd4\u56de\u7684\u8bf7\u6c42\u96c6\u662f:{}", (Object)processDTO);
            String processInstId = this.workFlowService.startProcess(processDTO);
            RefundApply refundApply = new RefundApply();
            refundApply.setId(id);
            refundApply.setProcessInstId(processInstId);
            this.updateById((Object)refundApply);
        }
        return true;
    }

    public Boolean fwd(Long id) {
        RefundApply byId = (RefundApply)this.getById((Serializable)id);
        List<String> userIds = new ArrayList<String>();
        userIds.add(byId.getCreateUser().toString());
        if (ObjectUtil.isNotEmpty(userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            LoginUser loginUser = UserUtils.getLoginUser();
            JsonRootDTO jsonRootDTO = new JsonRootDTO();
            jsonRootDTO.setName(byId.getTitleName());
            jsonRootDTO.setBusinessKey(id.toString());
            jsonRootDTO.setSenderId(loginUser.getUserid().toString());
            jsonRootDTO.setSenderName(loginUser.getUsername());
            jsonRootDTO.setReceiverIds(userIds);
            jsonRootDTO.setTargetUrl("/backend/#/financialManagement/refundApplication/approve?id=" + id);
            JSONObject jsonObject1 = this.workFlowService.pushUndoTask(jsonRootDTO);
            System.out.println(jsonObject1.toJSONString());
        }
        return true;
    }

    private Long add(RefundApplyRequest refundApplyRequest) {
        RefundApplyRequest.RefundApplyPersonInfo a = refundApplyRequest.getApplyPersonInfo();
        RefundApplyRequest.RefundBasicInfo b = refundApplyRequest.getBasicInfo();
        RefundApplyRequest.RefundCostInfo c = refundApplyRequest.getCostInfo();
        ThemeUtils themes = new ThemeUtils();
        String titleName = ThemeUtils.getThemeName((String)"\u9000\u8d39\u7533\u8bf7");
        b.setTitleName(titleName);
        RefundApply refundApply = RefundApply.builder().refundApplyNo(RefundApplyServiceImpl.generateRule()).applyUser(a.getApplyUser()).department(a.getDepartment()).applyDate(a.getApplyDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).refundType(b.getRefundType()).titleName(titleName).refundReason(b.getRefundReason()).refundContent(b.getRefundContent()).refundAmount(c.getRefundAmount()).alipayRealName(c.getAlipayRealName()).alipayAccountNo(c.getAlipayAccountNo()).state(refundApplyRequest.getState()).customerPaymentScreenshot(c.getCustomerPaymentScreenshot()).payDeadline(this.convertToLocalDateTime(c.getPayDeadline())).refundMethod(b.getRefundMethod()).roomNumber(b.getRoomNumber()).projectName(b.getProjectName()).projectCode(b.getProjectCode()).projectCodeString(b.getProjectCodeString()).build();
        LoginUser loginUser = UserUtils.getLoginUser();
        refundApply.setCreateUser(loginUser.getUserid());
        this.save((Object)refundApply);
        return refundApply.getId();
    }

    private LocalDateTime convertToLocalDateTime(Date date) {
        if (date != null) {
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        return null;
    }

    private Long edit(RefundApplyRequest refundApplyRequest) {
        RefundApplyRequest.RefundApplyPersonInfo a = refundApplyRequest.getApplyPersonInfo();
        RefundApplyRequest.RefundBasicInfo b = refundApplyRequest.getBasicInfo();
        RefundApplyRequest.RefundCostInfo c = refundApplyRequest.getCostInfo();
        this.updateById((Object)RefundApply.builder().id(refundApplyRequest.getId()).applyUser(a.getApplyUser()).department(a.getDepartment()).applyDate(a.getApplyDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).refundType(b.getRefundType()).refundReason(b.getRefundReason()).refundContent(b.getRefundContent()).refundAmount(c.getRefundAmount()).alipayRealName(c.getAlipayRealName()).alipayAccountNo(c.getAlipayAccountNo()).state(refundApplyRequest.getState()).customerPaymentScreenshot(c.getCustomerPaymentScreenshot()).payDeadline(this.convertToLocalDateTime(c.getPayDeadline())).roomNumber(b.getRoomNumber()).refundMethod(b.getRefundMethod()).projectName(b.getProjectName()).projectCode(b.getProjectCode()).projectCodeString(b.getProjectCodeString()).build());
        return refundApplyRequest.getId();
    }

    public static String generateRule() {
        String dateStr = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        return "TFSQ-" + dateStr + "-" + (new Random().nextInt(9000) + 1000);
    }
}

