/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.entity.SeparateAccountsLog;
import com.ruoyi.entity.SeparateAccountsLogDetail;
import com.ruoyi.mapper.SeparateAccountsLogMapper;
import com.ruoyi.query.SeparateAccountsLogQuery;
import com.ruoyi.service.SeparateAccountsLogDetailService;
import com.ruoyi.service.SeparateAccountsLogService;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.UserUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SeparateAccountsLogServiceImpl
extends ServiceImpl<SeparateAccountsLogMapper, SeparateAccountsLog>
implements SeparateAccountsLogService {
    private static final Logger log = LoggerFactory.getLogger(SeparateAccountsLogServiceImpl.class);
    @Resource
    private SeparateAccountsLogDetailService separateAccountsLogDetailService;

    public Page<SeparateAccountsLog> getPage(SeparateAccountsLogQuery query) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)query.getStatus()), SeparateAccountsLog::getHandleStatus, (Object)query.getStatus())).between(ObjectUtil.isNotEmpty((Object)query.getStartTime()), SeparateAccountsLog::getSaTime, (Object)query.getStartTime(), (Object)query.getEndTime())).orderByDesc(SeparateAccountsLog::getSaTime);
        return (Page)this.page((IPage)new Page(query.getPageNum(), query.getPageSize()), (Wrapper)wrapper);
    }

    public SeparateAccountsLog getDetails(Long id) {
        SeparateAccountsLog log = (SeparateAccountsLog)this.getById((Serializable)id);
        List detailList = this.separateAccountsLogDetailService.list((Wrapper)new LambdaQueryWrapper().eq(SeparateAccountsLogDetail::getLogId, (Object)id));
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            log.setDetailList(detailList);
        }
        return log;
    }

    public Long create(SeparateAccountsLog log) {
        LoginUser loginUser = UserUtils.getLoginUser();
        SysUser sysUser = loginUser.getSysUser();
        log.setCreateName(sysUser.getUserName());
        log.setCreateUser(sysUser.getUserId());
        log.setUpdateUser(sysUser.getUserId());
        log.setUpdateName(sysUser.getUserName());
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        this.save((Object)log);
        List detailList = log.getDetailList();
        detailList.stream().forEach(f -> {
            f.setLogId(log.getId());
            f.setCreateName(sysUser.getUserName());
            f.setCreateUser(sysUser.getUserId());
            f.setUpdateUser(sysUser.getUserId());
            f.setUpdateName(sysUser.getUserName());
            f.setCreateTime(new Date());
            f.setUpdateTime(new Date());
        });
        this.separateAccountsLogDetailService.saveBatch((Collection)detailList);
        return log.getId();
    }

    public Boolean update(SeparateAccountsLog allocation) {
        LoginUser loginUser = UserUtils.getLoginUser();
        SysUser sysUser = loginUser.getSysUser();
        allocation.setUpdateUser(sysUser.getUserId());
        allocation.setUpdateName(sysUser.getUserName());
        allocation.setUpdateTime(new Date());
        Boolean update = this.updateById((Object)allocation);
        this.separateAccountsLogDetailService.remove((Wrapper)new LambdaQueryWrapper().eq(SeparateAccountsLogDetail::getLogId, (Object)allocation.getId()));
        List detailList = allocation.getDetailList();
        detailList.stream().forEach(f -> {
            f.setLogId(allocation.getId());
            f.setCreateName(sysUser.getUserName());
            f.setCreateUser(sysUser.getUserId());
            f.setUpdateUser(sysUser.getUserId());
            f.setUpdateName(sysUser.getUserName());
            f.setCreateTime(new Date());
            f.setUpdateTime(new Date());
        });
        this.separateAccountsLogDetailService.saveBatch((Collection)detailList);
        return update;
    }

    public void export(SeparateAccountsLogQuery query, HttpServletResponse response) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)query.getStatus()), SeparateAccountsLog::getHandleStatus, (Object)query.getStatus())).between(ObjectUtil.isNotEmpty((Object)query.getStartTime()), SeparateAccountsLog::getSaTime, (Object)query.getStartTime(), (Object)query.getEndTime())).orderByDesc(SeparateAccountsLog::getSaTime);
        Page page = (Page)this.page((IPage)new Page(query.getPageNum(), 99999L), (Wrapper)wrapper);
        List records = page.getRecords();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        ExcelWriter writer = null;
        ServletOutputStream outputStream = null;
        try {
            if (CollectionUtil.isNotEmpty((Collection)records)) {
                writer = ExcelUtil.getWriterWithSheet((String)"\u5206\u8d26\u65e5\u5fd7");
                writer.writeCellValue(0, 0, (Object)"\u5206\u8d26\u65f6\u95f4");
                writer.writeCellValue(1, 0, (Object)"\u51fa\u8d26\u673a\u6784\u53f7");
                writer.writeCellValue(2, 0, (Object)"\u51fa\u8d26\u5546\u6237\u53f7");
                writer.writeCellValue(3, 0, (Object)"\u51fa\u8d26\u5546\u6237\u540d");
                writer.writeCellValue(4, 0, (Object)"\u5546\u6237\u5206\u8d26\u5355\u53f7");
                writer.writeCellValue(5, 0, (Object)"\u5206\u8d26\u603b\u91d1\u989d\uff08\u5143\uff09");
                writer.writeCellValue(6, 0, (Object)"\u5904\u7406\u72b6\u6001");
                writer.setColumnWidth(0, 22);
                writer.setColumnWidth(1, 22);
                writer.setColumnWidth(2, 22);
                writer.setColumnWidth(3, 22);
                writer.setColumnWidth(4, 30);
                writer.setColumnWidth(5, 22);
                writer.setColumnWidth(6, 22);
                int num = 0;
                for (SeparateAccountsLog allocation : records) {
                    writer.writeCellValue(0, num + 1, (Object)(Objects.isNull(allocation.getSaTime()) ? "" : sdf.format(allocation.getSaTime())));
                    writer.writeCellValue(1, num + 1, (Object)(Objects.isNull(allocation.getSaInstitutionNumber()) ? "" : sdf.format(allocation.getSaInstitutionNumber())));
                    writer.writeCellValue(2, num + 1, (Object)(Objects.isNull(allocation.getSaMerchantid()) ? "" : allocation.getSaMerchantid()));
                    writer.writeCellValue(3, num + 1, (Object)(Objects.isNull(allocation.getSaMerchantName()) ? "" : allocation.getSaMerchantName()));
                    writer.writeCellValue(4, num + 1, (Object)(Objects.isNull(allocation.getSaBillNumber()) ? "" : allocation.getSaBillNumber()));
                    writer.writeCellValue(5, num + 1, (Object)(Objects.isNull(allocation.getSaAllMoney()) ? "" : allocation.getSaAllMoney()));
                    Integer handleStatus = allocation.getHandleStatus();
                    String status = "\u672a\u5904\u7406";
                    switch (handleStatus) {
                        case 0: {
                            status = "\u5931\u8d25";
                            break;
                        }
                        case 1: {
                            status = "\u90e8\u5206\u6210\u529f";
                            break;
                        }
                        case 2: {
                            status = "\u6210\u529f";
                        }
                    }
                    writer.writeCellValue(6, num + 1, (Object)status);
                    ++num;
                }
                String fileName = URLEncoder.encode("\u5206\u8d26\u65e5\u5fd7", "UTF-8");
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
                outputStream = response.getOutputStream();
                writer.flush((OutputStream)outputStream, true);
            }
        }
        catch (IOException e) {
            log.error("\u5206\u8d26\u65e5\u5fd7\u5bfc\u51fa\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

