/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.entity.SmsSetUp;
import com.ruoyi.mapper.SmsSetUpMapper;
import com.ruoyi.service.ISmsSetUpService;
import com.ruoyi.telentcloudsms.SendSmsCloud;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsSetUpServiceImpl
extends ServiceImpl<SmsSetUpMapper, SmsSetUp>
implements ISmsSetUpService {
    private static final Logger log = LoggerFactory.getLogger(SmsSetUpServiceImpl.class);
    @Autowired
    private SendSmsCloud sendSmsCloud;

    public List<SmsSetUp> querySmsSetUpList() {
        return this.list();
    }

    public boolean updateSmsSetUp(List<SmsSetUp> smsSetUpList) {
        this.saveOrUpdateBatch(smsSetUpList);
        List<SmsSetUp> bindTenectCloudSmsList = smsSetUpList.stream().filter(f -> StringUtils.isBlank((CharSequence)f.getSmsTemplateId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(bindTenectCloudSmsList)) {
            bindTenectCloudSmsList.forEach(f -> {
                String smsTemplateId = this.sendSmsCloud.setSmsTemplate(f.getContent(), f.getTemplateName(), Long.parseLong(f.getSmsType()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.updateById((Object)SmsSetUp.builder().id(f.getId()).smsTemplateId(smsTemplateId).build());
            });
        }
        return true;
    }
}

