/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.task;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.entity.SeparateAccountsDetail;
import com.ruoyi.entity.SeparateAccountsLog;
import com.ruoyi.entity.SeparateAccountsLogDetail;
import com.ruoyi.sa.DTO.BalanceSplitDTO;
import com.ruoyi.sa.DTO.BalanceSplitData;
import com.ruoyi.sa.DTO.BalanceSplitResponse;
import com.ruoyi.sa.DTO.BalanceSplitResponseData;
import com.ruoyi.sa.IJialPayBalanceService;
import com.ruoyi.service.SeparateAccountsAllocationDetailService;
import com.ruoyi.service.SeparateAccountsAllocationService;
import com.ruoyi.service.SeparateAccountsDetailService;
import com.ruoyi.service.SeparateAccountsLogDetailService;
import com.ruoyi.service.SeparateAccountsLogService;
import com.ruoyi.util.DataUtils;
import com.ruoyi.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class SeparateAccountsTask {
    @Resource
    private SeparateAccountsAllocationService separateAccountsAllocationService;
    @Resource
    private SeparateAccountsAllocationDetailService separateAccountsAllocationDetailService;
    @Resource
    private SeparateAccountsDetailService separateAccountsDetailService;
    @Resource
    private SeparateAccountsLogService separateAccountsLogService;
    @Resource
    private SeparateAccountsLogDetailService separateAccountsLogDetailService;
    @Resource
    private IJialPayBalanceService jialPayBalanceService;

    public void getSeparateAccountFile(String startOfYesterday, String endOfYesterday) {
        LambdaQueryWrapper wrapperSeparateAccountsDetail;
        List separateAccountsDetailList;
        Map mapDate = DateUtils.previousDayStartEndTime();
        if (ObjectUtil.isEmpty((Object)startOfYesterday)) {
            startOfYesterday = (String)mapDate.get("startOfYesterday");
        }
        if (ObjectUtil.isEmpty((Object)endOfYesterday)) {
            endOfYesterday = (String)mapDate.get("endOfYesterday");
        }
        if (ObjectUtil.isEmpty((Object)(separateAccountsDetailList = this.separateAccountsDetailService.list((Wrapper)(wrapperSeparateAccountsDetail = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().ge(SeparateAccountsDetail::getCreateTime, (Object)startOfYesterday)).le(SeparateAccountsDetail::getCreateTime, (Object)endOfYesterday)).orderByDesc(SeparateAccountsDetail::getCreateTime)))))) {
            return;
        }
        Map<String, List<SeparateAccountsDetail>> groupListMap = separateAccountsDetailList.stream().collect(Collectors.groupingBy(SeparateAccountsDetail::getSaInstitutionNumber));
        for (Map.Entry<String, List<SeparateAccountsDetail>> entry : groupListMap.entrySet()) {
            String saInstitutionNumber = entry.getKey();
            List<SeparateAccountsDetail> accountsDetails = entry.getValue();
            if (ObjectUtil.isEmpty(accountsDetails)) continue;
            SeparateAccountsLog separateAccountsLog = new SeparateAccountsLog();
            separateAccountsLog.setCreateTime(new Date());
            separateAccountsLog.setUpdateTime(new Date());
            separateAccountsLog.setIsDeleted(Integer.valueOf(0));
            separateAccountsLog.setSaInstitutionNumber(saInstitutionNumber);
            separateAccountsLog.setSaMerchantid(accountsDetails.get(0).getSaMerchantid());
            separateAccountsLog.setSaMerchantName(accountsDetails.get(0).getSaMerchantName());
            List saMoneyList = accountsDetails.stream().map(SeparateAccountsDetail::getSaMoney).collect(Collectors.toList());
            BigDecimal sum = saMoneyList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            String saAllMoney = DataUtils.bigDecimalToString((BigDecimal)sum);
            separateAccountsLog.setSaAllMoney(saAllMoney);
            String saBillNumber = saInstitutionNumber + System.currentTimeMillis();
            separateAccountsLog.setSaBillNumber(saBillNumber);
            separateAccountsLog.setSaTime(new Date());
            List saStatusMoneyList = accountsDetails.stream().map(SeparateAccountsDetail::getSaStatus).collect(Collectors.toList());
            long countOfOnes = saStatusMoneyList.stream().filter(n -> n == 1).count();
            if ((int)countOfOnes == saStatusMoneyList.size()) {
                separateAccountsLog.setHandleStatus(Integer.valueOf(2));
            }
            if ((int)countOfOnes < saStatusMoneyList.size()) {
                separateAccountsLog.setHandleStatus(Integer.valueOf(1));
            }
            if ((int)countOfOnes == 0) {
                separateAccountsLog.setHandleStatus(Integer.valueOf(0));
            }
            this.separateAccountsLogService.save((Object)separateAccountsLog);
            List receivers = this.handleAccountsDetails(accountsDetails, separateAccountsLog.getId());
            BalanceSplitDTO dto = new BalanceSplitDTO();
            dto.setMch_id(accountsDetails.get(0).getSaMerchantid());
            dto.setOrg_code(saInstitutionNumber);
            dto.setOut_order_no(saBillNumber);
            dto.setTotal_amount(saAllMoney);
            dto.setReceivers(receivers);
            BalanceSplitResponse response = this.jialPayBalanceService.balanceSplit(dto);
            List balanceSplitResponseDataList = response.getReceivers();
            List saresultList = balanceSplitResponseDataList.stream().map(BalanceSplitResponseData::getResult).collect(Collectors.toList());
            if ("PROCESSING".equals(response.getState())) {
                separateAccountsLog.setHandleStatus(Integer.valueOf(3));
            } else if ("FINISHED".equals(response.getState())) {
                separateAccountsLog.setHandleStatus(Integer.valueOf(2));
            } else if (saresultList.contains("SUCCESS")) {
                separateAccountsLog.setHandleStatus(Integer.valueOf(1));
            } else {
                separateAccountsLog.setHandleStatus(Integer.valueOf(2));
            }
            for (BalanceSplitResponseData balanceSplitResponseData : balanceSplitResponseDataList) {
                LambdaQueryWrapper wrapperSeparateAccountsLogDetail = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().ge(SeparateAccountsLogDetail::getLogId, (Object)separateAccountsLog.getId())).le(SeparateAccountsLogDetail::getMerchantid, (Object)balanceSplitResponseData.getRev_mch_id());
                SeparateAccountsLogDetail separateAccountsLogDetail = (SeparateAccountsLogDetail)this.separateAccountsLogDetailService.getOne((Wrapper)wrapperSeparateAccountsLogDetail);
                if ("PENDING".equals(balanceSplitResponseData.getResult())) {
                    separateAccountsLogDetail.setSaResult(Integer.valueOf(3));
                }
                if ("SUCCESS".equals(balanceSplitResponseData.getResult())) {
                    separateAccountsLogDetail.setSaResult(Integer.valueOf(1));
                }
                if ("FAILED".equals(balanceSplitResponseData.getResult())) {
                    separateAccountsLogDetail.setSaResult(Integer.valueOf(2));
                }
                separateAccountsLogDetail.setSaBackRemark(balanceSplitResponseData.getDescription());
                separateAccountsLogDetail.setSaOverTime(balanceSplitResponseData.getFinish_time());
                separateAccountsLogDetail.setDetailId(balanceSplitResponseData.getDetail_id());
                separateAccountsLogDetail.setFailReason(balanceSplitResponseData.getFail_reason());
            }
        }
    }

    private List<BalanceSplitData> handleAccountsDetails(List<SeparateAccountsDetail> accountsDetails, Long separateAccountsLogId) {
        if (ObjectUtil.isEmpty(accountsDetails)) {
            return new ArrayList<BalanceSplitData>();
        }
        ArrayList<BalanceSplitData> receivers = new ArrayList<BalanceSplitData>();
        for (SeparateAccountsDetail separateAccountsDetail : accountsDetails) {
            SeparateAccountsLogDetail detail = new SeparateAccountsLogDetail();
            detail.setCreateTime(new Date());
            detail.setUpdateTime(new Date());
            detail.setLogId(separateAccountsLogId);
            detail.setIsDeleted(Integer.valueOf(0));
            detail.setSaResult(Integer.valueOf(3));
            detail.setInstitutionNumber(separateAccountsDetail.getRecipientInstitutionNumber());
            detail.setMerchantid(separateAccountsDetail.getRecipientMerchantid());
            detail.setMerchantName(separateAccountsDetail.getRecipientMerchantName());
            detail.setOrderMoney(separateAccountsDetail.getPaymentMoney());
            detail.setSaRate(separateAccountsDetail.getSaRate());
            detail.setSaMoney(separateAccountsDetail.getSaMoney());
            String saRemark = separateAccountsDetail.getRecipientMerchantName() + DateUtils.dateToStringNow() + "\uff0c\u91d1\u989d:" + DataUtils.bigDecimalToString((BigDecimal)separateAccountsDetail.getSaMoney());
            detail.setSaRemark(saRemark);
            detail.setSaBackRemark(null);
            detail.setSaOverTime(null);
            this.separateAccountsLogDetailService.save((Object)detail);
            BalanceSplitData balanceSplitData = new BalanceSplitData();
            balanceSplitData.setDescription(saRemark);
            balanceSplitData.setRev_mch_id(separateAccountsDetail.getRecipientMerchantid());
            balanceSplitData.setAmount(DataUtils.bigDecimalToString((BigDecimal)separateAccountsDetail.getSaMoney()));
            receivers.add(balanceSplitData);
        }
        return receivers;
    }
}

