/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.telentcloudsms;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.AddSmsTemplateRequest;
import com.tencentcloudapi.sms.v20210111.models.AddSmsTemplateResponse;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SendSmsCloud {
    private static final Logger log = LoggerFactory.getLogger(SendSmsCloud.class);
    @Value(value="${telentcloud.sms.secretId:AKIDHYggXEtRuHdsBQYZRH3gBezCGEc2KVba}")
    private String secretId;
    @Value(value="${telentcloud.sms.secretKey:xoaEvkYYRDrNl1993rfYUNBvgbftKa1h}")
    private String secretKey;
    @Value(value="${telentcloud.sms.sdkAppId:1400223405}")
    private String sdkAppId;
    @Value(value="${telentcloud.sms.signName:\u7ffc\u626c\u79d1\u6280}")
    private String signName;

    public void sendSms(String[] phoneNumberSet, String[] templateParamSet, String templateId) {
        try {
            Credential cred = new Credential(this.secretId, this.secretKey);
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setReqMethod("GET");
            httpProfile.setConnTimeout(10);
            httpProfile.setWriteTimeout(10);
            httpProfile.setReadTimeout(10);
            httpProfile.setEndpoint("sms.tencentcloudapi.com");
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            SmsClient client = new SmsClient(cred, "ap-nanjing", clientProfile);
            SendSmsRequest req = new SendSmsRequest();
            req.setSmsSdkAppId(this.sdkAppId);
            req.setSignName(this.signName);
            req.setTemplateId(templateId);
            req.setTemplateParamSet(templateParamSet);
            req.setPhoneNumberSet(phoneNumberSet);
            String sessionContext = "";
            req.setSessionContext(sessionContext);
            String extendCode = "";
            req.setExtendCode(extendCode);
            String senderid = "";
            req.setSenderId(senderid);
            SendSmsResponse res = client.SendSms(req);
            log.info("\u53d1\u9001\u77ed\u4fe1\u72b6\u6001\u4fe1\u606f:{}", (Object)SendSmsResponse.toJsonString((AbstractModel)res));
        }
        catch (TencentCloudSDKException e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u662f:", (Throwable)e);
        }
    }

    public String setSmsTemplate(String templateContent, String templateName, long smsType) {
        try {
            Credential cred = new Credential(this.secretId, this.secretKey);
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setReqMethod("GET");
            httpProfile.setConnTimeout(30);
            httpProfile.setWriteTimeout(30);
            httpProfile.setReadTimeout(30);
            httpProfile.setEndpoint("sms.tencentcloudapi.com");
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            SmsClient client = new SmsClient(cred, "ap-nanjing", clientProfile);
            AddSmsTemplateRequest req = new AddSmsTemplateRequest();
            req.setTemplateName(templateName);
            req.setTemplateContent(templateContent);
            req.setSmsType(Long.valueOf(smsType));
            long international = 0L;
            req.setInternational(Long.valueOf(international));
            req.setRemark("\u7ffc\u626c\u77ed\u4fe1\u670d\u52a1\u901a\u77e5");
            AddSmsTemplateResponse res = client.AddSmsTemplate(req);
            log.info("\u8bbe\u7f6e\u6a21\u7248\u8fd4\u56de\u7684\u7ed3\u679c\u96c6\u662f:{}", (Object)AddSmsTemplateResponse.toJsonString((AbstractModel)res));
            if (res.getAddTemplateStatus() == null) {
                return null;
            }
            return res.getAddTemplateStatus().getTemplateId();
        }
        catch (TencentCloudSDKException e) {
            log.error("\u8bbe\u7f6e\u6a21\u7248\u9519\u8bef\uff0c\u4fe1\u606f\u662f:", (Throwable)e);
            return null;
        }
    }
}

