/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConvertUtils {
    private static Logger logger = LoggerFactory.getLogger(ConvertUtils.class);

    public static <T> T sourceToTarget(Object source, Class<T> target, String ... ignoreProperties) {
        if (source == null) {
            return null;
        }
        T targetObject = null;
        try {
            targetObject = target.newInstance();
            BeanUtil.copyProperties((Object)source, targetObject, (String[])ignoreProperties);
        }
        catch (Exception e) {
            logger.error("convert error ", (Throwable)e);
        }
        return targetObject;
    }

    public static <T> void filter(Object source, String ... includeProperties) {
        if (source == null) {
            return;
        }
        try {
            Field[] fieldList;
            Object targetObject = source.getClass().newInstance();
            List<String> propList = Arrays.asList(includeProperties);
            for (Field field : fieldList = source.getClass().getDeclaredFields()) {
                if (!propList.contains(field.getName())) continue;
                Object fieldVal = ReflectUtil.getFieldValue((Object)source, (Field)field);
                ReflectUtil.setFieldValue(targetObject, (Field)field, (Object)fieldVal);
            }
            BeanUtil.copyProperties(targetObject, (Object)source, (String[])new String[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static <T> void filter(Collection<?> sourceList, String ... includeProperties) {
        if (sourceList == null) {
            return;
        }
        for (Object source : sourceList) {
            ConvertUtils.filter(source, (String[])includeProperties);
        }
    }

    public static <T> List<T> sourceToTarget(Collection<?> sourceList, Class<T> target, String ... ignoreProperties) {
        if (sourceList == null) {
            return null;
        }
        ArrayList<T> targetList = new ArrayList<T>(sourceList.size());
        try {
            for (Object source : sourceList) {
                T targetObject = target.newInstance();
                BeanUtil.copyProperties(source, targetObject, (String[])ignoreProperties);
                targetList.add(targetObject);
            }
        }
        catch (Exception e) {
            logger.error("convert error ", (Throwable)e);
        }
        return targetList;
    }

    public static Map<String, Object> sourceToMap(Object source, String ... ignoreProperties) {
        if (source == null) {
            return null;
        }
        HashMap<String, Object> targetObject = null;
        try {
            Field[] fieldList;
            ArrayList ignoreList = CollectionUtil.toList((Object[])ignoreProperties);
            targetObject = new HashMap<String, Object>();
            for (Field field : fieldList = source.getClass().getDeclaredFields()) {
                if (ignoreList.contains(field.getName())) continue;
                targetObject.put(field.getName(), ReflectUtil.getFieldValue((Object)source, (Field)field));
            }
        }
        catch (Exception e) {
            logger.error("convert error ", (Throwable)e);
        }
        return targetObject;
    }
}

