/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.common.exception;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.huimin.common.exception.RenException;
import com.huimin.common.result.Result;
import com.huimin.common.utils.ExceptionUtils;
import com.huimin.common.utils.HttpContextUtils;
import com.huimin.common.utils.IpUtils;
import com.huimin.entity.SysLogErrorEntity;
import com.huimin.service.SysLogErrorService;
import java.io.BufferedReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class RenExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(RenExceptionHandler.class);
    @Autowired
    private SysLogErrorService sysLogErrorService;

    @ExceptionHandler(value={Exception.class})
    public Result handleException(Exception ex) {
        logger.error(ex.getMessage(), (Throwable)ex);
        this.saveLog(ex);
        return new Result().error("\u64cd\u4f5c\u5931\u8d25");
    }

    @ExceptionHandler(value={RenException.class})
    public Result handleRenException(Exception ex) {
        logger.error(ex.getMessage(), (Throwable)ex);
        return new Result().error("\u64cd\u4f5c\u5931\u8d25");
    }

    private void saveLog(Exception ex) {
        SysLogErrorEntity log = new SysLogErrorEntity();
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setRequestUri(request.getRequestURI());
        log.setRequestMethod(request.getMethod());
        Map params = HttpContextUtils.getParameterMap((HttpServletRequest)request);
        if (MapUtil.isNotEmpty((Map)params)) {
            log.setRequestParams(JSON.toJSONString((Object)params));
        } else {
            try {
                String line;
                BufferedReader reader = request.getReader();
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                log.setRequestParams(stringBuilder.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.setErrorInfo(ExceptionUtils.getErrorStackTrace((Exception)ex));
        this.sysLogErrorService.save(log);
    }
}

