/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.common.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IpUtils {
    private static Logger logger = LoggerFactory.getLogger(IpUtils.class);

    public static String getIpAddr(HttpServletRequest request) {
        String unknown = "unknown";
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            if (StringUtils.isEmpty((CharSequence)ip) || unknown.equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || ip.length() == 0 || unknown.equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || unknown.equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || unknown.equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || unknown.equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            logger.error("IPUtils ERROR ", (Throwable)e);
        }
        return ip;
    }

    public static String getNumConvertIp(long ipLong) {
        long[] mask = new long[]{255L, 65280L, 0xFF0000L, -16777216L};
        long num = 0L;
        StringBuffer ipInfo = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            num = (ipLong & mask[i]) >> i * 8;
            if (i > 0) {
                ipInfo.insert(0, ".");
            }
            ipInfo.insert(0, Long.toString(num, 10));
        }
        return ipInfo.toString();
    }

    public static long getIpConvertNum(String ipAddress) {
        String[] ip = ipAddress.split("\\.");
        long a = Integer.parseInt(ip[0]);
        long b = Integer.parseInt(ip[1]);
        long c = Integer.parseInt(ip[2]);
        long d = Integer.parseInt(ip[3]);
        long ipNum = a * 256L * 256L * 256L + b * 256L * 256L + c * 256L + d;
        return ipNum;
    }

    public static boolean checkIp(String ipPolicy, String ip) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{ipPolicy, ip})) {
            return true;
        }
        long minIp = IpUtils.getIpConvertNum((String)ipPolicy.replaceAll("\\*", "0"));
        long maxIp = IpUtils.getIpConvertNum((String)ipPolicy.replaceAll("\\*", "255"));
        long curIp = IpUtils.getIpConvertNum((String)ip);
        return curIp > minIp && curIp < maxIp;
    }
}

