/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.common.utils;

import com.huimin.common.page.PageData;
import com.huimin.common.utils.DateUtils;
import com.huimin.common.utils.SQLHelper;
import com.huimin.common.utils.SpringContextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class QueryHelper {
    private static JdbcTemplate jdbcTemplate = (JdbcTemplate)SpringContextUtils.getBean(JdbcTemplate.class);
    private String table;
    private List<String> joinList = new ArrayList();
    private StringBuffer fieldSQL = new StringBuffer("*");
    private StringBuffer whereSQL = new StringBuffer("");
    private String limitSQL = null;
    private StringBuffer groupBySQL = new StringBuffer("");
    private StringBuffer orderBySQL = new StringBuffer("");

    public static QueryHelper getInstance(String table) {
        return new QueryHelper(table);
    }

    public static int tableCount(String table) {
        return new QueryHelper(table).count();
    }

    private QueryHelper(String table) {
        this.table = table;
    }

    public QueryHelper field(String fileds) {
        if (StringUtils.isNotEmpty((CharSequence)fileds)) {
            this.fieldSQL.deleteCharAt(0).append(fileds);
        }
        return this;
    }

    public QueryHelper alias(String alias) {
        Pattern tablePattern = Pattern.compile("\\s*(\\S+)\\s{1,}(\\S+)\\s*");
        Matcher m = tablePattern.matcher(this.table);
        this.table = m.matches() ? this.table.replaceFirst(" " + m.group(2), alias) : this.table.concat(" " + alias);
        return this;
    }

    public QueryHelper field(String ... fields) {
        if (fields != null) {
            this.fieldSQL.deleteCharAt(0).append(StringUtils.join((Object[])fields, (char)','));
        }
        return this;
    }

    public QueryHelper and(String where) {
        this.whereSQL.append(" and (").append(where).append(") ");
        return this;
    }

    public QueryHelper and(boolean condition, String where) {
        if (condition) {
            this.whereSQL.append(" and (").append(where).append(") ");
        }
        return this;
    }

    public QueryHelper eq(String column, String value) {
        this.whereSQL.append(" and (").append(String.format("%s = '%s' ", column, value)).append(") ");
        return this;
    }

    public QueryHelper eq(boolean condition, String column, String value) {
        if (condition) {
            this.whereSQL.append(" and (").append(String.format("%s = '%s' ", column, value)).append(") ");
        }
        return this;
    }

    public QueryHelper or(String where) {
        this.whereSQL.append(" or (").append(where).append(") ");
        return this;
    }

    public QueryHelper or(boolean condition, String where) {
        if (condition) {
            this.whereSQL.append(" or (").append(where).append(") ");
        }
        return this;
    }

    public QueryHelper like(String keyword, String ... columnList) {
        return this.and(SQLHelper.buildSqlLikePart((String)keyword, (String[])columnList));
    }

    public QueryHelper like(boolean condition, String keyword, String ... columnList) {
        if (condition) {
            return this.and(SQLHelper.buildSqlLikePart((String)keyword, (String[])columnList));
        }
        return this;
    }

    public QueryHelper in(String column, String ... ids) {
        return this.and(SQLHelper.buildSqlInPart((String)column, (String[])ids));
    }

    public QueryHelper in(String column, Collection<String> ids) {
        return this.and(SQLHelper.buildSqlInPart((String)column, ids));
    }

    public QueryHelper notin(String column, String ... ids) {
        return this.and(SQLHelper.buildSqlInPart((String)(column + " not "), (String[])ids));
    }

    public QueryHelper notin(String column, Collection<String> ids) {
        return this.and(SQLHelper.buildSqlInPart((String)(column + " not "), ids));
    }

    public QueryHelper notin(boolean condition, String column, Collection<String> ids) {
        if (condition) {
            return this.notin(column, ids);
        }
        return this;
    }

    public QueryHelper notin(boolean condition, String column, String ... ids) {
        if (condition) {
            return this.notin(column, ids);
        }
        return this;
    }

    public QueryHelper between(String column, Object start, Object end) {
        return this.and(SQLHelper.buildSqlBetweenPart((String)column, (Object)start, (Object)end));
    }

    public QueryHelper in(boolean condition, String column, String ... ids) {
        if (condition) {
            return this.and(SQLHelper.buildSqlInPart((String)column, (String[])ids));
        }
        return this;
    }

    public QueryHelper in(boolean condition, String column, Collection<String> ids) {
        if (condition) {
            return this.and(SQLHelper.buildSqlInPart((String)column, ids));
        }
        return this;
    }

    public QueryHelper le(String column, Object data) {
        if (data instanceof Date) {
            this.and(String.format("%s <= '%s'", DateUtils.format((Date)((Date)data))));
        } else if (data instanceof String) {
            this.and(String.format("%s <= '%s'", column, data));
        } else {
            this.and(String.format("%s <= %s", column, data + ""));
        }
        return this;
    }

    public QueryHelper le(boolean condition, String column, Object data) {
        if (condition) {
            return this.le(column, data);
        }
        return this;
    }

    public QueryHelper lt(String column, Object data) {
        if (data instanceof Date || data instanceof String) {
            this.and(String.format("%s < '%s'", column, DateUtils.format((Date)((Date)data))));
        } else if (data instanceof String) {
            this.and(String.format("%s < '%s'", column, data));
        } else {
            this.and(String.format("%s < %s", column, data + ""));
        }
        return this;
    }

    public QueryHelper lt(boolean condition, String column, Object data) {
        if (condition) {
            return this.lt(column, data);
        }
        return this;
    }

    public QueryHelper ge(String column, Object data) {
        if (data instanceof Date || data instanceof String) {
            this.and(String.format("%s >= '%s'", column, DateUtils.format((Date)((Date)data))));
        } else if (data instanceof String) {
            this.and(String.format("%s >= '%s'", column, data));
        } else {
            this.and(String.format("%s >= %s", column, data + ""));
        }
        return this;
    }

    public QueryHelper ge(boolean condition, String column, Object data) {
        if (condition) {
            return this.ge(column, data);
        }
        return this;
    }

    public QueryHelper gt(String column, Object data) {
        if (data instanceof Date || data instanceof String) {
            this.and(String.format("%s > '%s'", column, DateUtils.format((Date)((Date)data))));
        } else if (data instanceof String) {
            this.and(String.format("%s > '%s'", column, data));
        } else {
            this.and(String.format("%s > %s", column, data + ""));
        }
        return this;
    }

    public QueryHelper limit(int offset, int count) {
        this.limitSQL = String.format("%d,%d", offset, count);
        return this;
    }

    public QueryHelper page(int page, int limit) {
        int offset = page > 1 ? (page - 1) * limit : 0;
        this.limitSQL = String.format("%d,%d", offset, limit);
        return this;
    }

    public QueryHelper limit(int limit) {
        this.limitSQL = String.format("%d", limit);
        return this;
    }

    public QueryHelper limit(boolean condition, int limit) {
        if (condition) {
            this.limitSQL = String.format("%d", limit);
        }
        return this;
    }

    public QueryHelper gt(boolean condition, String column, Object data) {
        if (condition) {
            return this.gt(column, data);
        }
        return this;
    }

    public QueryHelper groupBy(String groupBy) {
        if (this.groupBySQL.length() > 0) {
            this.groupBySQL.delete(0, this.groupBySQL.length() - 1);
        }
        this.groupBySQL.append(groupBy);
        return this;
    }

    public QueryHelper orderBy(String orderBy) {
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.delete(0, orderBy.length() - 1);
        }
        this.orderBySQL.append(orderBy);
        return this;
    }

    public QueryHelper join(String joinSql) {
        this.joinList.add(joinSql);
        return this;
    }

    public <T> T select(Class<T> clazz) {
        return (T)jdbcTemplate.queryForObject(this.toSql(), clazz);
    }

    public static <T> T select(String sql, Class<T> clazz, Object ... args) {
        return (T)jdbcTemplate.queryForObject(sql, clazz, args);
    }

    public static void executeSql(String sql) {
        jdbcTemplate.execute(sql);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public static int update(String sql, Object ... args) {
        return jdbcTemplate.update(sql, args);
    }

    public static void batchUpdate(String sql, List<Object[]> args) {
        jdbcTemplate.batchUpdate(sql, args);
    }

    public static void batchUpdate(String sql) {
        jdbcTemplate.batchUpdate(new String[]{sql});
    }

    public static <T> List<T> selectList(String sql, Class<T> clazz, Object ... args) {
        return jdbcTemplate.queryForList(sql, clazz, args);
    }

    public <T> List<T> selectList(Class<T> clazz) {
        return jdbcTemplate.queryForList(this.toSql(), clazz);
    }

    public <T> List<T> selectObjectList(Class<T> clazz) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(clazz);
        return jdbcTemplate.query(this.toSql(), (RowMapper)rowMapper, null);
    }

    public List<Map<String, Object>> selectList() {
        return ((JdbcTemplate)SpringContextUtils.getBean(JdbcTemplate.class)).queryForList(this.toSql());
    }

    public Map<String, Object> selectObject() {
        return ((JdbcTemplate)SpringContextUtils.getBean(JdbcTemplate.class)).queryForMap(this.toSql());
    }

    public PageData selectPage(int page, int pageSize) {
        this.limit(page, pageSize);
        List list = this.selectList();
        int total = this.count();
        return new PageData(list, (long)total);
    }

    public int count() {
        StringBuffer countSql = new StringBuffer("select count(1) from (").append(this.sql(true)).append(") t ");
        return (Integer)((JdbcTemplate)SpringContextUtils.getBean(JdbcTemplate.class)).queryForObject(countSql.toString(), Integer.class);
    }

    public String sql() {
        return this.sql(false);
    }

    public String sql(boolean nolimit) {
        StringBuffer sql = new StringBuffer("SELECT ");
        sql.append(this.fieldSQL).append(" FROM ").append(this.table);
        if (!this.joinList.isEmpty()) {
            for (String join : this.joinList) {
                sql.append(' ').append(join);
            }
        }
        sql.append(" where 1=1 ").append(this.whereSQL);
        if (this.groupBySQL.length() > 0) {
            sql.append(" group by ").append(this.groupBySQL);
        }
        if (this.orderBySQL.length() > 0) {
            sql.append(" order by ").append(this.orderBySQL);
        }
        if (!nolimit && StringUtils.isNotEmpty((CharSequence)this.limitSQL)) {
            sql.append(" limit ").append(this.limitSQL);
        }
        return sql.toString();
    }

    public String toSql() {
        System.out.println("[SQL]:" + this.sql());
        return this.sql();
    }
}

