/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.common.validator;

import com.huimin.common.exception.RenException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.validation.beanvalidation.MessageSourceResourceBundleLocator;

public class ValidatorUtils {
    private static Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)new MessageSourceResourceBundleLocator((MessageSource)ValidatorUtils.getMessageSource()))).buildValidatorFactory().getValidator();

    private static ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource bundleMessageSource = new ResourceBundleMessageSource();
        bundleMessageSource.setDefaultEncoding("UTF-8");
        bundleMessageSource.setBasenames(new String[]{"i18n/validation"});
        return bundleMessageSource;
    }

    public static void validateEntity(Object object, Class<?> ... groups) throws RenException {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            ConstraintViolation constraint = (ConstraintViolation)constraintViolations.iterator().next();
            throw new RenException(constraint.getMessage());
        }
    }
}

