/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.controller;

import com.alibaba.fastjson.JSON;
import com.huimin.DTO.FormDTO;
import com.huimin.common.annotation.LogOperation;
import com.huimin.common.page.PageData;
import com.huimin.common.result.Result;
import com.huimin.common.validator.AssertUtils;
import com.huimin.common.validator.ValidatorUtils;
import com.huimin.common.validator.group.AddGroup;
import com.huimin.common.validator.group.DefaultGroup;
import com.huimin.common.validator.group.UpdateGroup;
import com.huimin.controller.BaseController;
import com.huimin.service.FormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"form"})
@Api(tags={"\u8868\u5355\u7ba1\u7406"})
public class FormController
extends BaseController<FormDTO> {
    private static final Logger log = LoggerFactory.getLogger(FormController.class);
    @Resource
    private FormService formService;

    @GetMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u7801\uff0c\u4ece1\u5f00\u59cb", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="limit", value="\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="orderField", value="\u6392\u5e8f\u5b57\u6bb5", paramType="query", dataType="String"), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f\uff0c\u53ef\u9009\u503c(asc\u3001desc)", paramType="query", dataType="String")})
    public Result<PageData<FormDTO>> page(@ApiIgnore @RequestParam Map<String, Object> params) {
        log.info("FormController-page-params:" + JSON.toJSONString(params));
        PageData page = this.formService.page(params);
        return new Result().ok((Object)page);
    }

    @GetMapping(value={"{id}"})
    @ApiOperation(value="\u4fe1\u606f")
    public Result<FormDTO> get(@PathVariable(value="id") String id) {
        log.info("FormController-get-id:" + JSON.toJSONString((Object)id));
        FormDTO data = this.formService.get(id);
        return new Result().ok((Object)data);
    }

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u4fdd\u5b58")
    public Result save(@RequestBody FormDTO dto, HttpServletRequest request) {
        log.info("FormController-save-dto" + JSON.toJSONString((Object)dto));
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        return this.formService.save(dto, request);
    }

    @PostMapping(value={"{id}/enabled"})
    @ApiOperation(value="\u542f\u7528\u8868\u5355")
    @LogOperation(value="\u542f\u7528\u8868\u5355")
    public Result enabled(@PathVariable(value="id") String id) {
        log.info("FormController-enabled-id" + JSON.toJSONString((Object)id));
        this.formService.enableForm(id);
        return new Result();
    }

    @PostMapping(value={"{id}/disabled"})
    @ApiOperation(value="\u7981\u7528\u8868\u5355")
    @LogOperation(value="\u7981\u7528\u8868\u5355")
    public Result disbaled(@PathVariable(value="id") String id) {
        log.info("FormController-disbaled-id" + JSON.toJSONString((Object)id));
        this.formService.disbaleForm(id);
        return new Result();
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539")
    @LogOperation(value="\u4fee\u6539")
    public Result update(@RequestBody FormDTO dto) {
        log.info("FormController-update-dto" + JSON.toJSONString((Object)dto));
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.formService.update(dto);
        return new Result();
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664")
    public Result delete(@RequestBody String[] ids) throws Exception {
        log.info("FormController-delete-ids" + JSON.toJSONString((Object)ids));
        AssertUtils.isArrayEmpty((Object[])ids, (String[])new String[]{"id"});
        this.formService.delete(ids);
        return new Result();
    }
}

