/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.controller;

import com.alibaba.fastjson.JSON;
import com.huimin.DTO.FormTemplateDTO;
import com.huimin.common.annotation.LogOperation;
import com.huimin.common.annotation.NoNeedLogin;
import com.huimin.common.page.PageData;
import com.huimin.common.result.Result;
import com.huimin.common.validator.AssertUtils;
import com.huimin.common.validator.ValidatorUtils;
import com.huimin.common.validator.group.AddGroup;
import com.huimin.common.validator.group.DefaultGroup;
import com.huimin.common.validator.group.UpdateGroup;
import com.huimin.config.DatabaseConfig;
import com.huimin.controller.BaseController;
import com.huimin.service.FormTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"form/template"})
@Api(tags={"\u8868\u5355\u6a21\u7248\u7ba1\u7406"})
public class FormTemplateController
extends BaseController<FormTemplateDTO> {
    private static final Logger log = LoggerFactory.getLogger(FormTemplateController.class);
    @Resource
    private FormTemplateService formService;

    @GetMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u7801\uff0c\u4ece1\u5f00\u59cb", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="limit", value="\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="orderField", value="\u6392\u5e8f\u5b57\u6bb5", paramType="query", dataType="String"), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f\uff0c\u53ef\u9009\u503c(asc\u3001desc)", paramType="query", dataType="String")})
    public Result<PageData<FormTemplateDTO>> page(@ApiIgnore @RequestParam Map<String, Object> params) {
        log.info("FormTemplateController-page-params:" + JSON.toJSONString(params));
        PageData page = this.formService.page(params);
        return new Result().ok((Object)page);
    }

    @GetMapping(value={"{id}"})
    @ApiOperation(value="\u4fe1\u606f")
    public Result<FormTemplateDTO> get(@PathVariable(value="id") String id) {
        log.info("FormTemplateController-get-id:" + JSON.toJSONString((Object)id));
        FormTemplateDTO data = this.formService.get(id);
        return new Result().ok((Object)data);
    }

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u4fdd\u5b58")
    public Result save(@RequestBody FormTemplateDTO dto) {
        log.info("FormTemplateController-save-dto:" + JSON.toJSONString((Object)dto));
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        return this.formService.save(dto);
    }

    @PostMapping(value={"{id}/enabled"})
    @ApiOperation(value="\u542f\u7528")
    @LogOperation(value="\u542f\u7528")
    public Result enable(@PathVariable(value="id") String id) {
        log.info("FormTemplateController-enable-id:" + JSON.toJSONString((Object)id));
        this.formService.enable(id);
        return new Result();
    }

    @PostMapping(value={"{id}/disabled"})
    @ApiOperation(value="\u7981\u7528")
    @LogOperation(value="\u7981\u7528")
    public Result disable(@PathVariable(value="id") String id) {
        log.info("FormTemplateController-disable-id:" + JSON.toJSONString((Object)id));
        this.formService.disable(id);
        return new Result();
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539")
    @LogOperation(value="\u4fee\u6539")
    public Result update(@RequestBody FormTemplateDTO dto) {
        log.info("FormTemplateController-update-id:" + JSON.toJSONString((Object)dto));
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        return this.formService.update(dto);
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664")
    public Result delete(@RequestBody String[] ids) {
        log.info("FormTemplateController-delete-id:" + JSON.toJSONString((Object)ids));
        AssertUtils.isArrayEmpty((Object[])ids, (String[])new String[]{"id"});
        this.formService.delete(ids);
        return new Result();
    }

    @GetMapping(value={"/getTableList"})
    @NoNeedLogin
    public Object getTableList(@RequestParam(value="dbName", required=false) String dbName) throws Exception {
        return this.formService.getTableList(dbName);
    }

    @GetMapping(value={"/getFieldList"})
    public Object getFieldList(String tableName, @RequestParam(value="dbName", required=false) String dbName) throws Exception {
        return this.formService.getFieldList(tableName, dbName);
    }

    @GetMapping(value={"/getDataSource"})
    public Result<List<DatabaseConfig.DataSouceList>> getDataSourceList() {
        return this.formService.getDataSourceList();
    }
}

