/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.exception;

import com.huimin.common.utils.MessageUtils;

public class CommonException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int code;
    private String msg;

    public CommonException(int code) {
        this.code = code;
        this.msg = MessageUtils.getMessage((int)code);
    }

    public CommonException(int code, String ... params) {
        this.code = code;
        this.msg = MessageUtils.getMessage((int)code, (String[])params);
    }

    public CommonException(int code, Throwable e) {
        super(e);
        this.code = code;
        this.msg = MessageUtils.getMessage((int)code);
    }

    public CommonException(int code, Throwable e, String ... params) {
        super(e);
        this.code = code;
        this.msg = MessageUtils.getMessage((int)code, (String[])params);
    }

    public CommonException(String msg) {
        super(msg);
        this.code = 500;
        this.msg = msg;
    }

    public CommonException(String msg, Throwable e) {
        super(msg, e);
        this.code = 500;
        this.msg = msg;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}

