/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.huimin.DTO.FieldDTO;
import com.huimin.DTO.FormDTO;
import com.huimin.Enum.TemplateTypeEnum;
import com.huimin.common.exception.RenException;
import com.huimin.common.page.PageData;
import com.huimin.common.result.Result;
import com.huimin.common.utils.AuthUtil;
import com.huimin.common.utils.ConvertUtils;
import com.huimin.common.utils.TableUtil;
import com.huimin.config.DynamicDataSourceContextHolder;
import com.huimin.entity.FormEntity;
import com.huimin.mapper.FormMapper;
import com.huimin.service.FormService;
import com.huimin.service.FormTableService;
import com.huimin.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormServiceImpl
extends BaseServiceImpl<FormMapper, FormEntity>
implements FormService {
    private static final Logger log = LoggerFactory.getLogger(FormServiceImpl.class);
    @Autowired
    private FormTableService self;

    public PageData<FormDTO> page(Map<String, Object> params) {
        IPage page = ((FormMapper)this.baseDao).selectPage(this.getPage(params, "creater_date", false), (Wrapper)this.getWrapper(params));
        List records = page.getRecords();
        records.stream().forEach(f -> {
            f.setCreater(f.getCreaterName());
            f.setUpdater(f.getUpdaterName());
        });
        PageData pageData = this.getPageData(page, FormDTO.class);
        return pageData;
    }

    public List<FormDTO> list(Map<String, Object> params) {
        List entityList = ((FormMapper)this.baseDao).selectList((Wrapper)this.getWrapper(params));
        return ConvertUtils.sourceToTarget((Collection)entityList, FormDTO.class, (String[])new String[0]);
    }

    private QueryWrapper<FormEntity> getWrapper(Map<String, Object> params) {
        QueryWrapper wrapper = this.createWrapper(FormDTO.class, params);
        wrapper.eq((Object)"main_id", (Object)"0");
        wrapper.eq((Object)"is_deleted", (Object)0);
        return wrapper;
    }

    public FormDTO get(String id) {
        FormEntity entity = (FormEntity)((FormMapper)this.baseDao).selectById((Serializable)((Object)id));
        ArrayList<Object> formDTOList = new ArrayList<Object>();
        List formEntities = ((FormMapper)this.baseDao).selectList((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)id));
        for (FormEntity formEntity : formEntities) {
            formDTOList.add(ConvertUtils.sourceToTarget((Object)formEntity, FormDTO.class, (String[])new String[0]));
        }
        FormDTO formDTO = (FormDTO)ConvertUtils.sourceToTarget((Object)entity, FormDTO.class, (String[])new String[0]);
        formDTO.setFormDTOList(formDTOList);
        return formDTO;
    }

    public Result save(FormDTO dto, HttpServletRequest request) {
        if (!TemplateTypeEnum.T_TYPE_4.getKey().equals(dto.getTemplateType())) {
            Long existCount = ((FormMapper)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"table_name", (Object)dto.getTableName())).eq((Object)"is_deleted", (Object)0));
            if (existCount > 0L) {
                return new Result().error("\u53d1\u5e03\u5931\u8d25\uff0c\u5b58\u5728\u76f8\u540c\u7684\u4e1a\u52a1\u8868\u540d");
            }
            List fieldList = dto.getFieldList();
            if (ObjectUtils.isNotEmpty((Object)fieldList)) {
                Set collect = fieldList.stream().map(FieldDTO::getFieldName).collect(Collectors.toSet());
                if (fieldList.size() != collect.size()) {
                    return new Result().error("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5\u540d");
                }
            }
        }
        if (TemplateTypeEnum.T_TYPE_1.getKey().equals(dto.getTemplateType())) {
            return this.saveByTypeOne(dto);
        }
        if (TemplateTypeEnum.T_TYPE_2.getKey().equals(dto.getTemplateType())) {
            return this.saveByTypeTwo(dto);
        }
        if (TemplateTypeEnum.T_TYPE_3.getKey().equals(dto.getTemplateType())) {
            return this.saveByTypeThree(dto);
        }
        if (TemplateTypeEnum.T_TYPE_4.getKey().equals(dto.getTemplateType())) {
            return this.saveByTypeFour(dto);
        }
        return new Result();
    }

    public Result saveByTypeThree(FormDTO dto) {
        String id = String.valueOf(IdWorker.getId());
        FormEntity entity = (FormEntity)ConvertUtils.sourceToTarget((Object)dto, FormEntity.class, (String[])new String[0]);
        entity.setCreater(AuthUtil.getLoginUser().getUserId().toString());
        entity.setCreaterName(AuthUtil.getLoginUser().getNickName());
        entity.setCreaterDate(new Date());
        entity.setMainId("0");
        entity.setId(id);
        this.insert((Object)entity);
        return new Result();
    }

    public Result saveByTypeFour(FormDTO dto) {
        String id = String.valueOf(IdWorker.getId());
        FormEntity entity = (FormEntity)ConvertUtils.sourceToTarget((Object)dto, FormEntity.class, (String[])new String[0]);
        entity.setCreater(AuthUtil.getLoginUser().getUserId().toString());
        entity.setCreaterName(AuthUtil.getLoginUser().getNickName());
        entity.setCreaterDate(new Date());
        entity.setMainId("0");
        entity.setId(id);
        this.insert((Object)entity);
        return new Result();
    }

    public Result saveByTypeTwo(FormDTO dto) {
        String id = String.valueOf(IdWorker.getId());
        FormEntity entity = (FormEntity)ConvertUtils.sourceToTarget((Object)dto, FormEntity.class, (String[])new String[0]);
        entity.setCreater(AuthUtil.getLoginUser().getUserId().toString());
        entity.setCreaterName(AuthUtil.getLoginUser().getNickName());
        entity.setCreaterDate(new Date());
        entity.setMainId("0");
        entity.setId(id);
        this.insert((Object)entity);
        return new Result();
    }

    public Result saveByTypeOne(FormDTO dto) {
        String id = String.valueOf(IdWorker.getId());
        String tableName = TableUtil.buildTableName((String)dto.getTableName());
        dto.setWholeTableName(tableName);
        try {
            FormEntity entity = (FormEntity)ConvertUtils.sourceToTarget((Object)dto, FormEntity.class, (String[])new String[0]);
            entity.setCreater(AuthUtil.getLoginUser().getUserId().toString());
            entity.setCreaterName(AuthUtil.getLoginUser().getNickName());
            entity.setCreaterDate(new Date());
            entity.setId(id);
            entity.setWholeTableName(tableName);
            this.insert((Object)entity);
            String dbName = dto.getDbName();
            this.formCreateTable(dbName, tableName, dto, "0");
            List formDTOList = dto.getFormDTOList();
            if (ObjectUtils.isNotEmpty((Object)formDTOList)) {
                for (FormDTO formDTO : formDTOList) {
                    String tableNames = TableUtil.buildTableName((String)formDTO.getTableName());
                    FormEntity formEntity = (FormEntity)ConvertUtils.sourceToTarget((Object)formDTO, FormEntity.class, (String[])new String[0]);
                    formEntity.setCreater(AuthUtil.getLoginUser().getUserId().toString());
                    formEntity.setCreaterName(AuthUtil.getLoginUser().getNickName());
                    formEntity.setCreaterDate(new Date());
                    formEntity.setId(String.valueOf(IdWorker.getId()));
                    formEntity.setMainId(id);
                    formEntity.setDbName(dbName);
                    formEntity.setWholeTableName(tableNames);
                    formEntity.setFormId(entity.getFormId());
                    this.insert((Object)formEntity);
                    this.formCreateTable(dbName, tableNames, formDTO, "1");
                }
            }
        }
        catch (Exception e) {
            ((FormMapper)this.baseDao).deleteById((Serializable)((Object)id));
            ((FormMapper)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)id));
            log.info("=======save " + e);
            throw new RuntimeException("\u6dfb\u52a0\u5931\u8d25", e);
        }
        return new Result();
    }

    public void formCreateTable(String dbName, String tableName, FormDTO dto, String saveType) {
        try {
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            List fieldList = dto.getFieldList();
            if (saveType.equals("1")) {
                ((FormMapper)this.baseDao).createSubTable(tableName, dto.getComment());
            } else {
                ((FormMapper)this.baseDao).createTable(tableName, dto.getComment());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            Collections.reverse(fieldList);
            params.put("tableName", tableName);
            params.put("fields", fieldList);
            ((FormMapper)this.baseDao).addTableColumns(params);
            ArrayList<String> uniqueList = new ArrayList<String>();
            for (FieldDTO field : fieldList) {
                if (!ObjectUtils.isNotEmpty((Object)field.getUnique()) || !field.getUnique().booleanValue()) continue;
                uniqueList.add(field.getFieldName());
            }
            if (!uniqueList.isEmpty()) {
                ((FormMapper)this.baseDao).addUniqueConstraint(tableName, uniqueList);
            }
        }
        catch (Exception e) {
            ((FormMapper)this.baseDao).dropTable(dto.getTableName());
            List formDTOList = dto.getFormDTOList();
            for (FormDTO formDTO : formDTOList) {
                String tableNames = TableUtil.buildTableName((String)formDTO.getTableName());
                ((FormMapper)this.baseDao).dropTable(tableNames);
            }
            log.info("=======fromtable " + e);
            throw new RuntimeException("\u8868\u521b\u5efa\u5931\u8d25", e);
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }

    public void update(FormDTO dto) {
        try {
            FormEntity entity = (FormEntity)ConvertUtils.sourceToTarget((Object)dto, FormEntity.class, (String[])new String[0]);
            entity.setUpdater(AuthUtil.getLoginUser().getUserId().toString());
            entity.setUpdaterName(AuthUtil.getLoginUser().getNickName());
            entity.setUpdaterDate(new Date());
            this.updateById((Object)entity);
            String dbName = entity.getDbName();
            if (TemplateTypeEnum.T_TYPE_1.getKey().equals(dto.getTemplateType())) {
                this.updateTableColumns(dbName, dto);
                List formDTOList = dto.getFormDTOList();
                if (ObjectUtils.isNotEmpty((Object)formDTOList)) {
                    for (FormDTO formDTO : formDTOList) {
                        FormEntity formEntity = (FormEntity)ConvertUtils.sourceToTarget((Object)formDTO, FormEntity.class, (String[])new String[0]);
                        formEntity.setUpdater(AuthUtil.getLoginUser().getUserId().toString());
                        formEntity.setUpdaterName(AuthUtil.getLoginUser().getNickName());
                        formEntity.setUpdaterDate(new Date());
                        this.updateById((Object)formEntity);
                        this.updateTableColumns(dbName, formDTO);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateTableColumns(String dbName, FormDTO dto) {
        try {
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            String tableName = dto.getWholeTableName();
            List fieldList = dto.getFieldList();
            HashMap<String, Object> params = new HashMap<String, Object>();
            Collections.reverse(fieldList);
            params.put("tableName", tableName);
            params.put("fields", fieldList);
            ((FormMapper)this.baseDao).updateTableColumns(params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void delete(String[] ids) throws Exception {
        for (String id : ids) {
            FormDTO form = this.get(id);
            if (form != null && form.getStatus() != 0) {
                throw new RenException("\u8bf7\u5148\u7981\u7528\u8868\u5355!");
            }
            String userId = AuthUtil.getLoginUser().getUserId().toString();
            String nickName = AuthUtil.getLoginUser().getNickName();
            assert (form != null);
            String tableName = form.getWholeTableName();
            FormEntity entity = new FormEntity();
            entity.setId(id);
            entity.setUpdater(userId);
            entity.setUpdaterName(nickName);
            entity.setUpdaterDate(new Date());
            entity.setIsDeleted(Integer.valueOf(1));
            this.updateById((Object)entity);
            UpdateWrapper formEntityUpdateWrapper = new UpdateWrapper();
            formEntityUpdateWrapper.set((Object)"updater", (Object)userId);
            formEntityUpdateWrapper.set((Object)"updater_name", (Object)nickName);
            formEntityUpdateWrapper.set((Object)"updater_date", (Object)new Date());
            formEntityUpdateWrapper.set((Object)"is_deleted", (Object)1);
            formEntityUpdateWrapper.eq((Object)"main_id", (Object)id);
            ((FormMapper)this.baseDao).update(null, (Wrapper)formEntityUpdateWrapper);
            String dbName = form.getDbName();
            List formEntityList = ((FormMapper)this.baseDao).selectList((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)id));
            if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                this.self.deleteTables(dbName, tableName, formEntityList);
                continue;
            }
            if (!TemplateTypeEnum.T_TYPE_2.getKey().equals(form.getTemplateType()) && !TemplateTypeEnum.T_TYPE_3.getKey().equals(form.getTemplateType())) continue;
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void enableForm(String id) {
        ((FormMapper)this.baseDao).toggle(id, 1);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void disbaleForm(String id) {
        ((FormMapper)this.baseDao).toggle(id, 0);
    }
}

