/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.huimin.DTO.FieldDTO;
import com.huimin.DTO.FormTemplateDTO;
import com.huimin.common.page.PageData;
import com.huimin.common.result.Result;
import com.huimin.common.utils.AuthUtil;
import com.huimin.common.utils.ConvertUtils;
import com.huimin.config.DatabaseConfig;
import com.huimin.config.DynamicDataSourceContextHolder;
import com.huimin.entity.FormTemplateEntity;
import com.huimin.entity.TableEntity;
import com.huimin.mapper.CommonMapper;
import com.huimin.mapper.FormTemplateMapper;
import com.huimin.service.FormTemplateService;
import com.huimin.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FormTemplateServiceImpl
extends BaseServiceImpl<FormTemplateMapper, FormTemplateEntity>
implements FormTemplateService {
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private DataSource dataSource;
    @Autowired
    DatabaseConfig databaseConfig;

    public PageData<FormTemplateDTO> page(Map<String, Object> params) {
        IPage page = ((FormTemplateMapper)this.baseDao).selectPage(this.getPage(params, "creater_date", false), (Wrapper)this.getWrapper(params));
        List records = page.getRecords();
        PageData pageData = this.getPageData(page, FormTemplateDTO.class);
        return pageData;
    }

    public List<FormTemplateDTO> list(Map<String, Object> params) {
        List entityList = ((FormTemplateMapper)this.baseDao).selectList((Wrapper)this.getWrapper(params));
        return ConvertUtils.sourceToTarget((Collection)entityList, FormTemplateDTO.class, (String[])new String[0]);
    }

    private QueryWrapper<FormTemplateEntity> getWrapper(Map<String, Object> params) {
        QueryWrapper wrapper = this.createWrapper(FormTemplateDTO.class, params);
        wrapper.eq((Object)"main_id", (Object)"0");
        wrapper.eq((Object)"is_deleted", (Object)0);
        return wrapper;
    }

    public FormTemplateDTO get(String id) {
        FormTemplateEntity entity = (FormTemplateEntity)((FormTemplateMapper)this.baseDao).selectById((Serializable)((Object)id));
        List templateEntityList = ((FormTemplateMapper)this.baseDao).selectList((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)id));
        ArrayList<Object> formTemplateDTOS = new ArrayList<Object>();
        for (FormTemplateEntity templateEntity : templateEntityList) {
            formTemplateDTOS.add(ConvertUtils.sourceToTarget((Object)templateEntity, FormTemplateDTO.class, (String[])new String[0]));
        }
        FormTemplateDTO formTemplateDTO = (FormTemplateDTO)ConvertUtils.sourceToTarget((Object)entity, FormTemplateDTO.class, (String[])new String[0]);
        formTemplateDTO.setTemplateList(formTemplateDTOS);
        return formTemplateDTO;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Result save(FormTemplateDTO dto) {
        Long tableCount = ((FormTemplateMapper)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"name", (Object)dto.getName())).eq((Object)"is_deleted", (Object)0));
        if (tableCount > 0L) {
            return new Result().error("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u76f8\u540c\u7684\u6a21\u7248\u540d\u79f0\uff1a" + dto.getName());
        }
        List fieldList = dto.getFieldList();
        if (ObjectUtils.isNotEmpty((Object)fieldList)) {
            Set collect = fieldList.stream().map(FieldDTO::getFieldName).collect(Collectors.toSet());
            if (fieldList.size() != collect.size()) {
                return new Result().error("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5\u540d");
            }
        }
        String userId = AuthUtil.getLoginUser().getUserId().toString();
        String nickName = AuthUtil.getLoginUser().getNickName();
        FormTemplateEntity entity = (FormTemplateEntity)ConvertUtils.sourceToTarget((Object)dto, FormTemplateEntity.class, (String[])new String[0]);
        entity.setCreater(userId);
        entity.setCreaterName(nickName);
        entity.setCreaterDate(new Date());
        entity.setMainId("0");
        entity.setId(String.valueOf(IdWorker.getId()));
        this.insert((Object)entity);
        List formTemplateDTOList = dto.getTemplateList();
        if (null != formTemplateDTOList) {
            for (FormTemplateDTO formTemplateDTO : formTemplateDTOList) {
                Long tableCounts = ((FormTemplateMapper)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"name", (Object)formTemplateDTO.getName())).eq((Object)"is_deleted", (Object)0));
                if (tableCounts > 0L) {
                    this.deleteById((Serializable)((Object)entity.getId()));
                    return new Result().error("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u76f8\u540c\u7684\u6a21\u7248\u540d\u79f0\uff1a" + formTemplateDTO.getName());
                }
                List formTemplateDTOFieldList = formTemplateDTO.getFieldList();
                if (ObjectUtils.isNotEmpty((Object)formTemplateDTOFieldList)) {
                    Set collect = formTemplateDTOFieldList.stream().map(FieldDTO::getFieldName).collect(Collectors.toSet());
                    if (formTemplateDTOFieldList.size() != collect.size()) {
                        this.deleteById((Serializable)((Object)entity.getId()));
                        return new Result().error("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5\u540d:" + formTemplateDTO.getName());
                    }
                }
                FormTemplateEntity templateEntity = (FormTemplateEntity)ConvertUtils.sourceToTarget((Object)formTemplateDTO, FormTemplateEntity.class, (String[])new String[0]);
                templateEntity.setCreater(userId);
                templateEntity.setCreaterName(nickName);
                templateEntity.setCreaterDate(new Date());
                templateEntity.setMainId(entity.getId());
                templateEntity.setId(String.valueOf(IdWorker.getId()));
                this.insert((Object)templateEntity);
            }
        }
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Result update(FormTemplateDTO dto) {
        List fieldList = dto.getFieldList();
        if (ObjectUtils.isNotEmpty((Object)fieldList)) {
            Set collect = fieldList.stream().map(FieldDTO::getFieldName).collect(Collectors.toSet());
            if (fieldList.size() != collect.size()) {
                return new Result().error("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5\u540d");
            }
        }
        String userId = AuthUtil.getLoginUser().getUserId().toString();
        String nickName = AuthUtil.getLoginUser().getNickName();
        FormTemplateEntity entity = (FormTemplateEntity)ConvertUtils.sourceToTarget((Object)dto, FormTemplateEntity.class, (String[])new String[0]);
        entity.setUpdater(userId);
        entity.setUpdaterName(nickName);
        entity.setUpdaterDate(new Date());
        this.updateById((Object)entity);
        List templateList = dto.getTemplateList();
        if (ObjectUtils.isNotEmpty((Object)templateList) && templateList.size() > 0) {
            for (FormTemplateDTO templateDTO : templateList) {
                if (templateDTO.getId().equals("")) {
                    FormTemplateEntity saveEntity = (FormTemplateEntity)ConvertUtils.sourceToTarget((Object)templateDTO, FormTemplateEntity.class, (String[])new String[0]);
                    saveEntity.setCreater(userId);
                    saveEntity.setCreaterName(nickName);
                    saveEntity.setCreaterDate(new Date());
                    saveEntity.setMainId(entity.getId());
                    saveEntity.setId(String.valueOf(IdWorker.getId()));
                    this.insert((Object)saveEntity);
                    continue;
                }
                FormTemplateEntity templateEntity = (FormTemplateEntity)ConvertUtils.sourceToTarget((Object)templateDTO, FormTemplateEntity.class, (String[])new String[0]);
                templateEntity.setUpdater(userId);
                templateEntity.setUpdaterName(nickName);
                templateEntity.setUpdaterDate(new Date());
                this.updateById((Object)templateEntity);
            }
        } else {
            ((FormTemplateMapper)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)entity.getId()));
        }
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void delete(String[] ids) {
        for (String id : ids) {
            String userId = AuthUtil.getLoginUser().getUserId().toString();
            String nickName = AuthUtil.getLoginUser().getNickName();
            FormTemplateEntity entity = new FormTemplateEntity();
            entity.setId(id);
            entity.setUpdater(userId);
            entity.setUpdaterName(nickName);
            entity.setUpdaterDate(new Date());
            entity.setIsDeleted(Integer.valueOf(1));
            this.updateById((Object)entity);
            UpdateWrapper formTemplateEntityUpdateWrapper = new UpdateWrapper();
            formTemplateEntityUpdateWrapper.set((Object)"updater", (Object)userId);
            formTemplateEntityUpdateWrapper.set((Object)"updater_name", (Object)nickName);
            formTemplateEntityUpdateWrapper.set((Object)"updater_date", (Object)new Date());
            formTemplateEntityUpdateWrapper.set((Object)"is_deleted", (Object)1);
            formTemplateEntityUpdateWrapper.eq((Object)"main_id", (Object)id);
            ((FormTemplateMapper)this.baseDao).update(null, (Wrapper)formTemplateEntityUpdateWrapper);
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void enable(String id) {
        ((FormTemplateMapper)this.baseDao).toggle(id, 1);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void disable(String id) {
        ((FormTemplateMapper)this.baseDao).toggle(id, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTableList(String dataSource) throws Exception {
        try {
            if (null != dataSource && !dataSource.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dataSource);
            }
            String database = this.database();
            List list = this.commonMapper.showTabless(database);
            return list;
        }
        catch (Exception e) {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        return null;
    }

    public String database() throws Exception {
        Connection connection = this.dataSource.getConnection();
        DatabaseMetaData metaData = connection.getMetaData();
        String url = metaData.getURL();
        int index1 = url.lastIndexOf("/");
        int index2 = url.lastIndexOf("?");
        return url.substring(index1 + 1, index2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFieldList(String tableName, String dataSources) throws Exception {
        try {
            if (null != dataSources && !dataSources.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dataSources);
            }
            List showColumns = this.commonMapper.showColumns(tableName);
            String database = this.database();
            List tableEntities = this.commonMapper.showColumnss(tableName, database);
            Map collect = tableEntities.stream().collect(Collectors.toMap(TableEntity::getField, Function.identity()));
            ArrayList<FieldDTO> pageConfigList = new ArrayList<FieldDTO>();
            int sortIndex = 1;
            for (int i = 0; i < showColumns.size(); ++i) {
                String field = (String)((Map)showColumns.get(i)).get("Field");
                TableEntity tableEntity = (TableEntity)collect.get(field);
                FieldDTO dto = new FieldDTO();
                dto.setFieldName(tableEntity.getField());
                dto.setFieldDesc(tableEntity.getAnnotation());
                String type = tableEntity.getType();
                dto.setFieldType(FormTemplateServiceImpl.getSubstringInBrackets((String)type));
                dto.setMaxlength(FormTemplateServiceImpl.maxlength((String)type));
                dto.setSort(Integer.valueOf(sortIndex++));
                pageConfigList.add(dto);
            }
            Result result = new Result().ok(pageConfigList);
            return result;
        }
        catch (Exception e) {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        return null;
    }

    public Result<List<DatabaseConfig.DataSouceList>> getDataSourceList() {
        return new Result().ok((Object)this.databaseConfig.getDataSourceMap());
    }

    public static Integer maxlength(String input) {
        String regex = "\\(([^)]+)\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            String bracketData = matcher.group(1);
            return Integer.parseInt(bracketData);
        }
        return null;
    }

    public static String getSubstringInBrackets(String input) {
        int leftIndex = input.indexOf("(");
        String substring = new String(input);
        if (leftIndex != -1) {
            substring = input.substring(0, leftIndex);
        }
        switch (substring) {
            case "date": {
                return "Date";
            }
            case "datetime": {
                return "DateTime";
            }
            case "time": {
                return "Time";
            }
            case "int": {
                return "Integer";
            }
            case "bigint": {
                return "Long";
            }
            case "tinyint": {
                return "Boolean";
            }
        }
        return "String";
    }
}

