/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.huimin.DTO.CommonTreeDTO;
import com.huimin.common.page.PageData;
import com.huimin.common.utils.TreeUtils;
import com.huimin.entity.CommonEntity;
import com.huimin.exception.CommonException;
import com.huimin.mapper.CommonMapper;
import com.huimin.service.QueryService;
import com.huimin.service.impl.BaseServiceImpl;
import com.huimin.service.impl.QueryServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QueryServiceImpl
extends BaseServiceImpl<CommonMapper, CommonEntity>
implements QueryService {
    private static final Logger log = LogManager.getLogger(QueryServiceImpl.class);
    private static final Pattern paramPattern = Pattern.compile("^(\\w+)_(LK|EQ|GT|GTE|LT|LTE)$");
    @Resource
    private CommonMapper baseDao;

    public List<Map<String, Object>> queryTable(Map<String, Object> params, boolean refresh) {
        this.checkParams(params, refresh);
        return this.baseDao.getList(params);
    }

    private List<String> columnMapKeyList(String key, List<Map<String, String>> mapList) {
        ArrayList<String> valueList = new ArrayList<String>();
        for (Map<String, String> map : mapList) {
            valueList.add(map.get(key));
        }
        return valueList;
    }

    public List<CommonTreeDTO> queryTreeList(Map<String, Object> params) {
        QueryServiceImpl.buildQueryWrapper(params);
        List list = this.baseDao.queryTreeList(params);
        return TreeUtils.build((List)list);
    }

    public PageData<Map<String, Object>> queryPage(Map<String, Object> params, boolean refresh) {
        this.checkParams(params, refresh);
        IPage page = this.getPage(params, "creater_date", false);
        List list = this.baseDao.getList(params);
        return this.getPageData(list, page.getTotal());
    }

    private static void buildQueryWrapper(Map<String, Object> params) {
        QueryWrapper wrapper = new QueryWrapper();
        for (String key : params.keySet()) {
            Matcher m = paramPattern.matcher(key);
            if (!m.matches()) continue;
            String name = m.group(1);
            String logic = m.group(2);
            String value = (String)params.get(key);
            if (LogicEnum.EQ.name().equals(logic)) {
                wrapper.eq(StringUtils.isNotBlank((CharSequence)value), (Object)name, (Object)value);
            } else if (LogicEnum.GT.name().equals(logic)) {
                wrapper.gt(StringUtils.isNotBlank((CharSequence)value), (Object)name, (Object)value);
            } else if (LogicEnum.GE.name().equals(logic)) {
                wrapper.ge(StringUtils.isNotBlank((CharSequence)value), (Object)name, (Object)value);
            } else if (LogicEnum.LT.name().equals(logic)) {
                wrapper.lt(StringUtils.isNotBlank((CharSequence)value), (Object)name, (Object)value);
            } else if (LogicEnum.LE.name().equals(logic)) {
                wrapper.le(StringUtils.isNotBlank((CharSequence)value), (Object)name, (Object)value);
            } else if (LogicEnum.LK.name().equals(logic)) {
                wrapper.like(StringUtils.isNotBlank((CharSequence)value), (Object)name, (Object)value);
            } else {
                throw new CommonException("\u903b\u8f91\u5b57\u6bb5\u4ec5\u652f\u6301LK\uff0cEQ\uff0cGT\uff0cGTE\uff0cLT\uff0cLTE");
            }
            log.debug("{}:{}=>{}", (Object)name, (Object)logic, (Object)value);
        }
        params.put(wrapper.getParamAlias(), wrapper);
        params.put("paramSql", wrapper.getSqlSegment());
    }

    private void checkParams(Map<String, Object> params, boolean isCheck) {
        String fields = (String)params.get("fields");
        String tableName = (String)params.get("tableName");
        String[] fieldList = null;
        if (StringUtils.isEmpty((CharSequence)fields)) {
            fieldList = new String[]{"*"};
        } else {
            fieldList = StringUtils.split((String)fields, (char)',');
            String orderField = (String)params.get("orderField");
            if (StringUtils.isNotBlank((CharSequence)orderField) && fields.indexOf(orderField) < 0) {
                throw new CommonException(10034, new String[]{"\u6392\u5e8f\u5b57\u6bb5`" + orderField + "`"});
            }
        }
        params.put("fieldList", fieldList);
        QueryServiceImpl.buildQueryWrapper(params);
        if (isCheck) {
            List columnList = this.getFieldList(tableName);
            for (String field : fieldList) {
                if (columnList.contains(field)) continue;
                throw new CommonException(10034, new String[]{"\u5b57\u6bb5`" + tableName + "`.`" + field + "`"});
            }
            String tableInfo = this.baseDao.showTable(tableName);
            if (StringUtils.isBlank((CharSequence)tableInfo)) {
                throw new CommonException(10034, new String[]{"\u8868\u660e\u4e3a`" + tableName + "`"});
            }
        }
    }

    public List<String> getFieldList(String tableName) {
        return this.columnMapKeyList("Field", this.baseDao.showColumns(tableName));
    }

    public String[] getTableColumns(String tableName, boolean refresh) {
        List mapList = this.baseDao.showColumns(tableName);
        String[] fieldList = new String[mapList.size()];
        int index = 0;
        for (Map map : mapList) {
            fieldList[index++] = (String)map.get("Field");
        }
        return fieldList;
    }

    public List<String> getTableList(String database) {
        return this.baseDao.showTables(database);
    }
}

