/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.huimin.DTO.SysFillRuleDTO;
import com.huimin.common.page.PageData;
import com.huimin.common.result.Result;
import com.huimin.common.utils.ConvertUtils;
import com.huimin.entity.SysFillRuleEntity;
import com.huimin.handler.IFillRuleHandler;
import com.huimin.mapper.SysFillRuleMapper;
import com.huimin.service.SysFillRuleService;
import com.huimin.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="sysFillRuleServiceImpl")
public class SysFillRuleServiceImpl
extends BaseServiceImpl<SysFillRuleMapper, SysFillRuleEntity>
implements SysFillRuleService {
    private static final Logger log = LoggerFactory.getLogger(SysFillRuleServiceImpl.class);

    public PageData<SysFillRuleDTO> page(Map<String, Object> params) {
        IPage page = ((SysFillRuleMapper)this.baseDao).selectPage(this.getPage(params, "creater_time", false), (Wrapper)this.getWrapper(params));
        PageData pageData = this.getPageData(page, SysFillRuleDTO.class);
        return pageData;
    }

    private QueryWrapper<SysFillRuleEntity> getWrapper(Map<String, Object> params) {
        QueryWrapper wrapper = this.createWrapper(SysFillRuleDTO.class, params);
        return wrapper;
    }

    public List<SysFillRuleDTO> list(Map<String, Object> params) {
        List sysFillRuleEntities = ((SysFillRuleMapper)this.baseDao).selectList((Wrapper)this.getWrapper(params));
        return ConvertUtils.sourceToTarget((Collection)sysFillRuleEntities, SysFillRuleDTO.class, (String[])new String[0]);
    }

    public SysFillRuleDTO get(String id) {
        SysFillRuleEntity sysFillRuleEntity = (SysFillRuleEntity)((SysFillRuleMapper)this.baseDao).selectById((Serializable)((Object)id));
        SysFillRuleDTO sysFillRuleDTO = (SysFillRuleDTO)ConvertUtils.sourceToTarget((Object)sysFillRuleEntity, SysFillRuleDTO.class, (String[])new String[0]);
        return sysFillRuleDTO;
    }

    public Result save(SysFillRuleDTO dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rule_code", (Object)dto.getRuleCode());
        Long ruleCount = ((SysFillRuleMapper)this.baseDao).selectCount((Wrapper)queryWrapper);
        if (ruleCount > 0L) {
            return new Result().error("\u89c4\u5219\u7f16\u7801\u5df2\u91cd\u590d");
        }
        SysFillRuleEntity sysFillRuleEntity = (SysFillRuleEntity)ConvertUtils.sourceToTarget((Object)dto, SysFillRuleEntity.class, (String[])new String[0]);
        sysFillRuleEntity.setCreaterTime(new Date());
        this.insert((Object)sysFillRuleEntity);
        return new Result();
    }

    public void update(SysFillRuleDTO dto) {
        SysFillRuleEntity sysFillRuleEntity = (SysFillRuleEntity)ConvertUtils.sourceToTarget((Object)dto, SysFillRuleEntity.class, (String[])new String[0]);
        this.updateById((Object)sysFillRuleEntity);
    }

    public void delete(String id) throws Exception {
        this.deleteById((Serializable)((Object)id));
    }

    public Object executeRule(String ruleCode, JSONObject formData) {
        if (!StringUtils.isEmpty((CharSequence)ruleCode)) {
            try {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"rule_code", (Object)ruleCode);
                SysFillRuleEntity sysFillRuleEntity = (SysFillRuleEntity)((SysFillRuleMapper)this.baseDao).selectOne((Wrapper)queryWrapper);
                if (sysFillRuleEntity == null) {
                    log.warn("\u586b\u503c\u89c4\u5219\uff1a" + ruleCode + " \u4e0d\u5b58\u5728");
                    return null;
                }
                String ruleparams = sysFillRuleEntity.getRuleparams();
                String ruleClass = sysFillRuleEntity.getRuleClass();
                JSONObject params = JSONObject.parseObject((String)ruleparams);
                String ruleNumber = sysFillRuleEntity.getRuleNumber();
                if (params == null) {
                    params = new JSONObject();
                }
                if (formData == null) {
                    formData = new JSONObject();
                }
                IFillRuleHandler ruleHandler = (IFillRuleHandler)Class.forName(ruleClass).newInstance();
                JSONObject execute = ruleHandler.execute(params, formData, ruleNumber);
                String prefix = execute.getString("prefix");
                String number = execute.getString("number");
                if (ObjectUtil.isNotEmpty((Object)number)) {
                    prefix = prefix + number;
                }
                sysFillRuleEntity.setRuleNumber(number);
                ((SysFillRuleMapper)this.baseDao).updateById((Object)sysFillRuleEntity);
                return prefix;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

