/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.service.impl;

import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.huimin.DTO.FormDTO;
import com.huimin.DTO.ProcessDTO;
import com.huimin.Enum.FlowStatusEnum;
import com.huimin.VO.WorkFlowCallBackVO;
import com.huimin.common.exception.RenException;
import com.huimin.config.DynamicDataSourceContextHolder;
import com.huimin.exception.CommonException;
import com.huimin.service.FormService;
import com.huimin.service.WorkFlowService;
import com.huimin.service.impl.WorkFlowServiceImpl;
import com.huimin.util.HttpClientUtil.HttpClientService;
import com.huimin.util.HttpClientUtil.RequestParam;
import java.sql.SQLException;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkFlowServiceImpl
implements WorkFlowService {
    private static final Logger log = LoggerFactory.getLogger(WorkFlowServiceImpl.class);
    @Resource
    private FormService formService;
    @Resource
    private DataSource dataSource;
    @Resource
    private HttpClientService httpClientService;

    @Transactional(rollbackFor={Exception.class})
    public String startProcess(ProcessDTO processDTO, String relationStream, Object ... urlParams) throws Exception {
        if (urlParams != null) {
            processDTO.setAppFromUrl(String.format(processDTO.getAppFromUrl(), urlParams));
            processDTO.setFormUrl(String.format(processDTO.getFormUrl(), urlParams));
        }
        RequestParam param = new RequestParam();
        param.setUrl(relationStream);
        param.setPostParam(JSONObject.toJSONString((Object)processDTO));
        JSONObject json = this.httpClientService.httpPost(param);
        String code = json.getString("code");
        if (!"0".equals(code)) {
            throw new CommonException(json.getString("msg"));
        }
        return json.getString("data");
    }

    public void invoicingCallback(WorkFlowCallBackVO vo) {
        String event = vo.getEvent();
        FormDTO form = this.formService.get(vo.getBody().getBusinessKey());
        String tableName = form.getWholeTableName();
        Entity entity = Entity.create((String)tableName);
        String businessStatus = null;
        switch (1.$SwitchMap$com$huimin$VO$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!StringUtils.isNotBlank((CharSequence)vo.getBody().getBusinessStatus())) break;
                businessStatus = FlowStatusEnum.getDesc((String)vo.getBody().getBusinessStatus());
                break;
            }
            case 3: {
                if (!StringUtils.isNotBlank((CharSequence)vo.getBody().getBusinessStatus())) break;
                businessStatus = FlowStatusEnum.getDesc((String)vo.getBody().getBusinessStatus());
                break;
            }
            case 4: {
                businessStatus = FlowStatusEnum.getDesc((String)vo.getBody().getBusinessStatus());
            }
        }
        try {
            String dbName = form.getDbName();
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            if (StringUtils.isNotBlank((CharSequence)businessStatus)) {
                entity.set("business_status", (Object)businessStatus);
                DbUtil.use((DataSource)this.dataSource).update(entity, Entity.create().set("process_id", (Object)vo.getBody().getProcessInstanceId()));
            }
        }
        catch (SQLException e) {
            throw new RenException(e.getMessage());
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }
}

