/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.contract;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.dto.contract.ContractDTO;
import com.ruoyi.dto.contract.ContractDetailDTO;
import com.ruoyi.dto.contract.ContractNumberDTO;
import com.ruoyi.dto.contract.ContractProjectHandleDTO;
import com.ruoyi.dto.contract.ContractSettlementInformationDTO;
import com.ruoyi.dto.contract.ContractSupplineAccountOpeningInformationDTO;
import com.ruoyi.dto.contract.ContractSupplineApplicationInformationDTO;
import com.ruoyi.dto.contract.ContractSupplineExporDTO;
import com.ruoyi.dto.contract.ContractSupplineHandleDTO;
import com.ruoyi.dto.contract.ContractTerminationDTO;
import com.ruoyi.dto.contract.ContractWorkFormBackDTO;
import com.ruoyi.dto.contract.SupplineExporDTO;
import com.ruoyi.entity.contract.ContractEntity;
import com.ruoyi.enums.ContractParentCategorEnum;
import com.ruoyi.enums.DataStatusEnum;
import com.ruoyi.query.contract.ContractSupplierQuery;
import com.ruoyi.service.contract.ContractService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u4f9b\u5e94\u5546\u5408\u540c")
@RequestMapping(value={"/contractsupplier"})
@RestController
public class ContractSupplierController {
    private static final Logger log = LoggerFactory.getLogger(ContractSupplierController.class);
    @Autowired
    private ContractService contractService;

    @PostMapping(value={"/getContractSupplierListPage"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u5217\u8868\u9875\u9762")
    public R<PageResultVo<ContractDTO>> getContractSupplierListPage(@RequestBody ContractSupplierQuery query) {
        try {
            PageResultVo contractDTOListPage = this.contractService.getContractSupplierListPage(query);
            return R.ok((Object)contractDTOListPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportContractSupplineList"})
    @ApiOperation(value="\u5bfc\u51fa\u4f9b\u5e94\u5546\u5408\u540c")
    public void exportContractSupplineList(@RequestBody ContractSupplierQuery query, HttpServletResponse response) {
        try {
            List contractProjectList = this.contractService.getContractSupplineList(query);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u9879\u76ee\u5408\u540c", "\u9879\u76ee\u5408\u540c", ExcelType.XSSF), ContractSupplineExporDTO.class, (Collection)contractProjectList);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u9879\u76ee\u5408\u540c");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"getContractSupplineHandleDTOById"})
    @ApiOperation(value="\u4f9b\u5e94\u5546\u5408\u540c-\u8be6\u60c5", response=ContractProjectHandleDTO.class)
    public R<ContractSupplineHandleDTO> getContractSupplineHandleDTOById(Long id) {
        log.info("getContractSupplineHandleDTOById-id:" + id);
        try {
            ContractSupplineHandleDTO detailVo = this.contractService.getContractSupplineHandleDTOById(id);
            return R.ok((Object)detailVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/createContractSuppline"})
    @ApiOperation(value="\u521b\u5efa\u4f9b\u5e94\u5546\u5408\u540c\u4fe1\u606f")
    public R<String> createContractSuppline(@RequestBody ContractSupplineHandleDTO contractSupplineHandleDTO) {
        try {
            return R.ok((Object)this.contractService.createContractSuppline(contractSupplineHandleDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/terminationContract"})
    @ApiOperation(value="\u5408\u540c\u64cd\u4f5c-\u7ec8\u6b62")
    public R<Boolean> terminationContractSuppline(@RequestBody ContractTerminationDTO contractTerminationDTO) {
        try {
            return R.ok((Object)this.contractService.terminationContractSuppline(contractTerminationDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/updateContractSuppline"})
    @ApiOperation(value="\u4fee\u6539\u4f9b\u5e94\u5546\u5408\u540c\u4fe1\u606f")
    public R<Boolean> updateContractSuppline(@RequestBody ContractSupplineHandleDTO contractSupplineHandleDTO) {
        try {
            return R.ok((Object)this.contractService.updateContractSuppline(contractSupplineHandleDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u4f9b\u5e94\u5546\u5408\u540c\u4fe1\u606f-\u5220\u9664")
    public R<Boolean> deleteById(@PathVariable(value="id") Long id) {
        try {
            return R.ok((Object)this.contractService.deleteContractSuppline(id));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/workFromCallBackSupplineContract"})
    @ApiOperation(value="\u4f9b\u5e94\u5546\u5408\u540c-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBack(@RequestBody ContractWorkFormBackDTO contractWorkFormBackDTO) {
        try {
            log.info("workFromCallBackSupplineContract:" + JSON.toJSON((Object)contractWorkFormBackDTO));
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5bfc\u5165\u4f9b\u5e94\u5546\u5408\u540c")
    public void importMaterialArchives(MultipartFile file) throws ParseException {
        ExcelImportResult importResult;
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerify(true);
        try {
            importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), SupplineExporDTO.class, (ImportParams)importParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List supplineExporDTOS = importResult.getList();
        for (SupplineExporDTO supplineExporDTO : supplineExporDTOS) {
            ContractSupplineHandleDTO contractSupplineHandleDTO = new ContractSupplineHandleDTO();
            ContractDTO contractDTO = new ContractDTO();
            contractDTO.setContractStatus("3");
            contractSupplineHandleDTO.setContractDTO(contractDTO);
            ContractDetailDTO contractDetailDTO = new ContractDetailDTO();
            contractDetailDTO.setSigningType("\u5bbd\u5e26\u91c7\u8d2d\u5408\u540c");
            contractDetailDTO.setOurContractingUnit("\u6d59\u6c5f\u7ffc\u626c\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8");
            contractDetailDTO.setSupplier(supplineExporDTO.getT() + "\uff08\u5bfc\u5165\u5bbd\u5e26\u6570\u636e\uff09");
            ContractNumberDTO contractNumber = new ContractNumberDTO();
            contractNumber.setOurContractingUnit("\u6d59\u6c5f\u7ffc\u626c\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8");
            contractNumber.setContractType("\u5bbd\u5e26\u91c7\u8d2d\u5408\u540c");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            contractNumber.setContractSigningTime(format.parse(supplineExporDTO.getR()));
            contractDetailDTO.setContractNo(this.contractService.getContractNumber(contractNumber));
            contractDetailDTO.setContractAddress(supplineExporDTO.getF());
            contractDetailDTO.setContractName(supplineExporDTO.getA());
            contractDetailDTO.setContactsStartTime(supplineExporDTO.getQ());
            contractDetailDTO.setContactsEndTime(supplineExporDTO.getR());
            contractDetailDTO.setContractSigningDate(supplineExporDTO.getR());
            if (StringUtils.isNotEmpty((CharSequence)supplineExporDTO.getR())) {
                String[] split = supplineExporDTO.getR().split("-");
                contractDetailDTO.setContractYear(split[0]);
            }
            contractDetailDTO.setContractSignPerson("admin");
            contractDetailDTO.setContractSalesperson("admin");
            contractSupplineHandleDTO.setContractDetailDTO(contractDetailDTO);
            ContractSupplineApplicationInformationDTO ContractSupplineApplicationInformation = new ContractSupplineApplicationInformationDTO();
            ContractSupplineApplicationInformation.setProjectName(supplineExporDTO.getA());
            contractSupplineHandleDTO.setContractSupplineApplicationInformation(ContractSupplineApplicationInformation);
            ArrayList listContractSupplineApplicationInformationDTOS = new ArrayList();
            contractSupplineHandleDTO.setListContractSupplineApplicationInformationDTOS(listContractSupplineApplicationInformationDTOS);
            ContractSupplineAccountOpeningInformationDTO contractSupplineAccountOpeningInformation = new ContractSupplineAccountOpeningInformationDTO();
            contractSupplineHandleDTO.setContractSupplineAccountOpeningInformation(contractSupplineAccountOpeningInformation);
            ArrayList listContractSupplineTariffInformationDTOS = new ArrayList();
            contractSupplineHandleDTO.setListContractSupplineTariffInformationDTOS(listContractSupplineTariffInformationDTOS);
            ContractSettlementInformationDTO contractSettlementInformationDTO = new ContractSettlementInformationDTO();
            contractSupplineHandleDTO.setContractSettlementInformationDTO(contractSettlementInformationDTO);
            ArrayList listContractFileDTOS = new ArrayList();
            contractSupplineHandleDTO.setListContractFileDTOS(listContractFileDTOS);
            ContractEntity contractEntity = new ContractEntity();
            BeanUtils.copyProperties((Object)contractSupplineHandleDTO.getContractDetailDTO(), (Object)contractEntity);
            contractEntity.setContractCategory(ContractParentCategorEnum.suppline.name());
            contractEntity.setId(null);
            contractEntity.setCreateTime(new Date());
            contractEntity.setUpdateTime(new Date());
            contractEntity.setStatus(DataStatusEnum.INVALID.getCode());
            contractEntity.setContractEndTime(contractSupplineHandleDTO.getContractDetailDTO().getContactsEndTime());
            contractEntity.setContractStatus(contractSupplineHandleDTO.getContractDTO().getContractStatus());
            contractEntity.setContractSupplementarySignatureNumber(this.contractService.getContractSupplementarySignatureNumber(contractSupplineHandleDTO.getContractDetailDTO().getContractNo()) + "");
            contractEntity.setUpdateId(UserUtils.getLongUserId());
            contractEntity.setCreateId(UserUtils.getLongUserId());
            this.contractService.save((Object)contractEntity);
            this.contractService.handleContractSuppline(contractSupplineHandleDTO, contractEntity.getId());
        }
    }
}

