/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.contract;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.mapper.supply.StockListMapper;
import com.ruoyi.service.supply.InvoicingStatisticsService;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class ScheduledTasksController {
    @Autowired
    private HandleInvoicingStatistics handleInvoicingStatistics;
    @Resource
    private StockListMapper stockListMapper;
    @Resource
    private InvoicingStatisticsService invoicingStatisticsService;

    @Scheduled(cron="0 0 1 * * ?")
    public void AppTask01() throws Exception {
        List stockListDOList = this.stockListMapper.selectList((Wrapper)new LambdaQueryWrapper());
        if (ObjectUtil.isNotEmpty((Object)stockListDOList) && stockListDOList.size() > 0) {
            List materialId = stockListDOList.stream().map(m -> m.getMaterialId()).collect(Collectors.toList());
            try {
                List invoicingStatisticsList = this.handleInvoicingStatistics.createInvoicingStatisticsList(materialId);
                invoicingStatisticsList.forEach(a -> {
                    for (StockListDO stockListDO : stockListDOList) {
                        if (a.getMaterialId() != stockListDO.getMaterialId()) continue;
                        BigDecimal amount = this.handleInvoicingStatistics.setOutboundAmount(stockListDO.getCurrentStock(), a.getOpeningPrice());
                        a.setOpeningAmount(amount);
                        a.setOpeningQuantity(stockListDO.getCurrentStock());
                        a.setInboundAmount(null);
                        this.invoicingStatisticsService.save(a);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

