/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.EquipmentAllocationDTO;
import com.ruoyi.entity.supply.EquipmentAllocationDO;
import com.ruoyi.query.supply.EquipmentAllocationQuery;
import com.ruoyi.service.supply.EquipmentAllocationService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.EquipmentAllocationVO;
import com.ruoyi.vo.supply.ItemCategoryVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/equipmentAllocation"})
@RestController
@Api(tags={"\u8bbe\u5907\u8c03\u62e8"})
public class EquipmentAllocationController {
    private static final Logger log = LoggerFactory.getLogger(EquipmentAllocationController.class);
    @Resource
    private EquipmentAllocationService equipmentAllocationService;
    @Resource
    private SupplyUtils supplyUtils;

    @PostMapping(value={"/pageQueryEquipmentAllocation"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8bbe\u5907\u8c03\u62e8\u5217\u8868")
    public R<PageResultVo<EquipmentAllocationVO>> pageQueryEquipmentAllocation(@RequestBody EquipmentAllocationQuery equipmentAllocationQuery) {
        try {
            PageResultVo equipmentAllocationDOPageResultVo = this.equipmentAllocationService.pageQueryEquipmentAllocation(equipmentAllocationQuery);
            return R.ok((Object)equipmentAllocationDOPageResultVo);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/addEquipmentAllocation"})
    @ApiOperation(value="\u65b0\u589e\u8bbe\u5907\u8c03\u62e8")
    public R<String> addEquipmentAllocation(@RequestBody EquipmentAllocationDTO equipmentAllocationDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)equipmentAllocationDTO.getEquipmentAllocationDetailDTOList())) {
                return R.fail((String)"\u8c03\u62e8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.equipmentAllocationService.addEquipmentAllocation(equipmentAllocationDTO);
            return R.ok((Object)"\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PutMapping(value={"/updateEquipmentAllocationStatus"})
    @ApiOperation(value="\u4fee\u6539\u8bbe\u5907\u8c03\u62e8\u72b6\u6001")
    public R<String> updateEquipmentAllocationStatus(@RequestParam String status, @RequestParam Long id) {
        try {
            if (ObjectUtil.isEmpty((Object)id)) {
                R.fail((String)"\u4fee\u6539\u5931\u8d25\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.equipmentAllocationService.updateEquipmentAllocationStatus(status, id);
            return R.ok((Object)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/selectEquipmentAllocationDetail"})
    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    public R<EquipmentAllocationVO> selectEquipmentAllocationDetail(@RequestBody EquipmentAllocationDTO equipmentAllocationDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)equipmentAllocationDTO.getId())) {
                R.fail((String)"\u67e5\u770b\u5931\u8d25\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            EquipmentAllocationVO equipmentAllocationVO = this.equipmentAllocationService.selectEquipmentAllocationDetail(equipmentAllocationDTO.getId());
            return R.ok((Object)equipmentAllocationVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportEquipmentAllocation"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportEquipmentAllocation(@RequestBody EquipmentAllocationQuery equipmentAllocationQuery, HttpServletResponse response) {
        try {
            this.equipmentAllocationService.exportEquipmentAllocation(equipmentAllocationQuery, response);
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/cancelAllocation"})
    @ApiOperation(value="\u53d6\u6d88\u8c03\u62e8")
    public R<String> cancelAllocation(@RequestBody EquipmentAllocationDTO equipmentAllocationDTO) {
        try {
            EquipmentAllocationDO equipmentAllocationDO = (EquipmentAllocationDO)this.equipmentAllocationService.getById((Serializable)equipmentAllocationDTO.getId());
            if (equipmentAllocationDO.getAllocationStatus().equals("\u5ba1\u6838\u4e2d")) {
                this.equipmentAllocationService.cancelAllocation(equipmentAllocationDO);
                return R.ok((Object)"\u53d6\u6d88\u6210\u529f");
            }
            return R.fail((String)"\u8be5\u72b6\u6001\u4e0d\u652f\u6301\u53d6\u6d88\u8c03\u62e8");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/executionCompleted"})
    @ApiOperation(value="\u9879\u76ee\u8d1f\u8d23\u4eba\u70b9\u51fb\u5df2\u5b8c\u6210")
    public R<String> executionCompleted(@RequestBody EquipmentAllocationDTO equipmentAllocationDTO) {
        try {
            EquipmentAllocationDO equipmentAllocationDO = (EquipmentAllocationDO)this.equipmentAllocationService.getById((Serializable)equipmentAllocationDTO.getId());
            if (ObjectUtil.isNotEmpty((Object)equipmentAllocationDO.getInProjectLeader()) && equipmentAllocationDO.getInProjectLeader().contains(equipmentAllocationDTO.getCurrentLoginPeople())) {
                this.equipmentAllocationService.executionCompleted(equipmentAllocationDTO);
                return R.ok((Object)"\u6210\u529f");
            }
            return R.fail((String)"\u53ea\u6709\u9879\u76ee\u8d1f\u8d23\u4eba\u624d\u80fd\u6267\u884c\u5df2\u5b8c\u6210\u64cd\u4f5c");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/executiveEditor"})
    @ApiOperation(value="\u7f16\u8f91")
    public R<String> executiveEditor(@RequestBody EquipmentAllocationDTO equipmentAllocationDTO) {
        try {
            EquipmentAllocationDO equipmentAllocationDO = (EquipmentAllocationDO)this.equipmentAllocationService.getById((Serializable)equipmentAllocationDTO.getId());
            this.equipmentAllocationService.executiveEditor(equipmentAllocationDTO);
            return R.ok((Object)"\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getEquipmentAllocationDetail"})
    @ApiOperation(value="\u83b7\u53d6\u8c03\u62e8\u660e\u7ec6")
    public R<List<ItemCategoryVO>> getEquipmentAllocationDetail(@RequestBody EquipmentAllocationDTO equipmentAllocationDTO) {
        try {
            List equipmentAllocationDetail = this.supplyUtils.getEquipmentAllocationDetail(equipmentAllocationDTO.getOutProjectCode());
            return R.ok((Object)equipmentAllocationDetail);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getInProjectList"})
    @ApiOperation(value="\u83b7\u53d6\u8c03\u5165\u9879\u76ee\u5217\u8868")
    public R getInProjectList() {
        try {
            List inProjectList = this.equipmentAllocationService.getInProjectList();
            return R.ok((Object)inProjectList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getOutProjectList"})
    @ApiOperation(value="\u83b7\u53d6\u8c03\u51fa\u9879\u76ee\u5217\u8868")
    public R getOutProjectList() {
        try {
            List outProjectList = this.equipmentAllocationService.getOutProjectList();
            return R.ok((Object)outProjectList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u8bbe\u5907\u8c03\u62e8-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBack(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.equipmentAllocationService.workFromCallBack(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBackKeeper"})
    @ApiOperation(value="\u8bbe\u5907\u8c03\u62e8-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBackKeeper(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.equipmentAllocationService.workFromCallBackKeeper(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

