/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.EquipmentProfitLossDTO;
import com.ruoyi.dto.supply.EquipmentProfitLossMaterialListDTO;
import com.ruoyi.entity.supply.EquipmentProfitLossMaterialListDO;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.query.supply.EquipmentProfitLossQuery;
import com.ruoyi.service.supply.EquipmentProfitLossService;
import com.ruoyi.service.supply.InWarehouseManagementService;
import com.ruoyi.service.supply.MaterialCodeService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.supply.EquipmentProfitLossVO;
import com.ruoyi.vo.supply.InWarehouseManagementVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/equipmentProfitLoss"})
@RestController
@Api(tags={"\u8bbe\u5907\u635f\u76ca"})
public class EquipmentProfitLossController {
    private static final Logger log = LoggerFactory.getLogger(EquipmentProfitLossController.class);
    @Resource
    private EquipmentProfitLossService equipmentProfitLossService;
    @Resource
    private MaterialCodeService materialCodeService;
    @Resource
    private InWarehouseManagementService inWarehouseManagementService;
    @Resource
    private HandleInvoicingStatistics handleInvoicingStatistics;

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public R<PageResultVo<EquipmentProfitLossVO>> pageList(@RequestBody EquipmentProfitLossQuery equipmentProfitLossQuery) {
        try {
            PageResultVo equipmentProfitLossVOPageResultVo = this.equipmentProfitLossService.pageList(equipmentProfitLossQuery);
            return R.ok((Object)equipmentProfitLossVOPageResultVo);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getAttnList"})
    @ApiOperation(value="\u83b7\u53d6\u7ecf\u529e\u4eba\u5217\u8868")
    public R<List<String>> getAttnList() {
        try {
            List attnList = this.equipmentProfitLossService.getAttnList();
            return R.ok((Object)attnList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportExcel"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportExcel(@RequestBody EquipmentProfitLossQuery equipmentProfitLossQuery, HttpServletResponse response) {
        try {
            this.equipmentProfitLossService.exportExcel(equipmentProfitLossQuery, response);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25:{}", JSON.toJSON((Object)e));
        }
    }

    @PostMapping(value={"/getMaterialListExcel"})
    @ApiOperation(value="\u7269\u8d44\u5bfc\u51fa")
    public void getMaterialListExcel(@RequestBody EquipmentProfitLossDTO equipmentProfitLossDTO, HttpServletResponse response) {
        try {
            EquipmentProfitLossVO equipmentProfitLossVO = this.equipmentProfitLossService.queryDetail(equipmentProfitLossDTO.getId());
            List equipmentProfitLossMaterialListDOList = equipmentProfitLossVO.getEquipmentProfitLossMaterialListDOList();
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u5173\u8054\u5165\u5e93\u5355:\u7269\u8d44", "\u5173\u8054\u5165\u5e93\u5355:\u7269\u8d44", ExcelType.XSSF), EquipmentProfitLossMaterialListDO.class, (Collection)equipmentProfitLossMaterialListDOList);
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u5173\u8054\u5165\u5e93\u5355:\u7269\u8d44-" + dateFormat.format(date)));
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25:{}", JSON.toJSON((Object)e));
        }
    }

    @PostMapping(value={"/queryDetail"})
    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    public R<EquipmentProfitLossVO> queryDetail(@RequestBody EquipmentProfitLossDTO equipmentProfitLossDTO) {
        try {
            EquipmentProfitLossVO equipmentProfitLossVO = this.equipmentProfitLossService.queryDetail(equipmentProfitLossDTO.getId());
            return R.ok((Object)equipmentProfitLossVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getEquipmentProfitLossMaterialListDOs"})
    @ApiOperation(value="\u67e5\u770b\u5b50\u635f\u76ca\u8be6\u60c5")
    public R<EquipmentProfitLossVO> getEquipmentProfitLossMaterialListDOs(@RequestBody EquipmentProfitLossDTO equipmentProfitLossDTO) {
        try {
            EquipmentProfitLossVO equipmentProfitLossVO = this.equipmentProfitLossService.getEquipmentProfitLossVO(equipmentProfitLossDTO.getId());
            return R.ok((Object)equipmentProfitLossVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u635f\u76ca")
    public R<String> add(@RequestBody EquipmentProfitLossDTO equipmentProfitLossDTO) {
        try {
            List equipmentProfitLossMaterialListDTOList = equipmentProfitLossDTO.getEquipmentProfitLossMaterialListDTOList();
            if (ObjectUtil.isNotEmpty((Object)equipmentProfitLossMaterialListDTOList)) {
                for (EquipmentProfitLossMaterialListDTO a : equipmentProfitLossMaterialListDTOList) {
                    equipmentProfitLossMaterialListDTOList = equipmentProfitLossMaterialListDTOList.stream().filter(f -> "\u542f\u7528".equals(f.getOneYardPerObject())).collect(Collectors.toList());
                    if (StringUtils.isEmpty((CharSequence)a.getUniqueCodeCollection()) && a.getActualWarehouseingQuantity() != 0L) {
                        return R.fail((String)"\u65b0\u589e\u635f\u76ca\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    List<String> strings = Arrays.asList(a.getUniqueCodeCollection().split(","));
                    List materialCodes = this.materialCodeService.list((Wrapper)new QueryWrapper().in((Object)"material_code", strings));
                    List materialCode = materialCodes.stream().map(m -> m.getMaterialCode()).collect(Collectors.toList());
                    if (ObjectUtil.isEmpty(strings)) {
                        return R.fail((String)"\u65b0\u589e\u635f\u76ca\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    HashSet<String> set = new HashSet<String>(strings);
                    if (strings.size() != set.size()) {
                        return R.fail((String)"\u65b0\u589e\u635f\u76ca\u5931\u8d25,\u552f\u4e00\u7801\u5b58\u5728\u91cd\u590d\u6570\u636e");
                    }
                    if (a.getLossProfitQuantity() != (long)strings.size()) {
                        return R.fail((String)"\u65b0\u589e\u635f\u76ca\u5931\u8d25,\u635f\u76ca\u6570\u91cf\u4e0e\u91c7\u96c6\u552f\u4e00\u7801\u6570\u91cf\u4e0d\u4e00\u81f4");
                    }
                    if ("yes".equals(equipmentProfitLossDTO.getIsRelated()) && "\u635f".equals(a.getLossProfitWay())) {
                        if (!ObjectUtil.isNotEmpty(materialCode)) continue;
                        for (String string : strings) {
                            if (materialCode.contains(string)) continue;
                            return R.fail((String)("\u65b0\u589e\u635f\u76ca\u5931\u8d25\uff0c\u7269\u8d44\u540d\u79f0\uff1a" + a.getMaterialName() + ",\u552f\u4e00\u91c7\u96c6\u7801\uff1a" + string + ",\u4e0d\u5b58\u5728"));
                        }
                        continue;
                    }
                    if (!ObjectUtil.isNotEmpty(materialCode)) continue;
                    return R.fail((String)("\u65b0\u589e\u635f\u76ca\u5931\u8d25\uff0c\u7269\u8d44\u540d\u79f0\uff1a" + a.getMaterialName() + ",\u552f\u4e00\u91c7\u96c6\u7801\uff1a" + materialCode + "\u5df2\u5b58\u5728"));
                }
            }
            this.equipmentProfitLossService.add(equipmentProfitLossDTO);
            return R.ok((Object)"\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u9a73\u56de\u4fee\u6539\u635f\u76ca")
    public R<String> update(@RequestBody EquipmentProfitLossDTO equipmentProfitLossDTO) {
        try {
            List equipmentProfitLossMaterialListDTOList = equipmentProfitLossDTO.getEquipmentProfitLossMaterialListDTOList();
            if (ObjectUtil.isNotEmpty((Object)equipmentProfitLossMaterialListDTOList)) {
                for (EquipmentProfitLossMaterialListDTO a : equipmentProfitLossMaterialListDTOList) {
                    equipmentProfitLossMaterialListDTOList = equipmentProfitLossMaterialListDTOList.stream().filter(f -> "\u542f\u7528".equals(f.getOneYardPerObject())).collect(Collectors.toList());
                    if (StringUtils.isEmpty((CharSequence)a.getUniqueCodeCollection()) && a.getActualWarehouseingQuantity() != 0L) {
                        return R.fail((String)"\u65b0\u589e\u635f\u76ca\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    List<String> strings = Arrays.asList(a.getUniqueCodeCollection().split(","));
                    List materialCodes = this.materialCodeService.list((Wrapper)new QueryWrapper().in((Object)"material_code", strings));
                    List materialCode = materialCodes.stream().map(m -> m.getMaterialCode()).collect(Collectors.toList());
                    if (ObjectUtil.isEmpty(strings)) {
                        return R.fail((String)"\u65b0\u589e\u635f\u76ca\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    HashSet<String> set = new HashSet<String>(strings);
                    if (strings.size() != set.size()) {
                        return R.fail((String)"\u65b0\u589e\u635f\u76ca\u5931\u8d25,\u552f\u4e00\u7801\u5b58\u5728\u91cd\u590d\u6570\u636e");
                    }
                    if (a.getLossProfitQuantity() != (long)strings.size()) {
                        return R.fail((String)"\u65b0\u589e\u635f\u76ca\u5931\u8d25,\u635f\u76ca\u6570\u91cf\u4e0e\u91c7\u96c6\u552f\u4e00\u7801\u6570\u91cf\u4e0d\u4e00\u81f4");
                    }
                    if ("yes".equals(equipmentProfitLossDTO.getIsRelated()) && "\u635f".equals(a.getLossProfitWay())) {
                        if (!ObjectUtil.isNotEmpty(materialCode)) continue;
                        for (String string : strings) {
                            if (materialCode.contains(string)) continue;
                            return R.fail((String)("\u65b0\u589e\u635f\u76ca\u5931\u8d25\uff0c\u7269\u8d44\u540d\u79f0\uff1a" + a.getMaterialName() + ",\u552f\u4e00\u91c7\u96c6\u7801\uff1a" + string + ",\u4e0d\u5b58\u5728"));
                        }
                        continue;
                    }
                    if (!ObjectUtil.isNotEmpty(materialCode)) continue;
                    return R.fail((String)("\u65b0\u589e\u635f\u76ca\u5931\u8d25\uff0c\u7269\u8d44\u540d\u79f0\uff1a" + a.getMaterialName() + ",\u552f\u4e00\u91c7\u96c6\u7801\uff1a" + materialCode + "\u5df2\u5b58\u5728"));
                }
            }
            this.equipmentProfitLossService.update(equipmentProfitLossDTO);
            return R.ok((Object)"\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getInWarehouseManagementOrder"})
    @ApiOperation(value="\u83b7\u53d6\u8fd12\u4e2a\u6708\u7684\u5165\u5e93\u5355")
    public R<List<InWarehouseManagementVO>> getInWarehouseManagementOrder() {
        try {
            List inWarehouseManagementOrder = this.inWarehouseManagementService.getInWarehouseManagementOrder();
            return R.ok((Object)inWarehouseManagementOrder);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialList"})
    @ApiOperation(value="\u5173\u8054\u5165\u5e93\u5355\uff1a\u6839\u636e\u5165\u5e93\u5355Id\u83b7\u53d6\u7269\u8d44\u5217\u8868:\u7269\u8d44\u540d\u79f0\u3001\u7269\u8d44\u89c4\u683c\u3001\u91c7\u8d2d\u91cf\u3001\u5b9e\u9645\u5165\u5e93\u91cf\u3001\u5355\u4ef7\u3001\u603b\u4ef7")
    public R<List<EquipmentProfitLossMaterialListDTO>> getMaterialList(@RequestBody EquipmentProfitLossDTO equipmentProfitLossDTO) {
        try {
            List equipmentProfitLossMaterialListDTOList = this.inWarehouseManagementService.getMaterialList(equipmentProfitLossDTO.getInWarehouseOrderID());
            return R.ok((Object)equipmentProfitLossMaterialListDTOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u8bbe\u5907\u635f\u76ca-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBack(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.equipmentProfitLossService.workFromCallBack(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBacktwo"})
    @ApiOperation(value="\u8bbe\u5907\u635f\u76ca-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBacktwo(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.equipmentProfitLossService.workFromCallBacktwo(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

