/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.query.supply.StockListQuery;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.supply.StockExportVO;
import com.ruoyi.vo.supply.StockListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/stockList"})
@RestController
@Api(tags={"\u5e93\u5b58\u7ba1\u7406"})
public class StockListController {
    private static final Logger log = LoggerFactory.getLogger(StockListController.class);
    @Resource
    private StockListService stockListService;

    @PostMapping(value={"/getStockListVoPage"})
    @ApiOperation(value="\u5e93\u5b58\u5217\u8868\u663e\u793a")
    public R<PageResultVo<StockListVO>> getStockListVoPage(@RequestBody StockListQuery stockListQuery) {
        try {
            PageResultVo stockListVoPage = this.stockListService.getStockListVoPage(stockListQuery);
            return R.ok((Object)stockListVoPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/updates"})
    @ApiOperation(value="\u4fee\u6539\u5e93\u5b58\u6570\u636e")
    public R updates(@RequestBody StockListDO stockListDO) {
        try {
            String updates = this.stockListService.updates(stockListDO);
            if (updates.equals("true")) {
                return R.ok((Object)"\u4fee\u6539\u6210\u529f");
            }
            return R.fail((String)updates);
        }
        catch (Exception e) {
            e.getMessage();
            R.fail((String)"\u4fee\u6539\u5931\u8d25");
            return null;
        }
    }

    @PostMapping(value={"/exportStock"})
    @ApiOperation(value="\u5e93\u5b58\u5bfc\u51fa")
    public void exportStock(@RequestBody StockListQuery stockListQuery, HttpServletResponse response) {
        try {
            List stockExportVOS = this.stockListService.exportStock(stockListQuery, response);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u5e93\u5b58\u5217\u8868", "\u5e93\u5b58\u5217\u8868", ExcelType.XSSF), StockExportVO.class, (Collection)stockExportVOS);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u5e93\u5b58\u5217\u8868");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/getMaterialStockCount"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u5e93\u5b58\u6570\u91cf")
    public R getMaterialStockCount(@RequestParam String materialName) {
        try {
            Long stockCount = this.stockListService.getMaterialStockCount(materialName);
            return R.ok((Object)stockCount);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialName"})
    @ApiOperation(value="\u6839\u636e\u7269\u8d44\u7c7b\u522bid\u83b7\u53d6\u7269\u8d44\u540d\u79f0")
    public R getMaterialName(@RequestParam Long materialTypeId) {
        try {
            return R.ok((Object)this.stockListService.getMaterialName(materialTypeId));
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getDemandDetail"})
    @ApiOperation(value="\u83b7\u53d6\u9700\u6c42\u660e\u7ec6")
    public R getDemandDetail(@RequestParam String materialName) {
        try {
            StockListVO stockListVO = this.stockListService.getDemandDetail(materialName);
            return R.ok((Object)stockListVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

