/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.SupplierArchiveDTO;
import com.ruoyi.query.supply.SupplierArchiveQuery;
import com.ruoyi.service.supply.SupplierArchiveService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.supply.SupplierArchiveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/supplierArchive"})
@RestController
@Api(tags={"\u4f9b\u5e94\u5546\u6863\u6848"})
public class SupplierArchiveController {
    private static final Logger log = LoggerFactory.getLogger(SupplierArchiveController.class);
    @Resource
    private SupplierArchiveService supplierArchiveService;

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public R<PageResultVo<SupplierArchiveVO>> pageList(@RequestBody SupplierArchiveQuery supplierArchiveQuery) {
        try {
            PageResultVo supplierArchiveVOPageResultVo = this.supplierArchiveService.pageList(supplierArchiveQuery);
            return R.ok((Object)supplierArchiveVOPageResultVo);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PutMapping(value={"/updateStatus"})
    @ApiOperation(value="\u542f\u7528\u3001\u505c\u7528")
    public R<String> updateStatus(@RequestBody SupplierArchiveDTO supplierArchiveDTO) {
        try {
            this.supplierArchiveService.updateStatus(supplierArchiveDTO);
            return R.ok((Object)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e")
    public R<String> add(@RequestBody SupplierArchiveDTO supplierArchiveDTO) {
        try {
            this.supplierArchiveService.add(supplierArchiveDTO);
            return R.ok((Object)"\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportExcel"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportExcel(@RequestBody SupplierArchiveQuery supplierArchiveQuery, HttpServletResponse response) {
        try {
            this.supplierArchiveService.exportExcel(supplierArchiveQuery, response);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @PostMapping(value={"/importExcel"})
    @ApiOperation(value="\u5bfc\u5165")
    public R importExcel(MultipartFile file) {
        try {
            String s = this.supplierArchiveService.importSupplierArchive(file);
            if (s.equals("true")) {
                return R.ok((Object)s);
            }
            return R.fail((String)s);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getSupplierNameList"})
    @ApiOperation(value="\u83b7\u53d6\u4f9b\u5e94\u5546\u540d\u79f0\u3001\u5730\u5740\u3001id")
    public R<List<SupplierArchiveVO>> getSupplierNameList() {
        try {
            List supplerNameList = this.supplierArchiveService.getSupplierNameList();
            return R.ok((Object)supplerNameList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/downloadTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public R downloadTemplate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.supplierArchiveService.downloadTemplate(request, response, "\u4f9b\u5e94\u5546\u6863\u6848\u5bfc\u5165\u6a21\u677f.xls");
            return R.ok((Object)"\u4e0b\u8f7d\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/editor"})
    @ApiOperation(value="\u7f16\u8f91")
    public R editor(@RequestBody SupplierArchiveDTO supplierArchiveDTO) {
        try {
            this.supplierArchiveService.editor(supplierArchiveDTO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/queryDetail"})
    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    public R queryDetail(@RequestBody SupplierArchiveDTO supplierArchiveDTO) {
        try {
            return R.ok((Object)this.supplierArchiveService.queryDetail(supplierArchiveDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

