/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.handle.supply;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.dto.HandlelnvoicingDto;
import com.ruoyi.dto.supply.EquipmentProfitLossMaterialListDTO;
import com.ruoyi.dto.supply.InWarehouseManagementDetailDTO;
import com.ruoyi.dto.supply.InventoryManagementListDTO;
import com.ruoyi.dto.supply.MaterialArchivesDTO;
import com.ruoyi.entity.supply.AdoptionReturnItemListDO;
import com.ruoyi.entity.supply.InWarehouseManagementDetailDO;
import com.ruoyi.entity.supply.InvoicingStatisticsDO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.entity.supply.OutWarehouseManagementDemandDetailDO;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.mapper.supply.MaterialArchivesMapper;
import com.ruoyi.mapper.supply.StockListMapper;
import com.ruoyi.service.supply.InvoicingStatisticsService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class HandleInvoicingStatistics {
    @Resource
    private StockListMapper stockListMapper;
    @Resource
    private InvoicingStatisticsService invoicingStatisticsService;
    @Resource
    private MaterialArchivesMapper materialArchivesMapper;

    public void updateStockMaterial(MaterialArchivesDTO materialArchivesDTO) {
        StockListDO stockListDO = this.stockListMapper.OnBasisMaterialIdGetStockListDO(materialArchivesDTO.getId());
        if (ObjectUtil.isNotEmpty((Object)stockListDO)) {
            stockListDO.setMaterialName(materialArchivesDTO.getMaterialName());
            stockListDO.setMaterialSpecification(materialArchivesDTO.getMaterialSpecification());
            stockListDO.setAssociatedSupplier(materialArchivesDTO.getAssociatedSupplier());
            stockListDO.setAssociatedSupplierId(materialArchivesDTO.getAssociatedSupplierId());
            stockListDO.setUnitMeasurement(materialArchivesDTO.getUnitMeasurement());
            stockListDO.setReferencePrice(materialArchivesDTO.getReferencePrice());
            stockListDO.setUpdateTime(new Date());
            this.stockListMapper.updateById((Object)stockListDO);
        }
    }

    public void saveInvoicingStatisticsDO(MaterialArchivesDO materialArchivesDO) throws ParseException {
        InvoicingStatisticsDO invoicingStatisticsDO = new InvoicingStatisticsDO();
        invoicingStatisticsDO.setCreateTime(new Date());
        invoicingStatisticsDO.setUpdateTime(new Date());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String format = formatter.format(new Date());
        invoicingStatisticsDO.setOccurrenceTime(formatter.parse(format));
        invoicingStatisticsDO.setItemNumber(materialArchivesDO.getMaterialNumber());
        invoicingStatisticsDO.setItemName(materialArchivesDO.getMaterialName());
        invoicingStatisticsDO.setMaterialId(materialArchivesDO.getId());
        invoicingStatisticsDO.setSpecificationsModels(materialArchivesDO.getMaterialSpecification());
        invoicingStatisticsDO.setMeasureUnit(materialArchivesDO.getUnitMeasurement());
        invoicingStatisticsDO.setOpeningPrice(materialArchivesDO.getReferencePrice());
        invoicingStatisticsDO.setOpeningPrice(new BigDecimal(0));
        invoicingStatisticsDO.setOpeningQuantity(Long.valueOf(0L));
        invoicingStatisticsDO.setInboundCount(Long.valueOf(0L));
        invoicingStatisticsDO.setInboundAmount(new BigDecimal(0));
        invoicingStatisticsDO.setOutboundAmount(new BigDecimal(0));
        invoicingStatisticsDO.setOutboundCount(Long.valueOf(0L));
        invoicingStatisticsDO.setCountProfitLossAmount(new BigDecimal(0));
        invoicingStatisticsDO.setCountProfitLossQuantity(Long.valueOf(0L));
        invoicingStatisticsDO.setProfitLossAmount(new BigDecimal(0));
        invoicingStatisticsDO.setProfitLossQuantity(Long.valueOf(0L));
        invoicingStatisticsDO.setAmountReceived(new BigDecimal(0));
        invoicingStatisticsDO.setQuantityReceived(Long.valueOf(0L));
        invoicingStatisticsDO.setReturnAmount(new BigDecimal(0));
        invoicingStatisticsDO.setReturnQuantity(Long.valueOf(0L));
        invoicingStatisticsDO.setRecoveredAmount(new BigDecimal(0));
        invoicingStatisticsDO.setRecoveredQuantity(Long.valueOf(0L));
        invoicingStatisticsDO.setEndingPrice(materialArchivesDO.getReferencePrice());
        invoicingStatisticsDO.setEndingAmount(new BigDecimal(0));
        invoicingStatisticsDO.setEndingQuantity(Long.valueOf(0L));
        invoicingStatisticsDO.setIsDeleted(Integer.valueOf(0));
        this.invoicingStatisticsService.save((Object)invoicingStatisticsDO);
    }

    public void updateOpeningEndingPrice(MaterialArchivesDO materialArchivesDO, Long id) throws ParseException {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(InvoicingStatisticsDO::getMaterialId, (Object)id);
        InvoicingStatisticsDO invoicingStatisticsDO = (InvoicingStatisticsDO)this.invoicingStatisticsService.getOne((Wrapper)wrapper);
        invoicingStatisticsDO.setItemNumber(materialArchivesDO.getMaterialNumber());
        invoicingStatisticsDO.setItemName(materialArchivesDO.getMaterialName());
        invoicingStatisticsDO.setSpecificationsModels(materialArchivesDO.getMaterialSpecification());
        invoicingStatisticsDO.setMeasureUnit(materialArchivesDO.getUnitMeasurement());
        invoicingStatisticsDO.setOpeningPrice(materialArchivesDO.getReferencePrice());
        invoicingStatisticsDO.setEndingPrice(materialArchivesDO.getReferencePrice());
        invoicingStatisticsDO.setUpdateTime(new Date());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String format = formatter.format(new Date());
        invoicingStatisticsDO.setOccurrenceTime(formatter.parse(format));
        this.invoicingStatisticsService.updateById((Object)invoicingStatisticsDO);
    }

    public void inStockUpdateInvoicingStatistics(List<InWarehouseManagementDetailDO> inWarehouseManagementDetailDTOList) throws ParseException {
        ArrayList<InvoicingStatisticsDO> updateInvoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        if (ObjectUtil.isEmpty(inWarehouseManagementDetailDTOList)) {
            return;
        }
        List materialIds = inWarehouseManagementDetailDTOList.stream().map(m -> m.getMaterialId()).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(InvoicingStatisticsDO::getOccurrenceTime, (Object)format);
        wrapper.in(InvoicingStatisticsDO::getMaterialId, materialIds);
        List invoicingStatisticsDOList = this.invoicingStatisticsService.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)invoicingStatisticsDOList)) {
            for (InWarehouseManagementDetailDO inWarehouseManagementDetailDTO : inWarehouseManagementDetailDTOList) {
                InvoicingStatisticsDO invoicingStatisticsDO = new InvoicingStatisticsDO();
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)inWarehouseManagementDetailDTO.getMaterialId());
                if (!ObjectUtil.isNotEmpty((Object)materialArchivesDO)) continue;
                if (materialArchivesDO.getMaterialName() != null) {
                    invoicingStatisticsDO.setItemName(materialArchivesDO.getMaterialName());
                }
                if (materialArchivesDO.getReferencePrice() != null) {
                    invoicingStatisticsDO.setInboundAmount(materialArchivesDO.getReferencePrice());
                }
                if (materialArchivesDO.getMaterialNumber() != null) {
                    invoicingStatisticsDO.setItemNumber(materialArchivesDO.getMaterialNumber());
                }
                if (materialArchivesDO.getId() != null) {
                    invoicingStatisticsDO.setMaterialId(materialArchivesDO.getId());
                }
                if (materialArchivesDO.getMaterialSpecification() != null) {
                    invoicingStatisticsDO.setSpecificationsModels(materialArchivesDO.getMaterialSpecification());
                }
                if (materialArchivesDO.getUnitMeasurement() != null) {
                    invoicingStatisticsDO.setMeasureUnit(materialArchivesDO.getUnitMeasurement());
                }
                invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                invoicingStatisticsDO.setUpdateTime(new Date());
                invoicingStatisticsDO.setInboundCount(inWarehouseManagementDetailDTO.getActualWarehouseingQuantity());
                Long actualWarehouseingQuantity = inWarehouseManagementDetailDTO.getActualWarehouseingQuantity();
                BigDecimal referencePrice = materialArchivesDO.getReferencePrice();
                if (actualWarehouseingQuantity != null && referencePrice != null) {
                    BigDecimal actualWarehouseingQuantityBigDecimal = new BigDecimal(actualWarehouseingQuantity);
                    BigDecimal inboundAmount = actualWarehouseingQuantityBigDecimal.multiply(referencePrice);
                    invoicingStatisticsDO.setInboundAmount(inboundAmount);
                }
                invoicingStatisticsDO.setOpeningPrice(materialArchivesDO.getReferencePrice());
                invoicingStatisticsDO.setOpeningQuantity(Long.valueOf(0L));
                BigDecimal number = new BigDecimal("0.0");
                invoicingStatisticsDO.setOpeningAmount(number);
                invoicingStatisticsDO.setEndingQuantity(inWarehouseManagementDetailDTO.getActualWarehouseingQuantity());
                BigDecimal endingAmount = inWarehouseManagementDetailDTO.getTotalPrice();
                invoicingStatisticsDO.setEndingAmount(endingAmount);
                invoicingStatisticsDO.setEndingPrice(new BigDecimal(invoicingStatisticsDO.getEndingQuantity()));
                invoicingStatisticsDO.setIsDeleted(Integer.valueOf(0));
                updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
                this.invoicingStatisticsService.saveBatch(updateInvoicingStatisticsDOList);
            }
        } else {
            for (InvoicingStatisticsDO invoicingStatisticsDO : invoicingStatisticsDOList) {
                for (InWarehouseManagementDetailDO inWarehouseManagementDetailDTO : inWarehouseManagementDetailDTOList) {
                    BigDecimal endingAmount;
                    if (!invoicingStatisticsDO.getMaterialId().equals(inWarehouseManagementDetailDTO.getMaterialId())) continue;
                    invoicingStatisticsDO.setUpdateTime(new Date());
                    invoicingStatisticsDO.setInboundCount(Long.valueOf(inWarehouseManagementDetailDTO.getActualWarehouseingQuantity() + invoicingStatisticsDO.getInboundCount()));
                    invoicingStatisticsDO.setInboundAmount(inWarehouseManagementDetailDTO.getTotalPrice());
                    invoicingStatisticsDO.setOpeningPrice(invoicingStatisticsDO.getEndingPrice());
                    invoicingStatisticsDO.setOpeningQuantity(invoicingStatisticsDO.getEndingQuantity());
                    invoicingStatisticsDO.setOpeningAmount(invoicingStatisticsDO.getEndingAmount());
                    invoicingStatisticsDO.setEndingQuantity(Long.valueOf(invoicingStatisticsDO.getOpeningQuantity() + inWarehouseManagementDetailDTO.getActualWarehouseingQuantity()));
                    if (ObjectUtil.isNotEmpty((Object)invoicingStatisticsDO.getOpeningAmount()) && ObjectUtil.isNotEmpty((Object)inWarehouseManagementDetailDTO.getTotalPrice())) {
                        endingAmount = invoicingStatisticsDO.getOpeningAmount().add(inWarehouseManagementDetailDTO.getTotalPrice());
                        invoicingStatisticsDO.setEndingAmount(endingAmount);
                    }
                    if (invoicingStatisticsDO.getEndingAmount() != null && invoicingStatisticsDO.getEndingQuantity() != null) {
                        endingAmount = invoicingStatisticsDO.getEndingAmount();
                        BigDecimal endingQuantity = new BigDecimal(invoicingStatisticsDO.getEndingQuantity());
                        if (endingQuantity.compareTo(BigDecimal.ZERO) != 0) {
                            BigDecimal endingPrice = endingAmount.divide(endingQuantity, 2, 4);
                            invoicingStatisticsDO.setEndingPrice(endingPrice);
                        }
                    }
                    updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
                }
            }
            this.invoicingStatisticsService.updateBatchById(updateInvoicingStatisticsDOList);
        }
    }

    public void updateOutWarehouseData(List<OutWarehouseManagementDemandDetailDO> outWarehouseManagementDemandDetailDTOList) throws ParseException {
        ArrayList<InvoicingStatisticsDO> updateInvoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        if (ObjectUtil.isEmpty(outWarehouseManagementDemandDetailDTOList)) {
            return;
        }
        List materialIds = outWarehouseManagementDemandDetailDTOList.stream().map(m -> m.getMaterialId()).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(InvoicingStatisticsDO::getOccurrenceTime, (Object)format);
        wrapper.in(InvoicingStatisticsDO::getMaterialId, materialIds);
        List invoicingStatisticsDOList = this.invoicingStatisticsService.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)invoicingStatisticsDOList)) {
            for (OutWarehouseManagementDemandDetailDO inWarehouseManagementDetailDTO : outWarehouseManagementDemandDetailDTOList) {
                InvoicingStatisticsDO invoicingStatisticsDO = new InvoicingStatisticsDO();
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)inWarehouseManagementDetailDTO.getMaterialId());
                if (!ObjectUtil.isNotEmpty((Object)materialArchivesDO)) continue;
                if (materialArchivesDO.getMaterialName() != null) {
                    invoicingStatisticsDO.setItemName(materialArchivesDO.getMaterialName());
                }
                if (materialArchivesDO.getReferencePrice() != null) {
                    invoicingStatisticsDO.setInboundAmount(materialArchivesDO.getReferencePrice());
                }
                if (materialArchivesDO.getMaterialNumber() != null) {
                    invoicingStatisticsDO.setItemNumber(materialArchivesDO.getMaterialNumber());
                }
                if (materialArchivesDO.getId() != null) {
                    invoicingStatisticsDO.setMaterialId(materialArchivesDO.getId());
                }
                if (materialArchivesDO.getMaterialSpecification() != null) {
                    invoicingStatisticsDO.setSpecificationsModels(materialArchivesDO.getMaterialSpecification());
                }
                if (materialArchivesDO.getUnitMeasurement() != null) {
                    invoicingStatisticsDO.setMeasureUnit(materialArchivesDO.getUnitMeasurement());
                }
                invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                invoicingStatisticsDO.setUpdateTime(new Date());
                invoicingStatisticsDO.setOutboundCount(inWarehouseManagementDetailDTO.getDeliveryFromStorageCount());
                Long actualWarehouseingQuantity = inWarehouseManagementDetailDTO.getDeliveryFromStorageCount();
                BigDecimal referencePrice = materialArchivesDO.getReferencePrice();
                if (actualWarehouseingQuantity != null && referencePrice != null) {
                    BigDecimal actualWarehouseingQuantityBigDecimal = new BigDecimal(actualWarehouseingQuantity);
                    BigDecimal inboundAmount = actualWarehouseingQuantityBigDecimal.multiply(referencePrice);
                    invoicingStatisticsDO.setOutboundAmount(inboundAmount);
                }
                invoicingStatisticsDO.setOpeningPrice(materialArchivesDO.getReferencePrice());
                invoicingStatisticsDO.setOpeningQuantity(Long.valueOf(0L));
                BigDecimal number = new BigDecimal("0.0");
                invoicingStatisticsDO.setOpeningAmount(number);
                invoicingStatisticsDO.setEndingQuantity(Long.valueOf(0L));
                invoicingStatisticsDO.setEndingPrice(new BigDecimal(invoicingStatisticsDO.getEndingQuantity()));
                invoicingStatisticsDO.setIsDeleted(Integer.valueOf(0));
                updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
                this.invoicingStatisticsService.saveBatch(updateInvoicingStatisticsDOList);
            }
        } else {
            for (InvoicingStatisticsDO invoicingStatisticsDO : invoicingStatisticsDOList) {
                for (OutWarehouseManagementDemandDetailDO inWarehouseManagementDetailDTO : outWarehouseManagementDemandDetailDTOList) {
                    if (!invoicingStatisticsDO.getMaterialId().equals(inWarehouseManagementDetailDTO.getMaterialId())) continue;
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)inWarehouseManagementDetailDTO.getMaterialId());
                    invoicingStatisticsDO.setOutboundCount(inWarehouseManagementDetailDTO.getDeliveryFromStorageCount());
                    BigDecimal outboundAmount = materialArchivesDO.getReferencePrice().multiply(new BigDecimal(inWarehouseManagementDetailDTO.getDeliveryFromStorageCount()));
                    invoicingStatisticsDO.setOutboundAmount(outboundAmount);
                    invoicingStatisticsDO.setOpeningPrice(invoicingStatisticsDO.getEndingPrice());
                    invoicingStatisticsDO.setOpeningQuantity(invoicingStatisticsDO.getEndingQuantity());
                    invoicingStatisticsDO.setOpeningAmount(invoicingStatisticsDO.getEndingAmount());
                    if (invoicingStatisticsDO.getEndingAmount() != null && invoicingStatisticsDO.getEndingQuantity() != null) {
                        BigDecimal endingAmount = invoicingStatisticsDO.getEndingAmount();
                        BigDecimal endingQuantity = new BigDecimal(invoicingStatisticsDO.getEndingQuantity());
                        if (endingQuantity.compareTo(BigDecimal.ZERO) != 0) {
                            BigDecimal endingPrice = endingAmount.divide(endingQuantity, 2, 4);
                            invoicingStatisticsDO.setEndingPrice(endingPrice);
                        }
                    }
                    updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
                }
            }
            this.invoicingStatisticsService.updateBatchById(updateInvoicingStatisticsDOList);
        }
    }

    public void updateInventoryManagementInvoicingStatistics(List<InventoryManagementListDTO> inventoryManagementList) throws ParseException {
        if (ObjectUtil.isEmpty(inventoryManagementList)) {
            return;
        }
        List materialId = inventoryManagementList.stream().map(m -> m.getMaterialId()).collect(Collectors.toList());
        Long materialIds = null;
        List invoicingStatistics = this.getInvoicingStatisticsList(materialIds);
        if (ObjectUtil.isEmpty((Object)invoicingStatistics)) {
            return;
        }
        ArrayList<InvoicingStatisticsDO> updateInvoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        for (InvoicingStatisticsDO invoicingStatisticsDO : invoicingStatistics) {
            for (InventoryManagementListDTO inventoryManagementListDTO : inventoryManagementList) {
                if (!invoicingStatisticsDO.getMaterialId().equals(inventoryManagementListDTO.getMaterialId())) continue;
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)inventoryManagementListDTO.getMaterialId());
                invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                invoicingStatisticsDO.setUpdateTime(new Date());
                BigDecimal countProfitLossAmount = new BigDecimal(0);
                if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDTO.getInventoryCount())) {
                    invoicingStatisticsDO.setCountProfitLossQuantity(inventoryManagementListDTO.getInventoryCount());
                    countProfitLossAmount = materialArchivesDO.getReferencePrice().multiply(new BigDecimal(inventoryManagementListDTO.getInventoryCount()));
                    invoicingStatisticsDO.setCountProfitLossAmount(countProfitLossAmount);
                }
                invoicingStatisticsDO.setOpeningPrice(invoicingStatisticsDO.getEndingPrice());
                invoicingStatisticsDO.setOpeningQuantity(invoicingStatisticsDO.getEndingQuantity());
                invoicingStatisticsDO.setOpeningAmount(invoicingStatisticsDO.getEndingAmount());
                if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDTO.getInventoryCount())) {
                    invoicingStatisticsDO.setEndingQuantity(Long.valueOf(invoicingStatisticsDO.getOpeningQuantity() - inventoryManagementListDTO.getInventoryCount()));
                }
                BigDecimal endingAmount = invoicingStatisticsDO.getOpeningAmount().subtract(countProfitLossAmount);
                invoicingStatisticsDO.setEndingAmount(endingAmount);
                invoicingStatisticsDO.setEndingPrice(invoicingStatisticsDO.getEndingAmount().divide(new BigDecimal(invoicingStatisticsDO.getEndingQuantity())));
                updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
            }
        }
        this.invoicingStatisticsService.updateBatchById(updateInvoicingStatisticsDOList);
    }

    public void updateProfitLossInvoicingStatistics(List<EquipmentProfitLossMaterialListDTO> equipmentProfitLossMaterialListDTOList) throws ParseException {
        if (ObjectUtil.isEmpty(equipmentProfitLossMaterialListDTOList)) {
            return;
        }
        List materialIds = equipmentProfitLossMaterialListDTOList.stream().map(m -> m.getMaterialId()).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(InvoicingStatisticsDO::getMaterialId, materialIds);
        List invoicingStatisticsDOList = this.invoicingStatisticsService.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)invoicingStatisticsDOList)) {
            return;
        }
        ArrayList<InvoicingStatisticsDO> updateInvoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        for (InvoicingStatisticsDO invoicingStatisticsDO : invoicingStatisticsDOList) {
            for (EquipmentProfitLossMaterialListDTO equipmentProfitLossMaterialListDTO : equipmentProfitLossMaterialListDTOList) {
                BigDecimal endingAmount;
                BigDecimal profitLossAmount;
                MaterialArchivesDO materialArchivesDO;
                if (!invoicingStatisticsDO.getMaterialId().equals(equipmentProfitLossMaterialListDTO.getMaterialId())) continue;
                if ("\u635f".equals(equipmentProfitLossMaterialListDTO.getLossProfitWay())) {
                    materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)equipmentProfitLossMaterialListDTO.getMaterialId());
                    invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                    invoicingStatisticsDO.setUpdateTime(new Date());
                    invoicingStatisticsDO.setProfitLossQuantity(equipmentProfitLossMaterialListDTO.getLossProfitQuantity());
                    profitLossAmount = materialArchivesDO.getReferencePrice().multiply(new BigDecimal(equipmentProfitLossMaterialListDTO.getLossProfitQuantity()));
                    invoicingStatisticsDO.setProfitLossAmount(profitLossAmount);
                    invoicingStatisticsDO.setOpeningPrice(invoicingStatisticsDO.getEndingPrice());
                    invoicingStatisticsDO.setOpeningQuantity(invoicingStatisticsDO.getEndingQuantity());
                    invoicingStatisticsDO.setOpeningAmount(invoicingStatisticsDO.getEndingAmount());
                    invoicingStatisticsDO.setEndingQuantity(Long.valueOf(invoicingStatisticsDO.getOpeningQuantity() - equipmentProfitLossMaterialListDTO.getLossProfitQuantity()));
                    endingAmount = invoicingStatisticsDO.getOpeningAmount().subtract(profitLossAmount);
                    invoicingStatisticsDO.setEndingAmount(endingAmount);
                    invoicingStatisticsDO.setEndingPrice(invoicingStatisticsDO.getEndingAmount().divide(new BigDecimal(invoicingStatisticsDO.getEndingQuantity())));
                    updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
                    continue;
                }
                materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)equipmentProfitLossMaterialListDTO.getMaterialId());
                invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                invoicingStatisticsDO.setUpdateTime(new Date());
                invoicingStatisticsDO.setProfitLossQuantity(equipmentProfitLossMaterialListDTO.getLossProfitQuantity());
                profitLossAmount = materialArchivesDO.getReferencePrice().multiply(new BigDecimal(equipmentProfitLossMaterialListDTO.getLossProfitQuantity()));
                invoicingStatisticsDO.setProfitLossAmount(profitLossAmount);
                invoicingStatisticsDO.setOpeningPrice(invoicingStatisticsDO.getEndingPrice());
                invoicingStatisticsDO.setOpeningQuantity(invoicingStatisticsDO.getEndingQuantity());
                invoicingStatisticsDO.setOpeningAmount(invoicingStatisticsDO.getEndingAmount());
                invoicingStatisticsDO.setEndingQuantity(Long.valueOf(invoicingStatisticsDO.getOpeningQuantity() + equipmentProfitLossMaterialListDTO.getLossProfitQuantity()));
                endingAmount = invoicingStatisticsDO.getOpeningAmount().add(profitLossAmount);
                invoicingStatisticsDO.setEndingAmount(endingAmount);
                invoicingStatisticsDO.setEndingPrice(invoicingStatisticsDO.getEndingAmount().divide(new BigDecimal(invoicingStatisticsDO.getEndingQuantity())));
                updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
            }
        }
        this.invoicingStatisticsService.updateBatchById(updateInvoicingStatisticsDOList);
    }

    public void updateAdoptionInvoicingStatistics(List<AdoptionReturnItemListDO> adoptionReturnItemListDTOList) throws ParseException {
        ArrayList<InvoicingStatisticsDO> updateInvoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        if (ObjectUtil.isEmpty(adoptionReturnItemListDTOList)) {
            return;
        }
        List materialId = adoptionReturnItemListDTOList.stream().map(m -> m.getMaterialId()).collect(Collectors.toList());
        Long materialIds = null;
        List invoicingStatistics = this.getInvoicingStatisticsList(materialIds);
        if (ObjectUtil.isEmpty((Object)invoicingStatistics)) {
            for (AdoptionReturnItemListDO adoptionReturnItemListDTO : adoptionReturnItemListDTOList) {
                InvoicingStatisticsDO invoicingStatisticsDO = this.createInvoicingStatisticsDO(adoptionReturnItemListDTO.getMaterialId());
                invoicingStatisticsDO.setQuantityReceived(adoptionReturnItemListDTO.getAdoptionCount());
                BigDecimal bigDecimal = this.setOutboundAmount(adoptionReturnItemListDTO.getAdoptionCount(), invoicingStatisticsDO.getOpeningPrice());
                invoicingStatisticsDO.setAmountReceived(bigDecimal);
                this.invoicingStatisticsService.save((Object)invoicingStatisticsDO);
            }
        } else {
            for (InvoicingStatisticsDO invoicingStatisticsDO : invoicingStatistics) {
                for (AdoptionReturnItemListDO adoptionReturnItemListDTO : adoptionReturnItemListDTOList) {
                    if (!invoicingStatisticsDO.getMaterialId().equals(adoptionReturnItemListDTO.getMaterialId())) continue;
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)adoptionReturnItemListDTO.getMaterialId());
                    invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                    invoicingStatisticsDO.setUpdateTime(new Date());
                    invoicingStatisticsDO.setQuantityReceived(adoptionReturnItemListDTO.getAdoptionCount());
                    BigDecimal amountReceived = materialArchivesDO.getReferencePrice().multiply(new BigDecimal(adoptionReturnItemListDTO.getAdoptionCount()));
                    invoicingStatisticsDO.setAmountReceived(amountReceived);
                    updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
                }
            }
            this.invoicingStatisticsService.saveBatch(updateInvoicingStatisticsDOList);
        }
    }

    public void updateReturnInvoicingStatistics(AdoptionReturnItemListDO adoptionReturnItemListDTO) throws ParseException {
        if (ObjectUtil.isEmpty((Object)adoptionReturnItemListDTO)) {
            return;
        }
        ArrayList<InvoicingStatisticsDO> updateInvoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        ArrayList<Long> materialId = new ArrayList<Long>();
        materialId.add(adoptionReturnItemListDTO.getMaterialId());
        Long materialIds = null;
        List invoicingStatistics = this.getInvoicingStatisticsList(materialIds);
        if (ObjectUtil.isEmpty((Object)invoicingStatistics)) {
            InvoicingStatisticsDO invoicingStatisticsDO = this.createInvoicingStatisticsDO(adoptionReturnItemListDTO.getMaterialId());
            invoicingStatisticsDO.setReturnQuantity(adoptionReturnItemListDTO.getAdoptionCount());
            BigDecimal bigDecimal = this.setOutboundAmount(adoptionReturnItemListDTO.getAdoptionCount(), invoicingStatisticsDO.getOpeningPrice());
            invoicingStatisticsDO.setReturnAmount(bigDecimal);
            this.invoicingStatisticsService.save((Object)invoicingStatisticsDO);
        } else {
            for (InvoicingStatisticsDO invoicingStatisticsDO : invoicingStatistics) {
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)adoptionReturnItemListDTO.getMaterialId());
                invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                invoicingStatisticsDO.setUpdateTime(new Date());
                invoicingStatisticsDO.setReturnQuantity(Long.valueOf(adoptionReturnItemListDTO.getAdoptionCount() + invoicingStatisticsDO.getReturnQuantity()));
                BigDecimal returnAmount = materialArchivesDO.getReferencePrice().multiply(new BigDecimal(adoptionReturnItemListDTO.getAdoptionCount()));
                invoicingStatisticsDO.setReturnAmount(returnAmount.add(invoicingStatisticsDO.getReturnAmount()));
                updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
            }
            this.invoicingStatisticsService.updateBatchById(updateInvoicingStatisticsDOList);
        }
    }

    public void updateEquipmentReturn(List<InWarehouseManagementDetailDTO> inWarehouseManagementDetailDTOList) throws ParseException {
        if (ObjectUtil.isEmpty(inWarehouseManagementDetailDTOList)) {
            return;
        }
        List materialId = inWarehouseManagementDetailDTOList.stream().map(m -> m.getMaterialId()).collect(Collectors.toList());
        Long materialIds = null;
        List invoicingStatistics = this.getInvoicingStatisticsList(materialIds);
        if (ObjectUtil.isEmpty((Object)invoicingStatistics)) {
            return;
        }
        ArrayList<InvoicingStatisticsDO> updateInvoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        for (InvoicingStatisticsDO invoicingStatisticsDO : invoicingStatistics) {
            for (InWarehouseManagementDetailDTO inWarehouseManagementDetailDTO : inWarehouseManagementDetailDTOList) {
                if (!invoicingStatisticsDO.getMaterialId().equals(inWarehouseManagementDetailDTO.getMaterialId())) continue;
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)inWarehouseManagementDetailDTO.getMaterialId());
                invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                invoicingStatisticsDO.setUpdateTime(new Date());
                invoicingStatisticsDO.setRecoveredQuantity(Long.valueOf(inWarehouseManagementDetailDTO.getRecoveryNumber().longValue()));
                BigDecimal recoveredAmount = materialArchivesDO.getReferencePrice().multiply(new BigDecimal(inWarehouseManagementDetailDTO.getRecoveryNumber().longValue()));
                invoicingStatisticsDO.setRecoveredAmount(recoveredAmount);
                updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
            }
        }
        this.invoicingStatisticsService.updateBatchById(updateInvoicingStatisticsDOList);
    }

    public List<InvoicingStatisticsDO> getInvoicingStatisticsList(Long materialIds) {
        if (ObjectUtil.isEmpty((Object)materialIds)) {
            return new ArrayList<InvoicingStatisticsDO>();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(InvoicingStatisticsDO::getOccurrenceTime, (Object)format);
        wrapper.eq(InvoicingStatisticsDO::getMaterialId, (Object)materialIds);
        return this.invoicingStatisticsService.list((Wrapper)wrapper);
    }

    public InvoicingStatisticsDO getInvoicingStatistics(Long materialIds) {
        if (ObjectUtil.isEmpty((Object)materialIds)) {
            return new InvoicingStatisticsDO();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(InvoicingStatisticsDO::getOccurrenceTime, (Object)format);
        wrapper.eq(InvoicingStatisticsDO::getMaterialId, (Object)materialIds);
        return (InvoicingStatisticsDO)this.invoicingStatisticsService.getOne((Wrapper)wrapper);
    }

    public InvoicingStatisticsDO getInvoicingStatisticsCalendar(Long materialIds) {
        if (ObjectUtil.isEmpty((Object)materialIds)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -1);
        Date format = calendar.getTime();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(InvoicingStatisticsDO::getOccurrenceTime, (Object)format);
        wrapper.eq(InvoicingStatisticsDO::getMaterialId, (Object)materialIds);
        return (InvoicingStatisticsDO)this.invoicingStatisticsService.getOne((Wrapper)wrapper);
    }

    public InvoicingStatisticsDO createInvoicingStatisticsDO(Long materialId) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        InvoicingStatisticsDO invoicingStatisticsDO = new InvoicingStatisticsDO();
        MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)materialId);
        if (ObjectUtil.isNotEmpty((Object)materialArchivesDO)) {
            if (materialArchivesDO.getMaterialName() != null) {
                invoicingStatisticsDO.setItemName(materialArchivesDO.getMaterialName());
            }
            if (materialArchivesDO.getReferencePrice() != null) {
                invoicingStatisticsDO.setInboundAmount(materialArchivesDO.getReferencePrice());
            }
            if (materialArchivesDO.getMaterialNumber() != null) {
                invoicingStatisticsDO.setItemNumber(materialArchivesDO.getMaterialNumber());
            }
            if (materialArchivesDO.getId() != null) {
                invoicingStatisticsDO.setMaterialId(materialArchivesDO.getId());
            }
            if (materialArchivesDO.getMaterialSpecification() != null) {
                invoicingStatisticsDO.setSpecificationsModels(materialArchivesDO.getMaterialSpecification());
            }
            if (materialArchivesDO.getUnitMeasurement() != null) {
                invoicingStatisticsDO.setMeasureUnit(materialArchivesDO.getUnitMeasurement());
            }
            if (materialArchivesDO.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                invoicingStatisticsDO.setOpeningPrice(materialArchivesDO.getPrice());
            } else {
                invoicingStatisticsDO.setOpeningPrice(materialArchivesDO.getReferencePrice());
            }
        }
        invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
        invoicingStatisticsDO.setCreateTime(new Date());
        return invoicingStatisticsDO;
    }

    public List<InvoicingStatisticsDO> createInvoicingStatisticsList(List<Long> materialId) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        Date occurrenceTime = simpleDateFormat.parse(format);
        List materialArchivesDOS = this.materialArchivesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(MaterialArchivesDO::getId, materialId));
        ArrayList<InvoicingStatisticsDO> invoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        if (ObjectUtil.isNotEmpty((Object)materialArchivesDOS) && materialArchivesDOS.size() > 0) {
            materialArchivesDOS.forEach(materialArchivesDO -> {
                InvoicingStatisticsDO invoicingStatisticsDO = new InvoicingStatisticsDO();
                BeanUtils.copyProperties((Object)materialArchivesDO, (Object)invoicingStatisticsDO);
                if (materialArchivesDO.getMaterialName() != null) {
                    invoicingStatisticsDO.setItemName(materialArchivesDO.getMaterialName());
                }
                if (materialArchivesDO.getReferencePrice() != null) {
                    invoicingStatisticsDO.setInboundAmount(materialArchivesDO.getReferencePrice());
                }
                if (materialArchivesDO.getMaterialNumber() != null) {
                    invoicingStatisticsDO.setItemNumber(materialArchivesDO.getMaterialNumber());
                }
                if (materialArchivesDO.getId() != null) {
                    invoicingStatisticsDO.setMaterialId(materialArchivesDO.getId());
                }
                if (materialArchivesDO.getMaterialSpecification() != null) {
                    invoicingStatisticsDO.setSpecificationsModels(materialArchivesDO.getMaterialSpecification());
                }
                if (materialArchivesDO.getUnitMeasurement() != null) {
                    invoicingStatisticsDO.setMeasureUnit(materialArchivesDO.getUnitMeasurement());
                }
                if (materialArchivesDO.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                    invoicingStatisticsDO.setOpeningPrice(materialArchivesDO.getPrice());
                } else {
                    invoicingStatisticsDO.setOpeningPrice(materialArchivesDO.getReferencePrice());
                }
                try {
                    invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                invoicingStatisticsDO.setOccurrenceTime(occurrenceTime);
                invoicingStatisticsDO.setIsDeleted(Integer.valueOf(0));
                invoicingStatisticsDO.setCreateTime(new Date());
                invoicingStatisticsDOList.add(invoicingStatisticsDO);
            });
        }
        return invoicingStatisticsDOList;
    }

    public BigDecimal setOutboundAmount(Long actualWarehouseingQuantity, BigDecimal referencePrice) {
        if (actualWarehouseingQuantity != null && referencePrice != null) {
            BigDecimal actualWarehouseingQuantityBigDecimal = new BigDecimal(actualWarehouseingQuantity);
            BigDecimal inboundAmount = actualWarehouseingQuantityBigDecimal.multiply(referencePrice);
            return inboundAmount;
        }
        return null;
    }

    public void updateOutWarehouseDataHandle(List<HandlelnvoicingDto> handlelnvoicingDtoList) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currentDateStr = simpleDateFormat.format(new Date());
        Date occurrenceTime = simpleDateFormat.parse(currentDateStr);
        if (ObjectUtil.isEmpty(handlelnvoicingDtoList)) {
            return;
        }
        for (HandlelnvoicingDto handlelnvoicingDto : handlelnvoicingDtoList) {
            Long materialId = handlelnvoicingDto.getMaterialId();
            InvoicingStatisticsDO invoicingStatistics = this.getInvoicingStatistics(materialId);
            InvoicingStatisticsDO invoicingStatisticsDO = new InvoicingStatisticsDO();
            if (ObjectUtil.isEmpty((Object)invoicingStatistics) || StringUtils.isEmpty((CharSequence)invoicingStatistics.getItemName())) {
                invoicingStatisticsDO = this.createInvoicingStatisticsDO(materialId);
            } else {
                BeanUtils.copyProperties((Object)invoicingStatistics, (Object)invoicingStatisticsDO);
            }
            if (invoicingStatisticsDO == null) continue;
            invoicingStatisticsDO.setOccurrenceTime(occurrenceTime);
            invoicingStatisticsDO.setUpdateTime(new Date());
            invoicingStatisticsDO.setIsDeleted(Integer.valueOf(0));
            StockListDO stockListDO = (StockListDO)this.stockListMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)materialId));
            if (!ObjectUtil.isNotEmpty((Object)stockListDO) || !StringUtils.isNotEmpty((CharSequence)stockListDO.getMaterialName())) continue;
            MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)materialId);
            if (materialArchivesDO != null) {
                BigDecimal price = materialArchivesDO.getPrice();
                BigDecimal referencePrice = materialArchivesDO.getReferencePrice();
                if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
                    invoicingStatisticsDO.setOpeningPrice(price);
                } else {
                    invoicingStatisticsDO.setOpeningPrice(referencePrice);
                }
            }
            invoicingStatisticsDO.setEndingQuantity(stockListDO.getCurrentStock());
            invoicingStatisticsDO.setEndingPrice(invoicingStatisticsDO.getOpeningPrice());
            BigDecimal amounts = this.setOutboundAmount(stockListDO.getCurrentStock(), invoicingStatisticsDO.getOpeningPrice());
            invoicingStatisticsDO.setEndingAmount(amounts);
            BigDecimal amount = this.setOutboundAmount(handlelnvoicingDto.getCount(), invoicingStatisticsDO.getOpeningPrice());
            switch (handlelnvoicingDto.getType()) {
                case 1: {
                    invoicingStatisticsDO.setInboundCount(Long.valueOf(invoicingStatisticsDO.getInboundCount() == null ? handlelnvoicingDto.getCount() : handlelnvoicingDto.getCount() + invoicingStatisticsDO.getInboundCount()));
                    invoicingStatisticsDO.setInboundAmount(invoicingStatisticsDO.getInboundAmount() == null ? amount : amount.add(invoicingStatisticsDO.getInboundAmount()));
                    break;
                }
                case 2: {
                    invoicingStatisticsDO.setOutboundCount(Long.valueOf(invoicingStatisticsDO.getOutboundCount() == null ? handlelnvoicingDto.getCount() : handlelnvoicingDto.getCount() + invoicingStatisticsDO.getOutboundCount()));
                    invoicingStatisticsDO.setOutboundAmount(invoicingStatisticsDO.getOutboundAmount() == null ? amount : amount.add(invoicingStatisticsDO.getOutboundAmount()));
                    break;
                }
                case 3: {
                    invoicingStatisticsDO.setQuantityReceived(Long.valueOf(invoicingStatisticsDO.getQuantityReceived() == null ? handlelnvoicingDto.getCount() : handlelnvoicingDto.getCount() + invoicingStatisticsDO.getQuantityReceived()));
                    invoicingStatisticsDO.setAmountReceived(invoicingStatisticsDO.getAmountReceived() == null ? amount : amount.add(invoicingStatisticsDO.getAmountReceived()));
                    break;
                }
                case 4: {
                    invoicingStatisticsDO.setReturnQuantity(Long.valueOf(invoicingStatisticsDO.getReturnQuantity() == null ? handlelnvoicingDto.getCount() : handlelnvoicingDto.getCount() + invoicingStatisticsDO.getReturnQuantity()));
                    invoicingStatisticsDO.setReturnAmount(invoicingStatisticsDO.getReturnAmount() == null ? amount : amount.add(invoicingStatisticsDO.getReturnAmount()));
                    break;
                }
                case 5: {
                    invoicingStatisticsDO.setProfitLossQuantity(Long.valueOf(invoicingStatisticsDO.getProfitLossQuantity() == null ? handlelnvoicingDto.getCount() : handlelnvoicingDto.getCount() + invoicingStatisticsDO.getProfitLossQuantity()));
                    invoicingStatisticsDO.setProfitLossAmount(invoicingStatisticsDO.getProfitLossAmount() == null ? amount : amount.add(invoicingStatisticsDO.getProfitLossAmount()));
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    invoicingStatisticsDO.setCountProfitLossQuantity(Long.valueOf(invoicingStatisticsDO.getCountProfitLossQuantity() == null ? handlelnvoicingDto.getCount() : handlelnvoicingDto.getCount() + invoicingStatisticsDO.getCountProfitLossQuantity()));
                    invoicingStatisticsDO.setCountProfitLossAmount(invoicingStatisticsDO.getCountProfitLossAmount() == null ? amount : amount.add(invoicingStatisticsDO.getCountProfitLossAmount()));
                }
            }
            if (null != invoicingStatisticsDO.getId()) {
                this.invoicingStatisticsService.updateById((Object)invoicingStatisticsDO);
                continue;
            }
            this.invoicingStatisticsService.save((Object)invoicingStatisticsDO);
        }
    }
}

