/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.handle.supply;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.dto.supply.OutWarehouseManagementDemandDetailDTO;
import com.ruoyi.entity.supply.InvoicingStatisticsDO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.mapper.supply.MaterialArchivesMapper;
import com.ruoyi.mapper.supply.StockListMapper;
import com.ruoyi.service.supply.InvoicingStatisticsService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class HandleMaterialArchive {
    @Resource
    private StockListMapper stockListMapper;
    @Resource
    private InvoicingStatisticsService invoicingStatisticsService;
    @Resource
    private MaterialArchivesMapper materialArchivesMapper;

    public void updateOutWarehouseData(List<OutWarehouseManagementDemandDetailDTO> outWarehouseManagementDemandDetailDTOList) throws ParseException {
        if (ObjectUtil.isEmpty(outWarehouseManagementDemandDetailDTOList)) {
            return;
        }
        List materialIds = outWarehouseManagementDemandDetailDTOList.stream().map(m -> m.getId()).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(InvoicingStatisticsDO::getMaterialId, materialIds);
        List invoicingStatisticsDOList = this.invoicingStatisticsService.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)invoicingStatisticsDOList)) {
            return;
        }
        ArrayList<InvoicingStatisticsDO> updateInvoicingStatisticsDOList = new ArrayList<InvoicingStatisticsDO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        for (InvoicingStatisticsDO invoicingStatisticsDO : invoicingStatisticsDOList) {
            for (OutWarehouseManagementDemandDetailDTO outWarehouseManagementDemandDetailDTO : outWarehouseManagementDemandDetailDTOList) {
                if (!invoicingStatisticsDO.getMaterialId().equals(outWarehouseManagementDemandDetailDTO.getMaterialId())) continue;
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)outWarehouseManagementDemandDetailDTO.getMaterialId());
                invoicingStatisticsDO.setOccurrenceTime(simpleDateFormat.parse(format));
                invoicingStatisticsDO.setUpdateTime(new Date());
                invoicingStatisticsDO.setOutboundCount(outWarehouseManagementDemandDetailDTO.getDeliveryFromStorageCount());
                BigDecimal outboundAmount = materialArchivesDO.getReferencePrice().multiply(new BigDecimal(outWarehouseManagementDemandDetailDTO.getDeliveryFromStorageCount()));
                invoicingStatisticsDO.setOutboundAmount(outboundAmount);
                invoicingStatisticsDO.setOpeningPrice(invoicingStatisticsDO.getEndingPrice());
                invoicingStatisticsDO.setOpeningQuantity(invoicingStatisticsDO.getEndingQuantity());
                invoicingStatisticsDO.setOpeningAmount(invoicingStatisticsDO.getEndingAmount());
                invoicingStatisticsDO.setEndingQuantity(Long.valueOf(invoicingStatisticsDO.getOpeningQuantity() - outWarehouseManagementDemandDetailDTO.getDeliveryFromStorageCount()));
                BigDecimal endingAmount = invoicingStatisticsDO.getOpeningAmount().subtract(outboundAmount);
                invoicingStatisticsDO.setEndingAmount(endingAmount);
                invoicingStatisticsDO.setEndingPrice(invoicingStatisticsDO.getEndingAmount().divide(new BigDecimal(invoicingStatisticsDO.getEndingQuantity())));
                updateInvoicingStatisticsDOList.add(invoicingStatisticsDO);
            }
        }
        this.invoicingStatisticsService.updateBatchById(updateInvoicingStatisticsDOList);
    }
}

