/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.supply.EquipmentAllocationDTO;
import com.ruoyi.dto.supply.EquipmentAllocationDetailDTO;
import com.ruoyi.entity.supply.EquipmentAllocationDO;
import com.ruoyi.entity.supply.EquipmentAllocationDetailDO;
import com.ruoyi.entity.supply.InWarehouseManagementDO;
import com.ruoyi.enums.supply.EquipmentAllocationStatusEnum;
import com.ruoyi.feign.SystemClient;
import com.ruoyi.mapper.supply.EquipmentAllocationMapper;
import com.ruoyi.query.supply.EquipmentAllocationQuery;
import com.ruoyi.service.supply.EquipmentAllocationDetailService;
import com.ruoyi.service.supply.EquipmentAllocationService;
import com.ruoyi.service.supply.InWarehouseManagementService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.service.supply.impl.EquipmentAllocationServiceImpl;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.supply.EquipmentAllocationExportVO;
import com.ruoyi.vo.supply.EquipmentAllocationVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EquipmentAllocationServiceImpl
extends ServiceImpl<EquipmentAllocationMapper, EquipmentAllocationDO>
implements EquipmentAllocationService {
    private static final Logger log = LoggerFactory.getLogger(EquipmentAllocationServiceImpl.class);
    @Resource
    private EquipmentAllocationDetailService equipmentAllocationDetailService;
    @Resource
    private EquipmentAllocationMapper equipmentAllocationMapper;
    @Resource
    private InWarehouseManagementService inWarehouseManagementService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private StockListService stockListService;
    @Resource
    private SystemClient systemClient;

    public PageResultVo<EquipmentAllocationVO> pageQueryEquipmentAllocation(EquipmentAllocationQuery equipmentAllocationQuery) {
        LambdaQueryWrapper wrapper = this.getWrapper(equipmentAllocationQuery);
        Page page = (Page)this.page((IPage)new Page((long)equipmentAllocationQuery.getPageNum(), (long)equipmentAllocationQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo equipmentAllocationVOPageResultVo = new PageResultVo();
        ArrayList<EquipmentAllocationVO> equipmentAllocationVOList = new ArrayList<EquipmentAllocationVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (EquipmentAllocationDO equipmentAllocationDO : resultVo.getData()) {
                EquipmentAllocationVO equipmentAllocationVO = new EquipmentAllocationVO();
                BeanUtils.copyProperties((Object)equipmentAllocationDO, (Object)equipmentAllocationVO);
                equipmentAllocationVOList.add(equipmentAllocationVO);
            }
        }
        equipmentAllocationVOPageResultVo.setData(equipmentAllocationVOList);
        equipmentAllocationVOPageResultVo.setPageSize(resultVo.getPageSize());
        equipmentAllocationVOPageResultVo.setPageNum(resultVo.getPageNum());
        equipmentAllocationVOPageResultVo.setTotal(resultVo.getTotal());
        equipmentAllocationVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return equipmentAllocationVOPageResultVo;
    }

    public void addEquipmentAllocation(EquipmentAllocationDTO equipmentAllocationDTO) throws Exception {
        EquipmentAllocationDO equipmentAllocationDO = new EquipmentAllocationDO();
        BeanUtils.copyProperties((Object)equipmentAllocationDTO, (Object)equipmentAllocationDO);
        equipmentAllocationDO.setCreateTime(new Date());
        equipmentAllocationDO.setUpdateTime(new Date());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date date = new Date();
        String parseDate = format.format(date);
        equipmentAllocationDO.setTransferDate(format.parse(parseDate));
        equipmentAllocationDO.setAllocationStatus(EquipmentAllocationStatusEnum.inReview.getMsg());
        String allocationNumber = this.getGenerateAllocationNumber();
        equipmentAllocationDO.setAllocationNumber(allocationNumber);
        equipmentAllocationDO.setIsDeleted(Integer.valueOf(0));
        equipmentAllocationDO.setInProjectLeader(equipmentAllocationDTO.getTransfereeApplicants());
        Set roles = UserUtils.getLoginUser().getRoles();
        if (ObjectUtil.isNotEmpty((Object)roles)) {
            if (roles.contains("gczg")) {
                equipmentAllocationDO.setSubjectName(ThemeUtils.getThemeName((String)"\u8bbe\u5907\u8c03\u62e8\u5ba1\u6279"));
            } else if (roles.contains("ckzg")) {
                equipmentAllocationDO.setSubjectName(ThemeUtils.getThemeName((String)"\u4ed3\u5e93\u7ba1\u7406\u5458\u8bbe\u5907\u8c03\u62e8"));
            } else {
                equipmentAllocationDO.setSubjectName(ThemeUtils.getThemeName((String)"\u4ed3\u5e93\u7ba1\u7406\u5458\u8bbe\u5907\u8c03\u62e8"));
            }
        } else {
            equipmentAllocationDO.setSubjectName(ThemeUtils.getThemeName((String)"\u4ed3\u5e93\u7ba1\u7406\u5458\u8bbe\u5907\u8c03\u62e8"));
        }
        this.save((Object)equipmentAllocationDO);
        List equipmentAllocationDetailDTOList = equipmentAllocationDTO.getEquipmentAllocationDetailDTOList();
        this.saveEquipmentAllocationDetail(equipmentAllocationDetailDTOList, allocationNumber);
        if (ObjectUtil.isNotEmpty((Object)roles)) {
            if (roles.contains("gczg")) {
                ProcessDTO processDTO = new ProcessDTO();
                processDTO.setProcessInstanceName(equipmentAllocationDO.getSubjectName());
                processDTO.setProjectName(equipmentAllocationDO.getOutProject());
                processDTO.setBusinessKey(equipmentAllocationDO.getId().toString());
                String processId = this.workFlowService.startProcess(ProcessEnum.construction, processDTO, new Object[]{equipmentAllocationDO.getId().toString()});
                System.out.println(processId);
                if (ObjectUtil.isNotEmpty((Object)processId)) {
                    equipmentAllocationDO.setProcessInstId(processId);
                    this.updateById((Object)equipmentAllocationDO);
                }
            } else if (roles.contains("ckzg")) {
                ProcessDTO processDTO = new ProcessDTO();
                processDTO.setProcessInstanceName(equipmentAllocationDO.getSubjectName());
                processDTO.setProjectName(equipmentAllocationDO.getOutProject());
                processDTO.setBusinessKey(equipmentAllocationDO.getId().toString());
                String processId = this.workFlowService.startProcess(ProcessEnum.keeper_construction, processDTO, new Object[]{equipmentAllocationDO.getId().toString()});
                System.out.println(processId);
                if (ObjectUtil.isNotEmpty((Object)processId)) {
                    equipmentAllocationDO.setProcessInstId(processId);
                    this.updateById((Object)equipmentAllocationDO);
                }
            }
        } else {
            ProcessDTO processDTO = new ProcessDTO();
            processDTO.setProcessInstanceName(equipmentAllocationDO.getSubjectName());
            processDTO.setProjectName(equipmentAllocationDO.getOutProject());
            processDTO.setBusinessKey(equipmentAllocationDO.getId().toString());
            String processId = this.workFlowService.startProcess(ProcessEnum.keeper_construction, processDTO, new Object[]{equipmentAllocationDO.getId().toString()});
            System.out.println(processId);
            if (ObjectUtil.isNotEmpty((Object)processId)) {
                equipmentAllocationDO.setProcessInstId(processId);
                this.updateById((Object)equipmentAllocationDO);
            }
        }
    }

    public void updateEquipmentAllocationStatus(String status, Long id) {
        EquipmentAllocationDO equipmentAllocationDO = (EquipmentAllocationDO)this.getById((Serializable)id);
        if (status.equals(EquipmentAllocationStatusEnum.canceled.getCode())) {
            equipmentAllocationDO.setAllocationStatus(EquipmentAllocationStatusEnum.canceled.getMsg());
        }
        if (status.equals(EquipmentAllocationStatusEnum.completed.getCode())) {
            equipmentAllocationDO.setAllocationStatus(EquipmentAllocationStatusEnum.completed.getMsg());
        }
        if (status.equals(EquipmentAllocationStatusEnum.rejected.getCode())) {
            equipmentAllocationDO.setAllocationStatus(EquipmentAllocationStatusEnum.rejected.getMsg());
        }
        if (status.equals(EquipmentAllocationStatusEnum.transfer.getCode())) {
            equipmentAllocationDO.setAllocationStatus(EquipmentAllocationStatusEnum.transfer.getMsg());
        }
        if (status.equals(EquipmentAllocationStatusEnum.inReview.getCode())) {
            equipmentAllocationDO.setAllocationStatus(EquipmentAllocationStatusEnum.inReview.getMsg());
        }
        equipmentAllocationDO.setUpdateTime(new Date());
        this.updateById((Object)equipmentAllocationDO);
    }

    public EquipmentAllocationVO selectEquipmentAllocationDetail(Long id) {
        EquipmentAllocationVO equipmentAllocationVO = new EquipmentAllocationVO();
        EquipmentAllocationDO equipmentAllocationDO = (EquipmentAllocationDO)this.getById((Serializable)id);
        BeanUtils.copyProperties((Object)equipmentAllocationDO, (Object)equipmentAllocationVO);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EquipmentAllocationDetailDO::getMainId, (Object)id);
        List equipmentAllocationDetailDOList = this.equipmentAllocationDetailService.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)equipmentAllocationDetailDOList)) {
            List equipmentAllocationDetailDTOList = equipmentAllocationDetailDOList.stream().map(m -> {
                EquipmentAllocationDetailDTO equipmentAllocationDetailDTO = new EquipmentAllocationDetailDTO();
                BeanUtils.copyProperties((Object)m, (Object)equipmentAllocationDetailDTO);
                return equipmentAllocationDetailDTO;
            }).collect(Collectors.toList());
            equipmentAllocationVO.setEquipmentAllocationDetailDTOList(equipmentAllocationDetailDTOList);
            return equipmentAllocationVO;
        }
        return new EquipmentAllocationVO();
    }

    public void exportEquipmentAllocation(EquipmentAllocationQuery equipmentAllocationQuery, HttpServletResponse response) throws IOException {
        LambdaQueryWrapper wrapper = this.getWrapper(equipmentAllocationQuery);
        List equipmentAllocationDOList = this.list((Wrapper)wrapper);
        List<Object> equipmentAllocationExportVOList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)equipmentAllocationDOList)) {
            equipmentAllocationExportVOList = equipmentAllocationDOList.stream().map(equipmentAllocationDO -> {
                EquipmentAllocationExportVO equipmentAllocationExportVO = new EquipmentAllocationExportVO();
                BeanUtils.copyProperties((Object)equipmentAllocationDO, (Object)equipmentAllocationExportVO);
                return equipmentAllocationExportVO;
            }).collect(Collectors.toList());
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u8bbe\u5907\u8c03\u62e8", "\u8bbe\u5907\u8c03\u62e8", ExcelType.XSSF), EquipmentAllocationExportVO.class, equipmentAllocationExportVOList);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u8bbe\u5907\u8c03\u62e8-" + dateFormat.format(date)));
    }

    public void executiveEditor(EquipmentAllocationDTO equipmentAllocationDTO) {
        Long id = equipmentAllocationDTO.getId();
        EquipmentAllocationDO equipmentAllocationDO = (EquipmentAllocationDO)this.getById((Serializable)id);
        BeanUtils.copyProperties((Object)equipmentAllocationDTO, (Object)equipmentAllocationDO);
        equipmentAllocationDO.setUpdateTime(new Date());
        equipmentAllocationDO.setAllocationStatus(EquipmentAllocationStatusEnum.inReview.getMsg());
        this.updateById((Object)equipmentAllocationDO);
        List equipmentAllocationDetailDTOList = equipmentAllocationDTO.getEquipmentAllocationDetailDTOList();
        List equipmentAllocationDetailDOList = equipmentAllocationDetailDTOList.stream().map(m -> {
            EquipmentAllocationDetailDO equipmentAllocationDetailDO = new EquipmentAllocationDetailDO();
            BeanUtils.copyProperties((Object)m, (Object)equipmentAllocationDetailDO);
            equipmentAllocationDetailDO.setUpdateTime(new Date());
            return equipmentAllocationDetailDO;
        }).collect(Collectors.toList());
        this.equipmentAllocationDetailService.updateBatchById(equipmentAllocationDetailDOList);
    }

    public void cancelAllocation(EquipmentAllocationDO equipmentAllocationDO) {
        equipmentAllocationDO.setAllocationStatus("\u5df2\u53d6\u6d88");
        equipmentAllocationDO.setUpdateTime(new Date());
        this.updateById((Object)equipmentAllocationDO);
    }

    public void executionCompleted(EquipmentAllocationDTO equipmentAllocationDTO) {
        EquipmentAllocationDO equipmentAllocationDO = (EquipmentAllocationDO)this.getById((Serializable)equipmentAllocationDTO.getId());
        equipmentAllocationDO.setAllocationStatus("\u5df2\u5b8c\u6210");
        equipmentAllocationDO.setUpdateTime(new Date());
        this.updateById((Object)equipmentAllocationDO);
    }

    public List<String> getInProjectList() {
        List equipmentAllocationDOList = this.list();
        List<String> inProjectList = equipmentAllocationDOList.stream().map(m -> m.getInProject()).collect(Collectors.toList());
        return inProjectList;
    }

    public List<String> getOutProjectList() {
        List equipmentAllocationDOList = this.list();
        List<String> outProjectList = equipmentAllocationDOList.stream().map(m -> m.getOutProject()).collect(Collectors.toList());
        return outProjectList;
    }

    public void workFromCallBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        EquipmentAllocationDO byId = (EquipmentAllocationDO)this.getById((Serializable)((Object)callBackVO.getBody().getBusinessKey()));
        switch (1.$SwitchMap$com$ruoyi$vo$supply$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Map taskVariables = callBackVO.getBody().getTaskVariables();
                if (taskVariables.size() <= 0) break;
                Integer approveStatus = (Integer)taskVariables.get("approveStatus");
                if (2 == approveStatus) {
                    byId.setAllocationStatus("\u5ba1\u6838\u4e2d");
                    this.updateById((Object)byId);
                    break;
                }
                if (4 != approveStatus) break;
                byId.setAllocationStatus("\u5df2\u53d6\u6d88");
                this.updateById((Object)byId);
                break;
            }
            case 3: {
                LoginUser loginUser = UserUtils.getLoginUser();
                System.out.println(loginUser);
                byId.setAllocationStatus("\u5ba1\u6838\u4e2d");
                this.updateById((Object)byId);
                break;
            }
            case 4: 
            case 5: {
                if (byId.getAllocationStatus().equals("\u5df2\u53d6\u6d88")) break;
                byId.setAllocationStatus("\u8c03\u62e8\u4e2d");
                this.updateById((Object)byId);
            }
        }
    }

    public String getInWarehouseManagementNumber() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper wrappers = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(InWarehouseManagementDO::getInWarehouseNumber, (Object)"WZRK-")).orderByDesc(InWarehouseManagementDO::getCreateTime);
        List inWarehouseManagementDOList = this.inWarehouseManagementService.list((Wrapper)wrappers);
        if (ObjectUtil.isEmpty((Object)inWarehouseManagementDOList)) {
            return "WZRK-" + simpleDateFormat.format(date) + "-001";
        }
        String recentInWarehouseNumber = ((InWarehouseManagementDO)this.inWarehouseManagementService.list((Wrapper)wrappers).get(0)).getInWarehouseNumber();
        String substring = recentInWarehouseNumber.substring(recentInWarehouseNumber.length() - 3);
        String threeNumber = this.incrementString(substring);
        return "WZRK-" + simpleDateFormat.format(date) + "-" + threeNumber;
    }

    public void workFromCallBackKeeper(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        EquipmentAllocationDO byId = (EquipmentAllocationDO)this.getById((Serializable)((Object)callBackVO.getBody().getBusinessKey()));
        switch (1.$SwitchMap$com$ruoyi$vo$supply$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Integer approveStatus;
                Map taskVariables = callBackVO.getBody().getTaskVariables();
                if (taskVariables.size() <= 0 || 2 != (approveStatus = (Integer)taskVariables.get("approveStatus"))) break;
                byId.setAllocationStatus("\u5ba1\u6838\u4e2d");
                this.updateById((Object)byId);
                break;
            }
            case 3: {
                LoginUser loginUser = UserUtils.getLoginUser();
                System.out.println(loginUser);
                byId.setAllocationStatus("\u5ba1\u6838\u4e2d");
                this.updateById((Object)byId);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private LambdaQueryWrapper getWrapper(EquipmentAllocationQuery equipmentAllocationQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getIds()), EquipmentAllocationDO::getId, (Collection)equipmentAllocationQuery.getIds())).like(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getAllocationNumber()), EquipmentAllocationDO::getAllocationNumber, (Object)equipmentAllocationQuery.getAllocationNumber())).like(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getTransfereeApplicants()), EquipmentAllocationDO::getTransfereeApplicants, (Object)equipmentAllocationQuery.getTransfereeApplicants())).like(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getSubjectName()), EquipmentAllocationDO::getSubjectName, (Object)equipmentAllocationQuery.getSubjectName())).eq(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getOutProject()), EquipmentAllocationDO::getOutProject, (Object)equipmentAllocationQuery.getOutProject())).eq(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getInProject()), EquipmentAllocationDO::getInProject, (Object)equipmentAllocationQuery.getInProject())).ge(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getTransferStartDate()), EquipmentAllocationDO::getTransferDate, (Object)equipmentAllocationQuery.getTransferStartDate())).le(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getTransferEndDate()), EquipmentAllocationDO::getTransferDate, (Object)equipmentAllocationQuery.getTransferEndDate())).eq(ObjectUtil.isNotEmpty((Object)equipmentAllocationQuery.getAllocationStatus()), EquipmentAllocationDO::getAllocationStatus, (Object)equipmentAllocationQuery.getAllocationStatus())).orderByDesc(EquipmentAllocationDO::getCreateTime);
        return wrapper;
    }

    public String getGenerateAllocationNumber() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(EquipmentAllocationDO::getAllocationNumber, (Object)"WZDB-")).orderByDesc(EquipmentAllocationDO::getCreateTime);
        if (ObjectUtil.isEmpty((Object)this.list((Wrapper)wrapper))) {
            return "WZDB-" + simpleDateFormat.format(date) + "-001";
        }
        String recentAllocationNumber = ((EquipmentAllocationDO)this.list((Wrapper)wrapper).get(0)).getAllocationNumber();
        String substring = recentAllocationNumber.substring(recentAllocationNumber.length() - 3);
        String threeNumber = this.incrementString(substring);
        return "WZDB-" + simpleDateFormat.format(date) + "-" + threeNumber;
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%03d", ++number);
    }

    private void saveEquipmentAllocationDetail(List<EquipmentAllocationDetailDTO> equipmentAllocationDetailDTOList, String allocationNumber) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)allocationNumber), EquipmentAllocationDO::getAllocationNumber, (Object)allocationNumber);
        EquipmentAllocationDO equipmentAllocationDO = (EquipmentAllocationDO)this.getOne((Wrapper)wrapper);
        Long mainId = equipmentAllocationDO.getId();
        List equipmentAllocationDetailDOList = equipmentAllocationDetailDTOList.stream().map(m -> {
            EquipmentAllocationDetailDO equipmentAllocationDetailDO = new EquipmentAllocationDetailDO();
            BeanUtils.copyProperties((Object)m, (Object)equipmentAllocationDetailDO);
            equipmentAllocationDetailDO.setIsDeleted(Integer.valueOf(0));
            equipmentAllocationDetailDO.setCreateTime(new Date());
            equipmentAllocationDetailDO.setUpdateTime(new Date());
            equipmentAllocationDetailDO.setMainId(mainId);
            return equipmentAllocationDetailDO;
        }).collect(Collectors.toList());
        this.equipmentAllocationDetailService.saveBatch(equipmentAllocationDetailDOList);
    }
}

