/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.entity.supply.InventoryManagementListDO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.mapper.supply.InventoryManagementListMapper;
import com.ruoyi.mapper.supply.MaterialCodeMapper;
import com.ruoyi.query.supply.InventoryStatisticsQuery;
import com.ruoyi.service.supply.InventoryManagementListService;
import com.ruoyi.service.supply.MaterialArchivesService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.vo.supply.InventoryStatisticsExportVO;
import com.ruoyi.vo.supply.InventoryStatisticsVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class InventoryManagementListServiceImpl
extends ServiceImpl<InventoryManagementListMapper, InventoryManagementListDO>
implements InventoryManagementListService {
    @Resource
    private MaterialArchivesService materialArchivesService;
    @Resource
    private MaterialCodeMapper materialCodeMapper;
    @Resource
    private StockListService stockListService;

    public List<InventoryStatisticsVO> query(InventoryStatisticsQuery inventoryStatisticsQuery) {
        List inventoryManagementListDOS;
        if (null != inventoryStatisticsQuery.getStartTime()) {
            inventoryStatisticsQuery.setStartTime(inventoryStatisticsQuery.getStartTime() + " 00:00:00");
        }
        if (null != inventoryStatisticsQuery.getEndTime()) {
            inventoryStatisticsQuery.setEndTime(inventoryStatisticsQuery.getEndTime() + " 23:59:59");
        }
        if (ObjectUtil.isNotEmpty((Object)(inventoryManagementListDOS = this.materialCodeMapper.queryInventoryStatisticsVO(inventoryStatisticsQuery)))) {
            if (inventoryStatisticsQuery.getSummaryType().equals("materialAndDate")) {
                List<InventoryStatisticsVO> inventoryStatisticsVOList = inventoryManagementListDOS.stream().map(m -> {
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)m.getMaterialId());
                    InventoryStatisticsVO inventoryStatisticsVO = new InventoryStatisticsVO();
                    inventoryStatisticsVO.setOccurrenceDate(m.getCreateTime());
                    inventoryStatisticsVO.setMaterialId(m.getMaterialId());
                    if (ObjectUtil.isNotEmpty((Object)materialArchivesDO)) {
                        if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getMaterialNumber())) {
                            inventoryStatisticsVO.setMaterialNumber(materialArchivesDO.getMaterialNumber());
                        }
                        if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getUnitMeasurement())) {
                            inventoryStatisticsVO.setUnitMeasurement(materialArchivesDO.getUnitMeasurement());
                        }
                    }
                    inventoryStatisticsVO.setInventoryCount(m.getInventoryCount());
                    inventoryStatisticsVO.setStockCount(m.getStockCount());
                    inventoryStatisticsVO.setMaterialName(m.getItemName());
                    inventoryStatisticsVO.setMaterialSpecifications(m.getMaterialSpecifications());
                    inventoryStatisticsVO.setPrice(m.getPrice());
                    inventoryStatisticsVO.setOneYardPerObject(m.getOneThingOneCode());
                    inventoryStatisticsVO.setUniqueCode(m.getUniqueCode());
                    inventoryStatisticsVO.setLossProfitAmount(m.getProfitLossAmount());
                    inventoryStatisticsVO.setLossProfitVolume(m.getProfitLossVolume());
                    inventoryStatisticsVO.setStatus(m.getStatus());
                    return inventoryStatisticsVO;
                }).collect(Collectors.toList());
                return inventoryStatisticsVOList;
            }
            Map<String, List<InventoryManagementListDO>> groupedItems = inventoryManagementListDOS.stream().collect(Collectors.groupingBy(InventoryManagementListDO::getItemName));
            ArrayList<InventoryStatisticsVO> inventoryStatisticsVOList = new ArrayList<InventoryStatisticsVO>();
            for (Map.Entry<String, List<InventoryManagementListDO>> entry : groupedItems.entrySet()) {
                List<InventoryManagementListDO> inventoryManagementListDOList = entry.getValue();
                if (!ObjectUtil.isNotEmpty(inventoryManagementListDOList)) continue;
                InventoryManagementListDO inventoryManagementDO = inventoryManagementListDOList.get(0);
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)inventoryManagementDO.getMaterialId());
                List list = this.stockListService.list((Wrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)inventoryManagementDO.getMaterialId()));
                InventoryStatisticsVO inventoryStatisticsVO = new InventoryStatisticsVO();
                inventoryStatisticsVO.setOneYardPerObject(inventoryManagementDO.getOneThingOneCode());
                inventoryStatisticsVO.setPrice(inventoryManagementDO.getPrice());
                inventoryStatisticsVO.setMaterialSpecifications(inventoryManagementDO.getMaterialSpecifications());
                inventoryStatisticsVO.setMaterialName(inventoryManagementDO.getItemName());
                if (list.size() > 0) {
                    inventoryStatisticsVO.setStockCount(((StockListDO)list.get(0)).getCurrentStock());
                }
                inventoryStatisticsVO.setMaterialId(inventoryManagementDO.getMaterialId());
                if (ObjectUtil.isNotEmpty((Object)materialArchivesDO)) {
                    if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getMaterialNumber())) {
                        inventoryStatisticsVO.setMaterialNumber(materialArchivesDO.getMaterialNumber());
                    }
                    if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getUnitMeasurement())) {
                        inventoryStatisticsVO.setUnitMeasurement(materialArchivesDO.getUnitMeasurement());
                    }
                }
                Long inventoryCount = 0L;
                Long stockCount = 0L;
                BigDecimal lossProfitAmount = new BigDecimal(0);
                Long lossProfitVolume = 0L;
                ArrayList uniqueCode = new ArrayList();
                for (InventoryManagementListDO inventoryManagementListDO : inventoryManagementListDOList) {
                    if (ObjectUtil.isNotEmpty((Object)inventoryStatisticsVO.getUniqueCode())) {
                        inventoryStatisticsVO.setUniqueCode(inventoryStatisticsVO.getUniqueCode() + "," + inventoryManagementListDO.getUniqueCode());
                    } else {
                        inventoryStatisticsVO.setUniqueCode(inventoryManagementListDO.getUniqueCode());
                    }
                    if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDO.getInventoryCount())) {
                        inventoryCount = inventoryCount + inventoryManagementListDO.getInventoryCount();
                    }
                    if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDO.getProfitLossAmount())) {
                        lossProfitAmount = lossProfitAmount.add(inventoryManagementListDO.getProfitLossAmount());
                    }
                    if (!ObjectUtil.isNotEmpty((Object)inventoryManagementListDO.getProfitLossVolume())) continue;
                    lossProfitVolume = lossProfitVolume + inventoryManagementListDO.getProfitLossVolume();
                }
                inventoryStatisticsVO.setInventoryCount(inventoryCount);
                inventoryStatisticsVO.setStockCount(stockCount);
                inventoryStatisticsVO.setLossProfitAmount(lossProfitAmount);
                inventoryStatisticsVO.setLossProfitVolume(lossProfitVolume);
                inventoryStatisticsVOList.add(inventoryStatisticsVO);
            }
            return inventoryStatisticsVOList;
        }
        return null;
    }

    public void exportExcel(InventoryStatisticsQuery inventoryStatisticsQuery, HttpServletResponse response) throws IOException {
        List inventoryStatisticsVOList = this.query(inventoryStatisticsQuery);
        if (inventoryStatisticsQuery.getSummaryType().equals("\u7269\u8d44\uff0b\u65e5\u671f")) {
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u76d8\u70b9\u7edf\u8ba1\u8868", "\u76d8\u70b9\u7edf\u8ba1\u8868", ExcelType.XSSF), InventoryStatisticsVO.class, (Collection)inventoryStatisticsVOList);
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u76d8\u70b9\u7edf\u8ba1\u8868-" + dateFormat.format(date)));
        } else {
            List inventoryStatisticsExportVOList = inventoryStatisticsVOList.stream().map(m -> {
                InventoryStatisticsExportVO inventoryStatisticsExportVO = new InventoryStatisticsExportVO();
                BeanUtils.copyProperties((Object)m, (Object)inventoryStatisticsExportVO);
                return inventoryStatisticsExportVO;
            }).collect(Collectors.toList());
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u76d8\u70b9\u7edf\u8ba1\u8868", "\u76d8\u70b9\u7edf\u8ba1\u8868", ExcelType.XSSF), InventoryStatisticsExportVO.class, inventoryStatisticsExportVOList);
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u76d8\u70b9\u7edf\u8ba1\u8868-" + dateFormat.format(date)));
        }
    }
}

