/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.HandlelnvoicingDto;
import com.ruoyi.dto.supply.InventoryManagementDTO;
import com.ruoyi.dto.supply.InventoryManagementListDTO;
import com.ruoyi.entity.supply.InventoryManagementDO;
import com.ruoyi.entity.supply.InventoryManagementListDO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.entity.supply.MaterialCodeDo;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.mapper.supply.InventoryManagementMapper;
import com.ruoyi.query.supply.InventoryManagementQuery;
import com.ruoyi.service.supply.InventoryManagementListService;
import com.ruoyi.service.supply.InventoryManagementService;
import com.ruoyi.service.supply.MaterialArchivesService;
import com.ruoyi.service.supply.MaterialCodeService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.supply.InventoryManagementExportVO;
import com.ruoyi.vo.supply.InventoryManagementVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class InventoryManagementServiceImpl
extends ServiceImpl<InventoryManagementMapper, InventoryManagementDO>
implements InventoryManagementService {
    private static final Logger log = LoggerFactory.getLogger(InventoryManagementServiceImpl.class);
    @Resource
    private InventoryManagementListService inventoryManagementListService;
    @Resource
    private HandleInvoicingStatistics handleInvoicingStatistics;
    @Resource
    private MaterialArchivesService materialArchivesService;
    @Resource
    private StockListService stockListService;
    @Resource
    private MaterialCodeService materialCodeService;

    public PageResultVo<InventoryManagementVO> pageList(InventoryManagementQuery inventoryManagementQuery) {
        LambdaQueryWrapper wrapper = this.getWrapper(inventoryManagementQuery);
        Page page = (Page)this.page((IPage)new Page((long)inventoryManagementQuery.getPageNum(), (long)inventoryManagementQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo inventoryManagementVOPageResultVo = new PageResultVo();
        ArrayList<InventoryManagementVO> inventoryManagementVOList = new ArrayList<InventoryManagementVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (InventoryManagementDO inventoryManagementDO : resultVo.getData()) {
                InventoryManagementVO inventoryManagementVO = new InventoryManagementVO();
                BeanUtils.copyProperties((Object)inventoryManagementDO, (Object)inventoryManagementVO);
                inventoryManagementVOList.add(inventoryManagementVO);
            }
        }
        inventoryManagementVOPageResultVo.setData(inventoryManagementVOList);
        inventoryManagementVOPageResultVo.setPageSize(resultVo.getPageSize());
        inventoryManagementVOPageResultVo.setPageNum(resultVo.getPageNum());
        inventoryManagementVOPageResultVo.setTotal(resultVo.getTotal());
        inventoryManagementVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return inventoryManagementVOPageResultVo;
    }

    public void exportInventoryManagement(InventoryManagementQuery inventoryManagementQuery, HttpServletResponse response) throws IOException {
        LambdaQueryWrapper wrapper = this.getWrapper(inventoryManagementQuery);
        List inventoryManagementDOList = this.list((Wrapper)wrapper);
        List<Object> inventoryManagementExportVOList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)inventoryManagementDOList)) {
            inventoryManagementExportVOList = inventoryManagementDOList.stream().map(inventoryManagementDO -> {
                InventoryManagementExportVO inventoryManagementExportVO = new InventoryManagementExportVO();
                BeanUtils.copyProperties((Object)inventoryManagementDO, (Object)inventoryManagementExportVO);
                return inventoryManagementExportVO;
            }).collect(Collectors.toList());
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u76d8\u70b9\u7ba1\u7406", "\u76d8\u70b9\u7ba1\u7406", ExcelType.XSSF), InventoryManagementExportVO.class, inventoryManagementExportVOList);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u76d8\u70b9\u7ba1\u7406-" + dateFormat.format(date)));
    }

    public InventoryManagementVO queryDetail(Long id) {
        InventoryManagementVO inventoryManagementVO = new InventoryManagementVO();
        InventoryManagementDO inventoryManagementDO = (InventoryManagementDO)this.getById((Serializable)id);
        BeanUtils.copyProperties((Object)inventoryManagementDO, (Object)inventoryManagementVO);
        List inventoryManagementListDOS = this.inventoryManagementListService.list((Wrapper)new LambdaQueryWrapper().eq(InventoryManagementListDO::getMainId, (Object)id));
        List inventoryManagementListDTOS = inventoryManagementListDOS.stream().map(m -> {
            InventoryManagementListDTO inventoryManagementListDTO = new InventoryManagementListDTO();
            BeanUtils.copyProperties((Object)m, (Object)inventoryManagementListDTO);
            return inventoryManagementListDTO;
        }).collect(Collectors.toList());
        inventoryManagementVO.setInventoryManagementListDTOList(inventoryManagementListDTOS);
        return inventoryManagementVO;
    }

    public void continueInput(InventoryManagementDTO inventoryManagementDTO) {
        InventoryManagementDO inventoryManagementDO = (InventoryManagementDO)this.getById((Serializable)inventoryManagementDTO.getId());
        if (ObjectUtil.isEmpty((Object)inventoryManagementDO)) {
            log.info("\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        BeanUtils.copyProperties((Object)inventoryManagementDTO, (Object)inventoryManagementDO);
        inventoryManagementDO.setUpdateTime(new Date());
        List inventoryManagementListDTOS = inventoryManagementDTO.getInventoryManagementListDTOS();
        ArrayList<InventoryManagementListDO> inventoryManagementListDOList = new ArrayList<InventoryManagementListDO>();
        Long inventoryCount = 0L;
        Long profitLossVolume = 0L;
        BigDecimal profitLossAmount = new BigDecimal(0);
        for (InventoryManagementListDTO inventoryManagementListDTO : inventoryManagementListDTOS) {
            InventoryManagementListDO inventoryManagementListDO;
            inventoryCount = inventoryCount + inventoryManagementListDTO.getInventoryCount();
            profitLossVolume = profitLossVolume + inventoryManagementListDTO.getProfitLossVolume();
            profitLossAmount = profitLossAmount.add(inventoryManagementListDTO.getProfitLossAmount());
            if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDTO.getId())) {
                inventoryManagementListDO = (InventoryManagementListDO)this.inventoryManagementListService.getById((Serializable)inventoryManagementListDTO.getId());
                BeanUtils.copyProperties((Object)inventoryManagementListDTO, (Object)inventoryManagementListDO);
                inventoryManagementListDO.setUpdateTime(new Date());
                this.inventoryManagementListService.updateById((Object)inventoryManagementListDO);
                break;
            }
            inventoryManagementListDO = new InventoryManagementListDO();
            BeanUtils.copyProperties((Object)inventoryManagementListDTO, (Object)inventoryManagementListDO);
            inventoryManagementListDO.setCreateTime(new Date());
            inventoryManagementListDO.setUpdateTime(new Date());
            inventoryManagementListDO.setMainId(inventoryManagementDTO.getId());
            inventoryManagementListDOList.add(inventoryManagementListDO);
        }
        inventoryManagementDO.setProfitLossVolume(profitLossVolume);
        inventoryManagementDO.setInventoryCount(inventoryCount);
        inventoryManagementDO.setProfitLossAmount(profitLossAmount);
        this.updateById((Object)inventoryManagementDO);
        this.inventoryManagementListService.saveBatch(inventoryManagementListDOList);
    }

    public void add(InventoryManagementDTO inventoryManagementDTO) {
        InventoryManagementListDO inventoryManagementListDO;
        List inventoryManagementListDTOS1 = inventoryManagementDTO.getInventoryManagementListDTOS();
        Long inventoryCount = 0L;
        Long profitVolume = 0L;
        BigDecimal profitBigDecimal = new BigDecimal(0);
        Long lossVolume = 0L;
        BigDecimal lossDecimal = new BigDecimal(0);
        if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDTOS1)) {
            for (InventoryManagementListDTO inventoryManagementListDTO : inventoryManagementListDTOS1) {
                BigDecimal bigDecimal;
                if (null != inventoryManagementListDTO.getStatus() && inventoryManagementListDTO.getStatus() == 0) {
                    profitVolume = profitVolume + inventoryManagementListDTO.getProfitLossVolume();
                    bigDecimal = this.setOutboundAmount(inventoryManagementListDTO.getProfitLossVolume(), inventoryManagementListDTO.getPrice());
                    profitBigDecimal = profitBigDecimal.add(bigDecimal);
                }
                if (null != inventoryManagementListDTO.getStatus() && inventoryManagementListDTO.getStatus() == 1) {
                    lossVolume = lossVolume + inventoryManagementListDTO.getProfitLossVolume();
                    bigDecimal = this.setOutboundAmount(inventoryManagementListDTO.getProfitLossVolume(), inventoryManagementListDTO.getPrice());
                    lossDecimal = lossDecimal.add(bigDecimal);
                }
                if (!ObjectUtil.isNotEmpty((Object)inventoryManagementListDTO.getInventoryCount())) continue;
                inventoryCount = inventoryCount + inventoryManagementListDTO.getInventoryCount();
            }
        }
        InventoryManagementDO inventoryManagementDO = new InventoryManagementDO();
        BeanUtils.copyProperties((Object)inventoryManagementDTO, (Object)inventoryManagementDO);
        if (profitVolume > lossVolume) {
            inventoryManagementDO.setStatus(Integer.valueOf(0));
            inventoryManagementDO.setProfitLossVolume(Long.valueOf(profitVolume - lossVolume));
            inventoryManagementDO.setProfitLossAmount(profitBigDecimal.subtract(lossDecimal));
        } else if (lossVolume > profitVolume) {
            inventoryManagementDO.setStatus(Integer.valueOf(1));
            inventoryManagementDO.setProfitLossVolume(Long.valueOf(lossVolume - profitVolume));
            inventoryManagementDO.setProfitLossAmount(lossDecimal.subtract(profitBigDecimal));
        } else {
            inventoryManagementDO.setStatus(Integer.valueOf(2));
            inventoryManagementDO.setProfitLossVolume(Long.valueOf(0L));
            inventoryManagementDO.setProfitLossAmount(new BigDecimal(0));
        }
        inventoryManagementDO.setInventoryCount(inventoryCount);
        inventoryManagementDO.setInventoryContentMax(inventoryManagementDTO.getUniqueCodeCollection());
        inventoryManagementDO.setCreateTime(new Date());
        inventoryManagementDO.setUpdateTime(new Date());
        String inventoryNumber = this.getInventoryNumber();
        inventoryManagementDO.setInventoryNumber(inventoryNumber);
        inventoryManagementDO.setIsDeleted(Integer.valueOf(0));
        if (inventoryManagementDTO.getSaveOrCarryForward().equals("save")) {
            inventoryManagementDO.setInventoryStatus("\u4fdd\u5b58");
        }
        if (inventoryManagementDTO.getSaveOrCarryForward().equals("carryForward")) {
            inventoryManagementDO.setInventoryStatus("\u5df2\u5b8c\u6210");
        }
        ThemeUtils themes = new ThemeUtils();
        inventoryManagementDO.setSubjectName(ThemeUtils.getThemeName((String)"\u76d8\u70b9\u7533\u8bf7"));
        if (null != inventoryManagementDO.getId()) {
            inventoryManagementDO.setUpdateTime(new Date());
            this.updateById((Object)inventoryManagementDO);
        } else {
            this.save((Object)inventoryManagementDO);
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(InventoryManagementDO::getInventoryNumber, (Object)inventoryNumber);
        InventoryManagementDO managementDO = (InventoryManagementDO)this.getOne((Wrapper)wrapper);
        List inventoryManagementListDTOS = inventoryManagementDTO.getInventoryManagementListDTOS();
        List<InventoryManagementListDO> inventoryManagementListDOS = inventoryManagementListDTOS.stream().map(m -> {
            InventoryManagementListDO inventoryManagementListDO = new InventoryManagementListDO();
            BeanUtils.copyProperties((Object)m, (Object)inventoryManagementListDO);
            inventoryManagementListDO.setCreateTime(new Date());
            inventoryManagementListDO.setUpdateTime(new Date());
            inventoryManagementListDO.setIsDeleted(Integer.valueOf(0));
            inventoryManagementListDO.setMainId(managementDO.getId());
            if (inventoryManagementDTO.getSaveOrCarryForward().equals("carryForward")) {
                StockListDO byId = (StockListDO)this.stockListService.getOne((Wrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)inventoryManagementListDO.getMaterialId()));
                if (ObjectUtil.isNotEmpty((Object)byId)) {
                    byId.setCurrentStock(inventoryManagementListDO.getInventoryCount());
                    byId.setUniqueCode(inventoryManagementListDO.getUniqueCode());
                    this.stockListService.updateById((Object)byId);
                } else {
                    MaterialArchivesDO byId1 = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)inventoryManagementListDO.getMaterialId());
                    StockListDO byIds = new StockListDO();
                    BeanUtils.copyProperties((Object)byId1, (Object)byIds);
                    byIds.setCurrentStock(inventoryManagementListDO.getInventoryCount());
                    byIds.setUniqueCode(inventoryManagementListDO.getUniqueCode());
                    byIds.setCreateTime(new Date());
                    byIds.setId(null);
                    byIds.setMaterialId(byId1.getId());
                    this.stockListService.save((Object)byIds);
                }
                if (inventoryManagementListDO.getOneThingOneCode().equals("\u542f\u7528")) {
                    List list = this.materialCodeService.list((Wrapper)new LambdaQueryWrapper().eq(MaterialCodeDo::getMaterialId, (Object)inventoryManagementListDO.getMaterialId()));
                    if (ObjectUtil.isNotEmpty((Object)list)) {
                        for (MaterialCodeDo materialCodeDo : list) {
                            this.materialCodeService.removeById((Serializable)materialCodeDo.getId());
                        }
                    }
                    if (inventoryManagementListDO.getInventoryCount() > 0L) {
                        String uniqueCode = inventoryManagementListDO.getUniqueCode();
                        for (String s : uniqueCode.split(",")) {
                            MaterialCodeDo materialCodeDo = new MaterialCodeDo();
                            materialCodeDo.setMaterialCode(s);
                            materialCodeDo.setMaterialId(inventoryManagementListDO.getMaterialId());
                            materialCodeDo.setCreateTime(new Date());
                            materialCodeDo.setIsDeleted(Integer.valueOf(0));
                            this.materialCodeService.save((Object)materialCodeDo);
                        }
                    }
                }
            }
            if (null == inventoryManagementListDO.getId()) {
                return inventoryManagementListDO;
            }
            inventoryManagementListDO.setUpdateTime(new Date());
            this.inventoryManagementListService.updateById((Object)inventoryManagementListDO);
            return new InventoryManagementListDO();
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(inventoryManagementListDOS) && inventoryManagementListDOS.size() > 0 && ObjectUtil.isNotEmpty((Object)(inventoryManagementListDO = (InventoryManagementListDO)inventoryManagementListDOS.get(0))) && null != inventoryManagementListDO.getMainId()) {
            this.inventoryManagementListService.saveBatch(inventoryManagementListDOS);
        }
        if (inventoryManagementDTO.getSaveOrCarryForward().equals("carryForward")) {
            try {
                ArrayList handlelnvoicingDtoList = new ArrayList();
                inventoryManagementListDOS.forEach(a -> {
                    HandlelnvoicingDto handlelnvoicingDto = new HandlelnvoicingDto();
                    handlelnvoicingDto.setMaterialId(a.getMaterialId());
                    if (null != a.getProfitLossVolume()) {
                        handlelnvoicingDto.setCount(a.getProfitLossVolume());
                    } else {
                        handlelnvoicingDto.setCount(Long.valueOf(0L));
                    }
                    handlelnvoicingDto.setType(7);
                    handlelnvoicingDtoList.add(handlelnvoicingDto);
                });
                this.handleInvoicingStatistics.updateOutWarehouseDataHandle(handlelnvoicingDtoList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public BigDecimal setOutboundAmount(Long actualWarehouseingQuantity, BigDecimal referencePrice) {
        if (actualWarehouseingQuantity != null && referencePrice != null) {
            BigDecimal actualWarehouseingQuantityBigDecimal = new BigDecimal(actualWarehouseingQuantity);
            BigDecimal inboundAmount = actualWarehouseingQuantityBigDecimal.multiply(referencePrice);
            return inboundAmount;
        }
        return null;
    }

    public void updatePreservation(InventoryManagementDTO inventoryManagementDTO) {
        InventoryManagementDO inventoryManagementDO = new InventoryManagementDO();
        BeanUtils.copyProperties((Object)inventoryManagementDTO, (Object)inventoryManagementDO);
        List inventoryManagementListDTOS = inventoryManagementDTO.getInventoryManagementListDTOS();
        if (null != inventoryManagementDTO.getId() && inventoryManagementDTO.getId() != 0L) {
            BeanUtils.copyProperties((Object)inventoryManagementDTO, (Object)inventoryManagementDO);
            inventoryManagementDO.setUpdateTime(new Date());
            inventoryManagementDO.setUpdateId(UserUtils.getLoginUser().getUserid());
            inventoryManagementDO.setUpdateName(UserUtils.getLoginUser().getUsername());
            this.updateById((Object)inventoryManagementDO);
            List inventoryManagementListDOS = inventoryManagementListDTOS.stream().map(m -> {
                InventoryManagementListDO inventoryManagementListDO = new InventoryManagementListDO();
                BeanUtils.copyProperties((Object)m, (Object)inventoryManagementListDO);
                inventoryManagementListDO.setCreateTime(new Date());
                inventoryManagementListDO.setUpdateTime(new Date());
                inventoryManagementListDO.setIsDeleted(Integer.valueOf(0));
                return inventoryManagementListDO;
            }).collect(Collectors.toList());
            this.inventoryManagementListService.saveBatch(inventoryManagementListDOS);
        } else {
            inventoryManagementDO.setInventoryStatus("\u4fdd\u5b58");
            this.save((Object)inventoryManagementDO);
            List inventoryManagementListDOS = inventoryManagementListDTOS.stream().map(m -> {
                InventoryManagementListDO inventoryManagementListDO = new InventoryManagementListDO();
                BeanUtils.copyProperties((Object)m, (Object)inventoryManagementListDO);
                inventoryManagementListDO.setCreateTime(new Date());
                inventoryManagementListDO.setUpdateTime(new Date());
                inventoryManagementListDO.setIsDeleted(Integer.valueOf(0));
                inventoryManagementListDO.setMainId(inventoryManagementDO.getId());
                return inventoryManagementListDO;
            }).collect(Collectors.toList());
            this.inventoryManagementListService.saveBatch(inventoryManagementListDOS);
        }
    }

    private String getInventoryNumber() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(InventoryManagementDO::getInventoryNumber, (Object)"CKPD-")).orderByDesc(InventoryManagementDO::getCreateTime);
        if (ObjectUtil.isEmpty((Object)this.list((Wrapper)wrapper))) {
            return "CKPD-" + simpleDateFormat.format(date) + "-001";
        }
        String recentInventoryNumber = ((InventoryManagementDO)this.list((Wrapper)wrapper).get(0)).getInventoryNumber();
        String substring = recentInventoryNumber.substring(recentInventoryNumber.length() - 3);
        String threeNumber = this.incrementString(substring);
        return "CKPD-" + simpleDateFormat.format(date) + "-" + threeNumber;
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%03d", ++number);
    }

    public LambdaQueryWrapper getWrapper(InventoryManagementQuery inventoryManagementQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ObjectUtil.isNotEmpty((Object)inventoryManagementQuery.getIds()), InventoryManagementDO::getId, (Collection)inventoryManagementQuery.getIds())).like(ObjectUtil.isNotEmpty((Object)inventoryManagementQuery.getSubjectName()), InventoryManagementDO::getSubjectName, (Object)inventoryManagementQuery.getSubjectName())).like(ObjectUtil.isNotEmpty((Object)inventoryManagementQuery.getInventoryPerson()), InventoryManagementDO::getInventoryPerson, (Object)inventoryManagementQuery.getInventoryPerson())).like(ObjectUtil.isNotEmpty((Object)inventoryManagementQuery.getInventoryNumber()), InventoryManagementDO::getInventoryNumber, (Object)inventoryManagementQuery.getInventoryNumber())).eq(ObjectUtil.isNotEmpty((Object)inventoryManagementQuery.getInventoryType()), InventoryManagementDO::getInventoryType, (Object)inventoryManagementQuery.getInventoryType())).eq(ObjectUtil.isNotEmpty((Object)inventoryManagementQuery.getInventoryStatus()), InventoryManagementDO::getInventoryStatus, (Object)inventoryManagementQuery.getInventoryStatus())).eq(ObjectUtil.isNotEmpty((Object)inventoryManagementQuery.getInventoryDate()), InventoryManagementDO::getInventoryDate, (Object)inventoryManagementQuery.getInventoryDate())).orderByDesc(InventoryManagementDO::getCreateTime);
        return wrapper;
    }
}

