/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.packagescan.resource.ClassPathResource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.supply.MaterialArchivesDTO;
import com.ruoyi.entity.supply.ItemCategoryDO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.entity.supply.SupplierArchiveDO;
import com.ruoyi.feign.SystemClient;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.mapper.supply.MaterialArchivesMapper;
import com.ruoyi.mapper.supply.StockListMapper;
import com.ruoyi.mapper.supply.SupplierArchiveMapper;
import com.ruoyi.query.supply.MaterialArchivesQuery;
import com.ruoyi.service.supply.InvoicingStatisticsService;
import com.ruoyi.service.supply.ItemCategoryService;
import com.ruoyi.service.supply.MaterialArchivesService;
import com.ruoyi.util.ChinesePinyin;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.supply.ItemCategoryVO;
import com.ruoyi.vo.supply.MaterialArchivesExportVO;
import com.ruoyi.vo.supply.MaterialArchivesImportVO;
import com.ruoyi.vo.supply.MaterialArchivesVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MaterialArchivesServiceImpl
extends ServiceImpl<MaterialArchivesMapper, MaterialArchivesDO>
implements MaterialArchivesService {
    @Resource
    private ItemCategoryService itemCategoryService;
    @Resource
    private HandleInvoicingStatistics handleInvoicingStatistics;
    @Resource
    private InvoicingStatisticsService invoicingStatisticsService;
    @Resource
    private StockListMapper stockListMapper;
    @Autowired
    private SupplierArchiveMapper supplierArchiveMapper;
    @Autowired
    private SystemClient systemClient;

    public PageResultVo<MaterialArchivesVO> getMaterialArchivesListPage(MaterialArchivesQuery materialArchivesQuery) {
        LambdaQueryWrapper wrapper = this.getWrapper(materialArchivesQuery);
        Page page = (Page)this.page((IPage)new Page((long)materialArchivesQuery.getPageNum(), (long)materialArchivesQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo materialArchivesVOPageResultVo = new PageResultVo();
        ArrayList<MaterialArchivesVO> materialArchivesVOList = new ArrayList<MaterialArchivesVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (MaterialArchivesDO materialArchivesDO : resultVo.getData()) {
                SupplierArchiveDO byId;
                MaterialArchivesVO materialArchivesVO = new MaterialArchivesVO();
                BeanUtils.copyProperties((Object)materialArchivesDO, (Object)materialArchivesVO);
                if (StringUtils.isNotBlank((CharSequence)materialArchivesDO.getAssociatedSupplierId()) && ObjectUtil.isNotEmpty((Object)(byId = (SupplierArchiveDO)this.supplierArchiveMapper.selectById((Serializable)((Object)materialArchivesDO.getAssociatedSupplierId()))))) {
                    materialArchivesVO.setAssociatedSupplier(byId.getSupplierName());
                }
                materialArchivesVOList.add(materialArchivesVO);
            }
        }
        materialArchivesVOPageResultVo.setData(materialArchivesVOList);
        materialArchivesVOPageResultVo.setPageSize(resultVo.getPageSize());
        materialArchivesVOPageResultVo.setPageNum(resultVo.getPageNum());
        materialArchivesVOPageResultVo.setTotal(resultVo.getTotal());
        materialArchivesVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return materialArchivesVOPageResultVo;
    }

    public Boolean moveMaterials(MaterialArchivesDTO materialArchivesDTO) {
        ArrayList<MaterialArchivesDO> materialArchivesDOList = new ArrayList<MaterialArchivesDO>();
        for (Long id : materialArchivesDTO.getIds()) {
            MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.getById((Serializable)id);
            if (!ObjectUtil.isNotEmpty((Object)materialArchivesDO)) continue;
            materialArchivesDO.setMaterialCategoryId(materialArchivesDTO.getMaterialCategoryId());
            materialArchivesDO.setMaterialCategory(materialArchivesDTO.getMaterialCategory());
            materialArchivesDOList.add(materialArchivesDO);
        }
        if (ObjectUtil.isNotEmpty(materialArchivesDOList)) {
            this.updateBatchById(materialArchivesDOList);
            return true;
        }
        return false;
    }

    public void addMaterialArchives(MaterialArchivesDTO materialArchivesDTO) throws ParseException {
        MaterialArchivesDO materialArchivesDO = new MaterialArchivesDO();
        BeanUtils.copyProperties((Object)materialArchivesDTO, (Object)materialArchivesDO);
        materialArchivesDO.setCreateTime(new Date());
        materialArchivesDO.setUpdateTime(new Date());
        materialArchivesDO.setMaterialNumber(this.getGenerateMaterialNumber(materialArchivesDTO.getMaterialCategoryIdList()));
        materialArchivesDO.setIsDeleted(Integer.valueOf(0));
        if (ObjectUtil.isNotEmpty((Object)materialArchivesDTO.getMaterialCategoryId())) {
            Long materialCategoryId = materialArchivesDTO.getMaterialCategoryId();
            materialArchivesDO.setMaterialCategoryId(materialCategoryId);
        }
        this.save((Object)materialArchivesDO);
        this.handleInvoicingStatistics.saveInvoicingStatisticsDO(materialArchivesDO);
    }

    public void updateMaterialArchives(MaterialArchivesDTO materialArchivesDTO) throws ParseException {
        MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.getById((Serializable)materialArchivesDTO.getId());
        BeanUtils.copyProperties((Object)materialArchivesDTO, (Object)materialArchivesDO);
        materialArchivesDO.setUpdateTime(new Date());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"reference_price", (Object)materialArchivesDO.getReferencePrice());
        updateWrapper.eq((Object)"material_id", (Object)materialArchivesDTO.getId());
        this.stockListMapper.update(null, (Wrapper)updateWrapper);
        UpdateWrapper updateWrappers = new UpdateWrapper();
        updateWrappers.set((Object)"specifications_models", (Object)materialArchivesDO.getMaterialSpecification());
        updateWrappers.set((Object)"item_name", (Object)materialArchivesDO.getMaterialName());
        updateWrappers.set((Object)"measure_unit", (Object)materialArchivesDO.getUnitMeasurement());
        updateWrappers.eq((Object)"material_id", (Object)materialArchivesDTO.getId());
        this.invoicingStatisticsService.update(null, (Wrapper)updateWrappers);
        this.updateById((Object)materialArchivesDO);
    }

    public void exportMaterialArchives(HttpServletResponse response) throws IOException {
        ArrayList<MaterialArchivesExportVO> materialArchivesExportVOList = new ArrayList<MaterialArchivesExportVO>();
        List materialArchivesDOList = this.list((Wrapper)new LambdaQueryWrapper().orderByDesc(MaterialArchivesDO::getUpdateTime));
        if (ObjectUtil.isNotEmpty((Object)materialArchivesDOList)) {
            for (MaterialArchivesDO materialArchivesDO : materialArchivesDOList) {
                MaterialArchivesExportVO materialArchivesExportVO = new MaterialArchivesExportVO();
                BeanUtils.copyProperties((Object)materialArchivesDO, (Object)materialArchivesExportVO);
                materialArchivesExportVOList.add(materialArchivesExportVO);
            }
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u7269\u8d44\u6863\u6848", "\u7269\u8d44\u6863\u6848", ExcelType.XSSF), MaterialArchivesExportVO.class, materialArchivesExportVOList);
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u7269\u8d44\u6863\u6848");
    }

    public String importMaterialArchives(MultipartFile file) {
        ExcelImportResult importResult;
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerify(true);
        try {
            importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), MaterialArchivesImportVO.class, (ImportParams)importParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List materialArchivesImportVOList = importResult.getList();
        if (ObjectUtil.isNotEmpty((Object)materialArchivesImportVOList)) {
            ArrayList<MaterialArchivesDO> materialArchivesDOList = new ArrayList<MaterialArchivesDO>();
            List searchMenu = this.itemCategoryService.getSearchMenu();
            for (MaterialArchivesImportVO materialArchivesImportVO : materialArchivesImportVOList) {
                LambdaQueryWrapper parentWrapper;
                if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getMaterialName())) {
                    return "\u7269\u8d44\u540d\u79f0\u4e3a\u7a7a";
                }
                if (materialArchivesImportVO.getMaterialName().contains(">>")) {
                    return "\u7269\u8d44\u540d\u79f0\u5305\u542b\u7279\u6b8a\u5b57\u7b26\uff1a>>";
                }
                if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getAssociatedSupplier())) {
                    return "\u5173\u8054\u4f9b\u5e94\u5546\u4e3a\u7a7a";
                }
                if (ObjectUtil.isEmpty((Object)materialArchivesImportVO.getMaterialCategory())) {
                    return "\u7269\u8d44\u7c7b\u522b\u4e3a\u7a7a";
                }
                List list = this.materialCategoryByName(materialArchivesImportVO.getMaterialCategory(), searchMenu);
                if (ObjectUtil.isEmpty((Object)list)) {
                    return "\u7269\u8d44\u7c7b\u522b\u9519\u8bef\uff0c\u8bc6\u522b\u4e0d\u5230\u7cfb\u7edf\u914d\u7f6e\uff01";
                }
                MaterialArchivesDO materialArchivesDO = new MaterialArchivesDO();
                materialArchivesDO.setMaterialCategoryIdList(JSON.toJSONString((Object)list));
                BeanUtils.copyProperties((Object)materialArchivesImportVO, (Object)materialArchivesDO);
                materialArchivesDO.setUpdateTime(new Date());
                materialArchivesDO.setCreateTime(new Date());
                materialArchivesDO.setIsDeleted(Integer.valueOf(0));
                if (materialArchivesDO.getMaterialCategory().contains(">>")) {
                    LambdaQueryWrapper parentWrapper2;
                    ItemCategoryDO itemCategoryDO;
                    String[] split = materialArchivesDO.getMaterialCategory().split(">>");
                    if (split.length >= 1 && ObjectUtil.isNotEmpty((Object)(itemCategoryDO = (ItemCategoryDO)this.itemCategoryService.getOne((Wrapper)(parentWrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ItemCategoryDO::getMenuName, (Object)split[split.length - 1])))))) {
                        materialArchivesDO.setMaterialCategoryId(itemCategoryDO.getId());
                    }
                } else {
                    parentWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ItemCategoryDO::getMenuName, (Object)materialArchivesDO.getMaterialCategory());
                    ItemCategoryDO itemCategoryDO = (ItemCategoryDO)this.itemCategoryService.getOne((Wrapper)parentWrapper);
                    if (ObjectUtil.isNotEmpty((Object)itemCategoryDO)) {
                        materialArchivesDO.setMaterialCategoryId(itemCategoryDO.getId());
                    }
                }
                parentWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SupplierArchiveDO::getSupplierName, (Object)materialArchivesDO.getAssociatedSupplier());
                SupplierArchiveDO supplierArchiveDO = (SupplierArchiveDO)this.supplierArchiveMapper.selectOne((Wrapper)parentWrapper);
                if (ObjectUtil.isNotEmpty((Object)supplierArchiveDO)) {
                    materialArchivesDO.setAssociatedSupplierId(supplierArchiveDO.getId().toString());
                }
                materialArchivesDO.setUpdateName(UserUtils.getLoginUser().getUsername());
                materialArchivesDOList.add(materialArchivesDO);
            }
            for (MaterialArchivesDO materialArchivesDO : materialArchivesDOList) {
                materialArchivesDO.setMaterialNumber(this.getGenerateMaterialNumber1(materialArchivesDO.getMaterialCategory()));
                this.save((Object)materialArchivesDO);
            }
            return "true";
        }
        return "\u4e3a\u83b7\u53d6\u5230\u5bfc\u5165\u6570\u636e";
    }

    public List<String> getUnitMeasure() {
        JSONObject resultJsonObj = this.systemClient.getListByType("measurement_unit");
        List<String> unitMeasureList = new ArrayList<String>();
        if (resultJsonObj.getIntValue("code") == 200) {
            JSONArray array = resultJsonObj.getJSONArray("data");
            List jsonObjects = array.toJavaList(JSONObject.class);
            unitMeasureList = jsonObjects.stream().map(a -> a.getString("dictLabel")).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return unitMeasureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u7269\u8d44\u6863\u6848\u5bfc\u5165\u6a21\u677f.xls", "UTF-8"));
        InputStream input = null;
        OutputStream output = null;
        try {
            InputStream inputStream;
            ClassPathResource classPathResource = new ClassPathResource(fileName);
            input = inputStream = classPathResource.getInputStream();
            output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public MaterialArchivesVO getMaterialArchiveDetail(Long id) {
        MaterialArchivesVO materialArchivesVO = new MaterialArchivesVO();
        if (ObjectUtil.isEmpty((Object)id)) {
            return materialArchivesVO;
        }
        MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.getById((Serializable)id);
        SupplierArchiveDO byId = (SupplierArchiveDO)this.supplierArchiveMapper.selectById((Serializable)((Object)materialArchivesDO.getAssociatedSupplierId()));
        if (ObjectUtil.isNotEmpty((Object)byId)) {
            materialArchivesVO.setAssociatedSupplier(byId.getSupplierName());
        }
        BeanUtils.copyProperties((Object)materialArchivesDO, (Object)materialArchivesVO);
        materialArchivesVO.setMaterialCategoryId(materialArchivesDO.getMaterialCategoryId());
        materialArchivesVO.setAssociatedSupplierId(materialArchivesDO.getAssociatedSupplierId());
        materialArchivesVO.setMaterialCategoryIdList(materialArchivesDO.getMaterialCategoryIdList());
        return materialArchivesVO;
    }

    public LambdaQueryWrapper getWrapper(MaterialArchivesQuery materialArchivesQuery) {
        List materialIds = null;
        String materialId = materialArchivesQuery.getMaterialId();
        ArrayList<Long> materialIdss = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)materialId)) {
            if (materialId.equals("0")) {
                materialIds = this.getMaterialIds();
            } else {
                materialIdss.add(Long.parseLong(materialId));
                materialIds = this.getMaterialId(materialIdss);
            }
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ObjectUtil.isNotEmpty(materialIds), MaterialArchivesDO::getMaterialCategoryId, (Collection)materialIds)).like(ObjectUtil.isNotEmpty((Object)materialArchivesQuery.getMaterialName()), MaterialArchivesDO::getMaterialName, (Object)materialArchivesQuery.getMaterialName())).like(ObjectUtil.isNotEmpty((Object)materialArchivesQuery.getMaterialNumber()), MaterialArchivesDO::getMaterialNumber, (Object)materialArchivesQuery.getMaterialNumber())).like(ObjectUtil.isNotEmpty((Object)materialArchivesQuery.getMaterialSpecification()), MaterialArchivesDO::getMaterialSpecification, (Object)materialArchivesQuery.getMaterialSpecification())).orderByDesc(MaterialArchivesDO::getId);
        return wrapper;
    }

    public List<Long> getMaterialId(List<Long> submenuIds) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(ItemCategoryDO::getParentId, submenuIds);
        List submenuList = this.itemCategoryService.list((Wrapper)wrapper);
        if (!submenuList.isEmpty()) {
            List submenuId = submenuList.stream().map(ItemCategoryDO::getId).collect(Collectors.toList());
            return this.getMaterialId(submenuId);
        }
        return submenuIds;
    }

    public List<Long> getMaterialIds() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        List submenuList = this.itemCategoryService.list((Wrapper)wrapper);
        List<Long> submenuId = submenuList.stream().map(ItemCategoryDO::getId).collect(Collectors.toList());
        return submenuId;
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%04d", ++number);
    }

    public void chulishuju() {
        List list = this.list();
        for (MaterialArchivesDO materialArchivesDO : list) {
            MaterialArchivesDO up = new MaterialArchivesDO();
            up.setId(materialArchivesDO.getId());
            up.setMaterialNumber(this.getGenerateMaterialNumber(materialArchivesDO.getMaterialCategoryIdList()));
            this.updateById((Object)up);
        }
    }

    public String getGenerateMaterialNumber(String materialCategoryIdList) {
        List list = this.materialCategory(materialCategoryIdList);
        String type = "";
        type = list.size() >= 2 ? ChinesePinyin.getFirstLetterUpper((String)((String)list.get(0))) + "-" + ChinesePinyin.getFirstLetterUpper((String)((String)list.get(1))) : ChinesePinyin.getFirstLetterUpper((String)((String)list.get(0)));
        type = "YYWL-" + type + "-";
        Integer count = ((MaterialArchivesMapper)this.baseMapper).selectCountInToday(type);
        return type + String.format("%04d", count + 1);
    }

    public String getGenerateMaterialNumber1(String materialCategory) {
        String[] split = materialCategory.split(">>");
        String type = "";
        type = split.length >= 2 ? ChinesePinyin.getFirstLetterUpper((String)split[0]) + "-" + ChinesePinyin.getFirstLetterUpper((String)split[1]) : ChinesePinyin.getFirstLetterUpper((String)split[0]);
        type = "YYWL-" + type + "-";
        Integer count = ((MaterialArchivesMapper)this.baseMapper).selectCountInToday(type);
        return type + String.format("%04d", count + 1);
    }

    public List<String> materialCategory(String materialCategoryIdList) {
        List searchMenu = this.itemCategoryService.getSearchMenu();
        List name = JSON.parseArray((String)materialCategoryIdList, String.class);
        if (name.size() >= 2) {
            for (ItemCategoryVO menu : searchMenu) {
                if (!((String)name.get(0)).equals(menu.getId().toString())) continue;
                List authMenuList = menu.getAuthMenuList();
                for (ItemCategoryVO itemCategoryVO : authMenuList) {
                    if (!((String)name.get(1)).equals(itemCategoryVO.getId().toString())) continue;
                    return Arrays.asList(menu.getMenuName(), itemCategoryVO.getMenuName());
                }
            }
        } else {
            for (ItemCategoryVO menu : searchMenu) {
                if (!((String)name.get(0)).equals(menu.getId().toString())) continue;
                return Arrays.asList(menu.getMenuName());
            }
        }
        return Arrays.asList("", "");
    }

    public List<String> materialCategoryByName(String materialCategoryName, List<ItemCategoryVO> searchMenu) {
        String[] split = materialCategoryName.split(">>");
        ArrayList<String> ids = new ArrayList<String>();
        block0: for (int i = 0; i < split.length; ++i) {
            for (ItemCategoryVO menu : searchMenu) {
                if (!split[i].equals(menu.getMenuName())) continue;
                searchMenu = menu.getAuthMenuList();
                ids.add(menu.getId().toString());
                continue block0;
            }
        }
        return ids;
    }
}

