/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.entity.supply.MaterialsApplicationDemandDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationDemandImport;
import com.ruoyi.mapper.supply.MaterialsApplicationDemandDetailMapper;
import com.ruoyi.service.supply.MaterialsApplicationDemandDetailService;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.MaterialNameListVO;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MaterialsApplicationDemandDetailServiceImpl
extends ServiceImpl<MaterialsApplicationDemandDetailMapper, MaterialsApplicationDemandDetailDO>
implements MaterialsApplicationDemandDetailService {
    public Long getMaterialsApplicationDemandCount(Long id) {
        MaterialsApplicationDemandDetailDO materialsApplicationDemandDetailDO = (MaterialsApplicationDemandDetailDO)this.getById((Serializable)id);
        return materialsApplicationDemandDetailDO.getDemandCount();
    }

    public Long getMaterialsApplicationDeliveredCount(Long materialId) {
        return ((MaterialsApplicationDemandDetailMapper)this.baseMapper).querydeliveredCount(materialId);
    }

    public R importMaterialsApplication(MultipartFile file, SupplyUtils supplyUtils) {
        ExcelImportResult importResult;
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerify(true);
        try {
            importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), MaterialsApplicationDemandImport.class, (ImportParams)importParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List demandImportList = importResult.getList();
        ArrayList<MaterialsApplicationDemandDetailDO> list = new ArrayList<MaterialsApplicationDemandDetailDO>();
        if (ObjectUtil.isNotEmpty((Object)demandImportList)) {
            List materialNameListVOList = supplyUtils.getThreeLevelMaterialNameList();
            long count = demandImportList.stream().map(MaterialsApplicationDemandImport::getMaterialName).distinct().count();
            if (count != (long)demandImportList.size()) {
                return R.fail((String)"\u5b58\u5728\u7269\u8d44\u540d\u79f0\u91cd\u590d");
            }
            for (int i = 0; i < demandImportList.size(); ++i) {
                MaterialsApplicationDemandDetailDO detailDO = new MaterialsApplicationDemandDetailDO();
                MaterialsApplicationDemandImport demandImport = (MaterialsApplicationDemandImport)demandImportList.get(i);
                if (StringUtils.isBlank((CharSequence)demandImport.getMaterialName())) {
                    return R.fail((String)("\u7b2c" + (i + 2) + "\u884c\u7269\u8d44\u540d\u79f0\u65e0\u6570\u636e"));
                }
                String[] materialName = demandImport.getMaterialName().split(">>");
                List<String> materialNames = Arrays.asList(materialName);
                List materialList = materialNameListVOList;
                ArrayList<String> list1 = new ArrayList<String>();
                for (int j = 0; j < materialNames.size(); ++j) {
                    int finalJ = j;
                    MaterialNameListVO materialNameListVO = materialList.stream().filter(f -> ((String)materialNames.get(finalJ)).equals(f.getMaterialName())).findFirst().orElse(null);
                    if (ObjectUtil.isEmpty((Object)materialNameListVO)) {
                        return R.fail((String)("\u7b2c" + (i + 2) + "\u884c\u7269\u8d44\u540d\u79f0\u672a\u914d\u7f6e\u7cfb\u7edf\u6570\u636e"));
                    }
                    list1.add(materialNameListVO.getMaterialId().toString());
                    materialList = materialNameListVO.getMaterialNameListVOList();
                    if (j != materialNames.size() - 1) continue;
                    detailDO.setMaterialId(materialNameListVO.getMaterialId());
                    detailDO.setMaterialName(demandImport.getMaterialName());
                    detailDO.setMaterialIdLevel(JSON.toJSONString(list1));
                    detailDO.setMaterialSpecification(materialNameListVO.getMaterialSpecification());
                    detailDO.setUnit(materialNameListVO.getUnitMeasurement());
                    detailDO.setInventoryCount(materialNameListVO.getCurrentCount());
                }
                if (demandImport.getDemandCount() == null) {
                    return R.fail((String)("\u7b2c" + (i + 2) + "\u884c\u9700\u6c42\u91cf\u65e0\u6570\u636e"));
                }
                detailDO.setDemandCount(demandImport.getDemandCount());
                detailDO.setRemark(demandImport.getRemark());
                list.add(detailDO);
            }
            return R.ok(list);
        }
        return R.fail((String)"\u5bfc\u5165\u5931\u8d25");
    }
}

