/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.MaterialsApplicationMaterialOrderDTO;
import com.ruoyi.dto.supply.OutWarehouseManagementDemandDetailDTO;
import com.ruoyi.dto.supply.ProjectInformationDTO;
import com.ruoyi.entity.supply.InWarehouseManagementDO;
import com.ruoyi.entity.supply.InWarehouseManagementDetailDO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.entity.supply.MaterialsApplicationDemandDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationHandleDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationMaterialOrderDO;
import com.ruoyi.entity.supply.OutWarehouseManagementDO;
import com.ruoyi.entity.supply.OutWarehouseManagementDemandDetailDO;
import com.ruoyi.entity.supply.OutWarehouseManagementLogisticsInformationDO;
import com.ruoyi.entity.supply.PurchaseOrderDO;
import com.ruoyi.entity.supply.PurchaseOrderDemandDetailDO;
import com.ruoyi.entity.supply.PurchaseOrderLogisticsInformationDO;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.enums.supply.MaterialApplicationOperationStatusEnum;
import com.ruoyi.mapper.supply.InWarehouseManagementDetailMapper;
import com.ruoyi.mapper.supply.InWarehouseManagementMapper;
import com.ruoyi.mapper.supply.MaterialArchivesMapper;
import com.ruoyi.mapper.supply.MaterialsApplicationMaterialOrderMapper;
import com.ruoyi.mapper.supply.OutWarehouseManagementMapper;
import com.ruoyi.mapper.supply.PurchaseOrderMapper;
import com.ruoyi.query.supply.MaterialApplicationQuery;
import com.ruoyi.service.supply.MaterialArchivesService;
import com.ruoyi.service.supply.MaterialsApplicationDemandDetailService;
import com.ruoyi.service.supply.MaterialsApplicationHandleDetailService;
import com.ruoyi.service.supply.MaterialsApplicationMaterialOrderService;
import com.ruoyi.service.supply.OutWarehouseManagementDemandDetailService;
import com.ruoyi.service.supply.OutWarehouseManagementLogisticsInformationService;
import com.ruoyi.service.supply.PurchaseOrderDemandDetailService;
import com.ruoyi.service.supply.PurchaseOrderLogisticsInformationService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.service.supply.impl.MaterialsApplicationMaterialOrderServiceImpl;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.supply.MaterialsApplicationDetailVO;
import com.ruoyi.vo.supply.MaterialsApplicationExportVO;
import com.ruoyi.vo.supply.MaterialsApplicationHandleDetailVO;
import com.ruoyi.vo.supply.RelatedMaterialApplicationFormVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.util.HtmlUtils;

@Service
public class MaterialsApplicationMaterialOrderServiceImpl
extends ServiceImpl<MaterialsApplicationMaterialOrderMapper, MaterialsApplicationMaterialOrderDO>
implements MaterialsApplicationMaterialOrderService {
    private static final Logger log = LoggerFactory.getLogger(MaterialsApplicationMaterialOrderServiceImpl.class);
    @Resource
    private MaterialsApplicationDemandDetailService materialsApplicationDemandDetailService;
    @Resource
    private MaterialsApplicationHandleDetailService materialsApplicationHandleDetailService;
    @Resource
    private OutWarehouseManagementDemandDetailService outWarehouseManagementDemandDetailService;
    @Resource
    private PurchaseOrderLogisticsInformationService purchaseOrderLogisticsInformationService;
    @Resource
    private StockListService stockListService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private MaterialArchivesMapper materialArchivesMapper;
    @Resource
    private OutWarehouseManagementMapper outWarehouseManagementMapper;
    @Resource
    private PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    private PurchaseOrderDemandDetailService purchaseOrderDemandDetailService;
    @Resource
    private InWarehouseManagementMapper inWarehouseManagementMapper;
    @Resource
    private InWarehouseManagementDetailMapper inWarehouseManagementDetailMapper;
    @Resource
    private MaterialArchivesService materialArchivesService;
    @Resource
    private OutWarehouseManagementLogisticsInformationService outWarehouseManagementLogisticsInformationService;

    public R addMaterialsApplication(MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) throws Exception {
        LoginUser loginUser = UserUtils.getLoginUser();
        if (ObjectUtil.isEmpty((Object)loginUser)) {
            return R.fail((String)"\u7533\u8bf7\u5931\u8d25,\u767b\u5f55\u4eba\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38");
        }
        SysUser sysUser = loginUser.getSysUser();
        if (ObjectUtil.isEmpty((Object)sysUser) || ObjectUtil.isEmpty((Object)sysUser.getDeptId())) {
            return R.fail((String)"\u7533\u8bf7\u5931\u8d25,\u767b\u5f55\u4eba\u90e8\u95e8\u83b7\u53d6\u5f02\u5e38");
        }
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = new MaterialsApplicationMaterialOrderDO();
        BeanUtil.copyProperties((Object)materialsApplicationMaterialOrderDTO, (Object)materialsApplicationMaterialOrderDO, (String[])new String[0]);
        String materialsNumber = this.getMaterialsNumber();
        materialsApplicationMaterialOrderDO.setItemRequisitionNumber(materialsNumber);
        if (StringUtils.isNotEmpty((CharSequence)materialsApplicationMaterialOrderDTO.getCity())) {
            materialsApplicationMaterialOrderDO.setCity(materialsApplicationMaterialOrderDTO.getCity().toString());
        }
        materialsApplicationMaterialOrderDO.setAddress(materialsApplicationMaterialOrderDTO.getAddress().toString());
        materialsApplicationMaterialOrderDO.setCreateTime(new Date());
        materialsApplicationMaterialOrderDO.setUpdateTime(new Date());
        materialsApplicationMaterialOrderDO.setIsDeleted(Integer.valueOf(0));
        materialsApplicationMaterialOrderDO.setCurrentProgress("\u7b49\u5f85\u5ba1\u6279");
        materialsApplicationMaterialOrderDO.setOperatingStatus(MaterialApplicationOperationStatusEnum.approval.getMsg());
        ThemeUtils themes = new ThemeUtils();
        materialsApplicationMaterialOrderDO.setSubjectName(ThemeUtils.getThemeName((String)"\u7269\u8d44\u7533\u8bf7"));
        this.save((Object)materialsApplicationMaterialOrderDO);
        this.saveMaterialsApplicationDemandDetail(materialsApplicationMaterialOrderDTO, materialsNumber);
        this.saveMaterialsApplicationHandleDetail(materialsNumber);
        ProcessDTO processDTO = new ProcessDTO();
        processDTO.setProcessInstanceName(materialsApplicationMaterialOrderDO.getSubjectName());
        HashMap<String, Long> stringStringHashMap = new HashMap<String, Long>();
        stringStringHashMap.put("deptId", sysUser.getDeptId());
        processDTO.setFormData(stringStringHashMap);
        processDTO.setProjectName(materialsApplicationMaterialOrderDO.getProjectName());
        processDTO.setBusinessKey(materialsApplicationMaterialOrderDO.getId().toString());
        String processId = this.workFlowService.startProcess(ProcessEnum.survey, processDTO, new Object[]{materialsApplicationMaterialOrderDO.getId().toString()});
        if (ObjectUtil.isNotEmpty((Object)processId)) {
            materialsApplicationMaterialOrderDO.setProcessInstId(processId);
            this.updateById((Object)materialsApplicationMaterialOrderDO);
        }
        System.out.println(processId);
        return R.ok((Object)"\u7533\u8bf7\u6210\u529f");
    }

    private void saveMaterialsApplicationHandleDetail(String materialsNumber) {
        if (ObjectUtil.isEmpty((Object)materialsNumber)) {
            return;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationMaterialOrderDO::getItemRequisitionNumber, (Object)materialsNumber);
        List materialsApplicationMaterialOrderDO = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDO)) {
            return;
        }
        Long mainId = ((MaterialsApplicationMaterialOrderDO)materialsApplicationMaterialOrderDO.get(0)).getId();
        MaterialsApplicationHandleDetailDO materialsApplicationHandleDetailDO = new MaterialsApplicationHandleDetailDO();
        materialsApplicationHandleDetailDO.setMainId(mainId);
        materialsApplicationHandleDetailDO.setMaterialApplicationNumber(materialsNumber);
        materialsApplicationHandleDetailDO.setCreateTime(new Date());
        materialsApplicationHandleDetailDO.setUpdateTime(new Date());
        materialsApplicationHandleDetailDO.setIsDeleted(Integer.valueOf(0));
        materialsApplicationHandleDetailDO.setHandleTime(new Date());
        this.materialsApplicationHandleDetailService.save((Object)materialsApplicationHandleDetailDO);
    }

    private void saveMaterialsApplicationDemandDetail(MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO, String materialsNumber) {
        List demandDetailDTOList = materialsApplicationMaterialOrderDTO.getDemandDetailDTOList();
        if (ObjectUtil.isEmpty((Object)demandDetailDTOList) || ObjectUtil.isEmpty((Object)materialsNumber)) {
            return;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationMaterialOrderDO::getItemRequisitionNumber, (Object)materialsNumber)).orderByDesc(MaterialsApplicationMaterialOrderDO::getCreateTime);
        List materialsApplicationMaterialOrderDOList = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDOList)) {
            return;
        }
        Long mainId = ((MaterialsApplicationMaterialOrderDO)materialsApplicationMaterialOrderDOList.get(0)).getId();
        List materialsApplicationDemandDetailDOList = demandDetailDTOList.stream().map(m -> {
            MaterialsApplicationDemandDetailDO materialsApplicationDemandDetailDO = new MaterialsApplicationDemandDetailDO();
            BeanUtils.copyProperties((Object)m, (Object)materialsApplicationDemandDetailDO);
            MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)m.getMaterialId());
            materialsApplicationDemandDetailDO.setPrice(materialArchivesDO.getReferencePrice());
            materialsApplicationDemandDetailDO.setMainId(mainId);
            materialsApplicationDemandDetailDO.setIsDeleted(Integer.valueOf(0));
            materialsApplicationDemandDetailDO.setCreateTime(new Date());
            materialsApplicationDemandDetailDO.setUpdateTime(new Date());
            materialsApplicationDemandDetailDO.setDeliveredCount(Long.valueOf(0L));
            materialsApplicationDemandDetailDO.setOutstandingCount(materialsApplicationDemandDetailDO.getDemandCount());
            materialArchivesDO.setMaterialName(HtmlUtils.htmlUnescape((String)m.getMaterialName()));
            return materialsApplicationDemandDetailDO;
        }).collect(Collectors.toList());
        this.materialsApplicationDemandDetailService.saveBatch(materialsApplicationDemandDetailDOList);
    }

    public MaterialsApplicationDetailVO getMaterialsApplicationDetail(Long id) {
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.getById((Serializable)id);
        MaterialsApplicationDetailVO materialsApplicationDetailVO = new MaterialsApplicationDetailVO();
        BeanUtil.copyProperties((Object)materialsApplicationMaterialOrderDO, (Object)materialsApplicationDetailVO, (String[])new String[0]);
        LambdaQueryWrapper materialsApplicationDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationDemandDetailDO::getMainId, (Object)id);
        List materialsApplicationDemandDetailDOList = this.materialsApplicationDemandDetailService.list((Wrapper)materialsApplicationDemandDetailDOLambdaQueryWrapper);
        materialsApplicationDetailVO.setMaterialsApplicationDemandDetailDOList(materialsApplicationDemandDetailDOList);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationHandleDetailDO::getMainId, (Object)materialsApplicationMaterialOrderDO.getId());
        List materialsApplicationHandleDetailDOList = this.materialsApplicationHandleDetailService.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationHandleDetailDOList)) {
            List materialsApplicationHandleDetailVOList = materialsApplicationHandleDetailDOList.stream().map(m -> {
                MaterialsApplicationHandleDetailVO materialsApplicationHandleDetailVO = new MaterialsApplicationHandleDetailVO();
                BeanUtils.copyProperties((Object)m, (Object)materialsApplicationHandleDetailVO);
                return materialsApplicationHandleDetailVO;
            }).collect(Collectors.toList());
            materialsApplicationHandleDetailVOList = materialsApplicationHandleDetailVOList.stream().filter(f -> ObjectUtil.isNotEmpty((Object)f.getHandleTime())).sorted(Comparator.comparing(MaterialsApplicationHandleDetailVO::getHandleTime, Comparator.naturalOrder())).collect(Collectors.toList());
            materialsApplicationDetailVO.setMaterialsApplicationHandleDetailVOList(materialsApplicationHandleDetailVOList);
            return materialsApplicationDetailVO;
        }
        return materialsApplicationDetailVO;
    }

    public MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO(MaterialApplicationQuery materialApplicationQuery) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(MaterialsApplicationMaterialOrderDO::getApplicant, (Object)materialApplicationQuery.getApplicant());
        wrapper.orderByDesc(MaterialsApplicationMaterialOrderDO::getCreateTime);
        wrapper.last("LIMIT 1");
        return (MaterialsApplicationMaterialOrderDO)this.getOne((Wrapper)wrapper);
    }

    public MaterialsApplicationDetailVO getMaterialsApplicationDetailNew(Long id) {
        List purchaseOrderDOList;
        List list;
        List listb;
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.getById((Serializable)id);
        MaterialsApplicationDetailVO materialsApplicationDetailVO = new MaterialsApplicationDetailVO();
        BeanUtil.copyProperties((Object)materialsApplicationMaterialOrderDO, (Object)materialsApplicationDetailVO, (String[])new String[0]);
        LambdaQueryWrapper materialsApplicationDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationDemandDetailDO::getMainId, (Object)id);
        List materialsApplicationDemandDetailDOList = this.materialsApplicationDemandDetailService.list((Wrapper)materialsApplicationDemandDetailDOLambdaQueryWrapper);
        materialsApplicationDetailVO.setMaterialsApplicationDemandDetailDOList(materialsApplicationDemandDetailDOList);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationHandleDetailDO::getMainId, (Object)materialsApplicationMaterialOrderDO.getId());
        List materialsApplicationHandleDetailDOList = this.materialsApplicationHandleDetailService.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationHandleDetailDOList)) {
            List materialsApplicationHandleDetailVOList = materialsApplicationHandleDetailDOList.stream().map(m -> {
                MaterialsApplicationHandleDetailVO materialsApplicationHandleDetailVO = new MaterialsApplicationHandleDetailVO();
                BeanUtils.copyProperties((Object)m, (Object)materialsApplicationHandleDetailVO);
                return materialsApplicationHandleDetailVO;
            }).collect(Collectors.toList());
            materialsApplicationHandleDetailVOList = materialsApplicationHandleDetailVOList.stream().filter(f -> ObjectUtil.isNotEmpty((Object)f.getHandleTime())).sorted(Comparator.comparing(MaterialsApplicationHandleDetailVO::getHandleTime, Comparator.naturalOrder())).collect(Collectors.toList());
            materialsApplicationDetailVO.setMaterialsApplicationHandleDetailVOList(materialsApplicationHandleDetailVOList);
        }
        if (ObjectUtil.isNotEmpty((Object)(listb = this.outWarehouseManagementMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDO::getRelatedMaterialApplicationFormId, (Object)materialsApplicationDetailVO.getId())).eq(OutWarehouseManagementDO::getStatus, (Object)1))))) {
            for (Object outWarehouseManagementDO : listb) {
                List outWarehouseManagementDemandDetailDOList = this.outWarehouseManagementDemandDetailService.list((Wrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDemandDetailDO::getMainId, (Object)outWarehouseManagementDO.getId()));
                outWarehouseManagementDemandDetailDOList.forEach(a -> {
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)a.getMaterialId());
                    a.setMaterialSpecification(materialArchivesDO.getMaterialSpecification());
                });
                List list2 = this.outWarehouseManagementLogisticsInformationService.list((Wrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementLogisticsInformationDO::getMainId, (Object)outWarehouseManagementDO.getId()));
                outWarehouseManagementDO.setOutWarehouseManagementLogisticsInformationDOList(list2);
                outWarehouseManagementDO.setOutWarehouseManagementDemandDetailDOList(outWarehouseManagementDemandDetailDOList);
            }
            materialsApplicationDetailVO.setOutWarehouseManagementDOListTwo(listb);
        }
        if (ObjectUtil.isNotEmpty((Object)(list = this.outWarehouseManagementMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDO::getRelatedMaterialApplicationFormId, (Object)materialsApplicationDetailVO.getId())).eq(OutWarehouseManagementDO::getStatus, (Object)0))))) {
            for (Object outWarehouseManagementDO : list) {
                List outWarehouseManagementDemandDetailDOList = this.outWarehouseManagementDemandDetailService.list((Wrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDemandDetailDO::getMainId, (Object)outWarehouseManagementDO.getId()));
                outWarehouseManagementDemandDetailDOList.forEach(a -> {
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)a.getMaterialId());
                    a.setMaterialSpecification(materialArchivesDO.getMaterialSpecification());
                });
                List list1 = this.outWarehouseManagementLogisticsInformationService.list((Wrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementLogisticsInformationDO::getMainId, (Object)outWarehouseManagementDO.getId()));
                outWarehouseManagementDO.setOutWarehouseManagementLogisticsInformationDOList(list1);
                outWarehouseManagementDO.setOutWarehouseManagementDemandDetailDOList(outWarehouseManagementDemandDetailDOList);
            }
            materialsApplicationDetailVO.setOutWarehouseManagementDOList(list);
        }
        if (ObjectUtil.isNotEmpty((Object)(purchaseOrderDOList = this.purchaseOrderMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(PurchaseOrderDO::getAssociatedMaterialApplicationOrderId, (Object)materialsApplicationDetailVO.getId()))))) {
            for (PurchaseOrderDO purchaseOrderDO : purchaseOrderDOList) {
                List purchaseOrderDemandDetailDOList = this.purchaseOrderDemandDetailService.list((Wrapper)new LambdaQueryWrapper().eq(PurchaseOrderDemandDetailDO::getMainId, (Object)purchaseOrderDO.getId()));
                purchaseOrderDO.setPurchaseOrderDemandDetailDOList(purchaseOrderDemandDetailDOList);
                List list1 = this.purchaseOrderLogisticsInformationService.list((Wrapper)new LambdaQueryWrapper().eq(PurchaseOrderLogisticsInformationDO::getMainId, (Object)purchaseOrderDO.getId()));
                purchaseOrderDO.setPurchaseOrderLogisticsInformationDOList(list1);
                purchaseOrderDemandDetailDOList.forEach(a -> {
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)a.getMaterialId());
                    a.setMaterialSpecifications(materialArchivesDO.getMaterialSpecification());
                });
            }
        }
        materialsApplicationDetailVO.setPurchaseOrderDOList(purchaseOrderDOList);
        List inWarehouseManagementDOList = this.inWarehouseManagementMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(InWarehouseManagementDO::getMaterialOrderId, (Object)id));
        if (ObjectUtil.isNotEmpty((Object)purchaseOrderDOList)) {
            for (InWarehouseManagementDO inWarehouseManagementDO : inWarehouseManagementDOList) {
                List inWarehouseManagementDetailDOList = this.inWarehouseManagementDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(InWarehouseManagementDetailDO::getMainId, (Object)inWarehouseManagementDO.getId()));
                inWarehouseManagementDO.setWarehouseManagementDetailDOList(inWarehouseManagementDetailDOList);
                inWarehouseManagementDetailDOList.forEach(a -> {
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)a.getMaterialId());
                    a.setMaterialSpecifications(materialArchivesDO.getMaterialSpecification());
                });
            }
            materialsApplicationDetailVO.setInWarehouseManagementDOList(inWarehouseManagementDOList);
        }
        return materialsApplicationDetailVO;
    }

    public PageResultVo<MaterialsApplicationDetailVO> getMaterialsApplicationListPage(MaterialApplicationQuery materialApplicationQuery) {
        LambdaQueryWrapper wrapper = this.getWrapper(materialApplicationQuery);
        Page page = (Page)this.page((IPage)new Page((long)materialApplicationQuery.getPageNum(), (long)materialApplicationQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo materialsApplicationDetailVOPageResultVo = new PageResultVo();
        ArrayList<MaterialsApplicationDetailVO> materialArchivesVOList = new ArrayList<MaterialsApplicationDetailVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO : resultVo.getData()) {
                MaterialsApplicationDetailVO materialsApplicationDetailVO = new MaterialsApplicationDetailVO();
                BeanUtils.copyProperties((Object)materialsApplicationMaterialOrderDO, (Object)materialsApplicationDetailVO);
                materialArchivesVOList.add(materialsApplicationDetailVO);
            }
        }
        materialsApplicationDetailVOPageResultVo.setData(materialArchivesVOList);
        materialsApplicationDetailVOPageResultVo.setPageSize(resultVo.getPageSize());
        materialsApplicationDetailVOPageResultVo.setPageNum(resultVo.getPageNum());
        materialsApplicationDetailVOPageResultVo.setTotal(resultVo.getTotal());
        materialsApplicationDetailVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return materialsApplicationDetailVOPageResultVo;
    }

    public void exportMaterialsApplicationList(MaterialApplicationQuery materialApplicationQuery, HttpServletResponse response) throws IOException {
        List<Object> materialsApplicationExportVOList = new ArrayList();
        LambdaQueryWrapper wrapper = this.getWrapper(materialApplicationQuery);
        List materialsApplicationMaterialOrderDOList = this.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationMaterialOrderDOList)) {
            materialsApplicationExportVOList = materialsApplicationMaterialOrderDOList.stream().map(materialsApplicationMaterialOrderDO -> {
                MaterialsApplicationExportVO materialsApplicationExportVO = new MaterialsApplicationExportVO();
                BeanUtils.copyProperties((Object)materialsApplicationMaterialOrderDO, (Object)materialsApplicationExportVO);
                return materialsApplicationExportVO;
            }).collect(Collectors.toList());
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u5b9e\u7269\u7269\u8d44\u7533\u8bf7", "\u5b9e\u7269\u7269\u8d44\u7533\u8bf7", ExcelType.XSSF), MaterialsApplicationExportVO.class, materialsApplicationExportVOList);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u5b9e\u7269\u7269\u8d44\u7533\u8bf7-" + dateFormat.format(date)));
    }

    public List<String> getApplicationDepartment() {
        List materialsApplicationMaterialOrderDOList = this.list();
        if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDOList)) {
            return null;
        }
        List<String> applicationDepartmentList = materialsApplicationMaterialOrderDOList.stream().map(m -> m.getDepartment()).collect(Collectors.toSet()).stream().collect(Collectors.toList());
        return applicationDepartmentList;
    }

    public void cancelApplication(Long id) {
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.getById((Serializable)id);
        materialsApplicationMaterialOrderDO.setUpdateTime(new Date());
        materialsApplicationMaterialOrderDO.setCurrentProgress("\u5df2\u53d6\u6d88");
        this.updateById((Object)materialsApplicationMaterialOrderDO);
    }

    public List<String> getLinkProject() {
        List materialsApplicationMaterialOrderDOList = this.list();
        return materialsApplicationMaterialOrderDOList.stream().map(MaterialsApplicationMaterialOrderDO::getProjectName).collect(Collectors.toList()).stream().distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public MaterialsApplicationMaterialOrderDO getMaterialApplicationProjectHandleDTOByProcessInstanceId(String processInstanceId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationMaterialOrderDO::getMaterialApplicationFormTaskId, (Object)processInstanceId);
        List materialsApplicationMaterialOrderDOList = this.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationMaterialOrderDOList) && materialsApplicationMaterialOrderDOList.size() > 0) {
            return (MaterialsApplicationMaterialOrderDO)materialsApplicationMaterialOrderDOList.get(0);
        }
        return null;
    }

    public void executiveApproval(MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.getById((Serializable)materialsApplicationMaterialOrderDTO.getId());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationHandleDetailDO::getMainId, (Object)materialsApplicationMaterialOrderDTO.getId())).orderByAsc(MaterialsApplicationHandleDetailDO::getCreateTime);
        List materialsApplicationHandleDetailDOList = this.materialsApplicationHandleDetailService.list((Wrapper)wrapper);
        MaterialsApplicationHandleDetailDO materialsApplicationHandleDetailDO = new MaterialsApplicationHandleDetailDO();
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationHandleDetailDOList)) {
            materialsApplicationHandleDetailDO = (MaterialsApplicationHandleDetailDO)materialsApplicationHandleDetailDOList.get(0);
        }
        if (materialsApplicationMaterialOrderDTO.getApproveStatus().equals("approve")) {
            materialsApplicationMaterialOrderDO.setCurrentProgress("\u5df2\u5b8c\u6210");
            materialsApplicationMaterialOrderDO.setOperatingStatus("query");
            if (ObjectUtil.isNotEmpty((Object)materialsApplicationHandleDetailDO)) {
                materialsApplicationHandleDetailDO.setHandleTime(new Date());
                materialsApplicationHandleDetailDO.setHandleInformation("\u7269\u8d44\u7533\u8bf7\u5ba1\u6279\u901a\u8fc7\uff0c\u6d41\u8f6c\u81f3\u4ed3\u5e93\u8fdb\u884c\u51fa\u5e93");
            }
        }
        if (materialsApplicationMaterialOrderDTO.getApproveStatus().equals("reject")) {
            materialsApplicationMaterialOrderDO.setCurrentProgress("\u88ab\u9a73\u56de");
            materialsApplicationMaterialOrderDO.setOperatingStatus("editor");
            if (ObjectUtil.isNotEmpty((Object)materialsApplicationHandleDetailDO)) {
                materialsApplicationHandleDetailDO.setHandleTime(new Date());
                materialsApplicationHandleDetailDO.setHandleInformation("\u7269\u8d44\u7533\u8bf7\u88ab\u9a73\u56de\uff0c\u9a73\u56de\u539f\u56e0\uff1a" + materialsApplicationMaterialOrderDTO.getRejectReason());
            }
        }
        materialsApplicationMaterialOrderDO.setUpdateTime(new Date());
        this.updateById((Object)materialsApplicationMaterialOrderDO);
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationHandleDetailDO)) {
            materialsApplicationHandleDetailDO.setUpdateTime(new Date());
            this.materialsApplicationHandleDetailService.updateById((Object)materialsApplicationHandleDetailDO);
        }
    }

    public void edtiorMaterialsApplication(MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.getById((Serializable)materialsApplicationMaterialOrderDTO.getId());
        BeanUtils.copyProperties((Object)materialsApplicationMaterialOrderDTO, (Object)materialsApplicationMaterialOrderDO);
        materialsApplicationMaterialOrderDO.setUpdateTime(new Date());
        this.materialsApplicationDemandDetailService.remove((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)materialsApplicationMaterialOrderDTO.getId()));
        List demandDetailDTOList = materialsApplicationMaterialOrderDTO.getDemandDetailDTOList();
        List materialsApplicationDemandDetailDOList = demandDetailDTOList.stream().map(m -> {
            MaterialsApplicationDemandDetailDO materialsApplicationDemandDetailDO = new MaterialsApplicationDemandDetailDO();
            BeanUtils.copyProperties((Object)m, (Object)materialsApplicationDemandDetailDO);
            materialsApplicationDemandDetailDO.setMainId(materialsApplicationMaterialOrderDTO.getId());
            materialsApplicationDemandDetailDO.setIsDeleted(Integer.valueOf(0));
            materialsApplicationDemandDetailDO.setCreateTime(new Date());
            return materialsApplicationDemandDetailDO;
        }).collect(Collectors.toList());
        this.materialsApplicationDemandDetailService.saveBatch(materialsApplicationDemandDetailDOList);
        this.updateById((Object)materialsApplicationMaterialOrderDO);
    }

    public List<RelatedMaterialApplicationFormVO> getRelatedMaterialApplicationFormList(MaterialsApplicationMaterialOrderDO materialOrderDO) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().or(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(MaterialsApplicationMaterialOrderDO::getCurrentProgress, (Object)"\u5ba1\u6279\u901a\u8fc7")).or()).like(MaterialsApplicationMaterialOrderDO::getCurrentProgress, (Object)"\u90e8\u5206\u51fa\u5e93"))).eq(StringUtils.isNotBlank((CharSequence)materialOrderDO.getProjectCode()), MaterialsApplicationMaterialOrderDO::getProjectCode, (Object)materialOrderDO.getProjectCode())).orderByDesc(MaterialsApplicationMaterialOrderDO::getCreateTime);
        List materialsApplicationMaterialOrderDOList = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDOList)) {
            return null;
        }
        List<RelatedMaterialApplicationFormVO> relatedMaterialApplicationFormVOList = materialsApplicationMaterialOrderDOList.stream().map(m -> {
            RelatedMaterialApplicationFormVO relatedMaterialApplicationFormVO = new RelatedMaterialApplicationFormVO();
            relatedMaterialApplicationFormVO.setRelatedMaterialApplicationForm(m.getSubjectName());
            relatedMaterialApplicationFormVO.setRelatedMaterialApplicationFormId(m.getId());
            relatedMaterialApplicationFormVO.setRequestDate(m.getDemandDate());
            relatedMaterialApplicationFormVO.setAddress(m.getAddress());
            relatedMaterialApplicationFormVO.setAddressDetail(m.getAddressDetail());
            relatedMaterialApplicationFormVO.setRecipient(m.getRecipient());
            relatedMaterialApplicationFormVO.setRecipientNumber(m.getRecipientPhoneNumber());
            LambdaQueryWrapper materialsApplicationDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationDemandDetailDO::getMainId, (Object)m.getId());
            List materialsApplicationDemandDetailDOList = this.materialsApplicationDemandDetailService.list((Wrapper)materialsApplicationDemandDetailDOLambdaQueryWrapper);
            if (ObjectUtil.isNotEmpty((Object)materialsApplicationDemandDetailDOList)) {
                List outWarehouseManagementDemandDetailDTOS = materialsApplicationDemandDetailDOList.stream().map(materialsApplicationDemandDetailDO -> {
                    OutWarehouseManagementDemandDetailDTO outWarehouseManagementDemandDetailDTO = new OutWarehouseManagementDemandDetailDTO();
                    BeanUtils.copyProperties((Object)materialsApplicationDemandDetailDO, (Object)outWarehouseManagementDemandDetailDTO);
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)materialsApplicationDemandDetailDO.getMaterialId());
                    if (ObjectUtil.isNotEmpty((Object)materialArchivesDO)) {
                        outWarehouseManagementDemandDetailDTO.setOneYardPerObject(materialArchivesDO.getOneYardPerObject());
                    }
                    outWarehouseManagementDemandDetailDTO.setDeliveredCount(materialsApplicationDemandDetailDO.getDeliveredCount());
                    StockListDO one = (StockListDO)this.stockListService.getOne((Wrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)materialsApplicationDemandDetailDO.getMaterialId()));
                    if (ObjectUtil.isNotEmpty((Object)one)) {
                        outWarehouseManagementDemandDetailDTO.setInventoryCount(one.getCurrentStock());
                    } else {
                        outWarehouseManagementDemandDetailDTO.setInventoryCount(Long.valueOf(0L));
                    }
                    outWarehouseManagementDemandDetailDTO.setOutstandingCount(materialsApplicationDemandDetailDO.getOutstandingCount());
                    return outWarehouseManagementDemandDetailDTO;
                }).collect(Collectors.toList());
                relatedMaterialApplicationFormVO.setOutWarehouseManagementDemandDetailDTOList(outWarehouseManagementDemandDetailDTOS);
            }
            return relatedMaterialApplicationFormVO;
        }).collect(Collectors.toList());
        return relatedMaterialApplicationFormVOList;
    }

    public void workFromCallBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        MaterialsApplicationMaterialOrderDO byId = (MaterialsApplicationMaterialOrderDO)this.getById((Serializable)((Object)callBackVO.getBody().getBusinessKey()));
        switch (1.$SwitchMap$com$ruoyi$vo$supply$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Map taskVariables = callBackVO.getBody().getTaskVariables();
                if (taskVariables.size() <= 0) break;
                Integer approveStatus = (Integer)taskVariables.get("approveStatus");
                if (2 == approveStatus) {
                    byId.setCurrentProgress("\u7b49\u5f85\u5ba1\u6279");
                    this.updateById((Object)byId);
                    break;
                }
                if (4 != approveStatus) break;
                byId.setCurrentProgress("\u5df2\u53d6\u6d88");
                this.updateById((Object)byId);
                break;
            }
            case 3: {
                byId.setCurrentProgress("\u7b49\u5f85\u5ba1\u6279");
                this.updateById((Object)byId);
                break;
            }
            case 4: {
                byId.setCurrentProgress("\u5df2\u53d6\u6d88");
                this.updateById((Object)byId);
                break;
            }
            case 5: {
                MaterialsApplicationMaterialOrderDO byIds = (MaterialsApplicationMaterialOrderDO)this.getById((Serializable)((Object)callBackVO.getBody().getBusinessKey()));
                if (byIds.getCurrentProgress().equals("\u5df2\u53d6\u6d88")) break;
                byId.setCurrentProgress("\u5ba1\u6279\u901a\u8fc7");
                this.updateById((Object)byId);
            }
        }
    }

    public void updateCurrentProgress(Long relatedMaterialApplicationFormId, String currentProgress) {
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.getById((Serializable)relatedMaterialApplicationFormId);
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationMaterialOrderDO)) {
            materialsApplicationMaterialOrderDO.setCurrentProgress(currentProgress);
            this.updateById((Object)materialsApplicationMaterialOrderDO);
        }
    }

    public List<MaterialsApplicationMaterialOrderDTO> getRelationMaterialApplication(ProjectInformationDTO projectInformationDTO) {
        String projectCode = projectInformationDTO.getProjectCode();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialsApplicationMaterialOrderDO::getProjectCode, (Object)projectCode);
        wrapper.eq(MaterialsApplicationMaterialOrderDO::getCurrentProgress, (Object)"\u5ba1\u6279\u901a\u8fc7");
        wrapper.orderByDesc(MaterialsApplicationMaterialOrderDO::getCreateTime);
        List materialsApplicationMaterialOrderDOList = this.list((Wrapper)wrapper);
        List<Object> newMaterialsApplicationMaterialOrderDTOList = new ArrayList<MaterialsApplicationMaterialOrderDTO>();
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationMaterialOrderDOList)) {
            newMaterialsApplicationMaterialOrderDTOList = materialsApplicationMaterialOrderDOList.stream().map(m -> {
                Long id = m.getId();
                MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO = new MaterialsApplicationMaterialOrderDTO();
                BeanUtils.copyProperties((Object)m, (Object)materialsApplicationMaterialOrderDTO);
                LambdaQueryWrapper materialsApplicationDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationDemandDetailDO::getMainId, (Object)id);
                List materialsApplicationDemandDetailDOList = this.materialsApplicationDemandDetailService.list((Wrapper)materialsApplicationDemandDetailDOLambdaQueryWrapper);
                materialsApplicationDemandDetailDOList = materialsApplicationDemandDetailDOList.stream().map(m1 -> {
                    MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesMapper.selectById((Serializable)m1.getMaterialId());
                    if (ObjectUtil.isNotEmpty((Object)materialArchivesDO)) {
                        m1.setSupplier(materialArchivesDO.getAssociatedSupplier());
                    }
                    return m1;
                }).collect(Collectors.toList());
                materialsApplicationMaterialOrderDTO.setMaterialsApplicationDemandDetailDOList(materialsApplicationDemandDetailDOList);
                return materialsApplicationMaterialOrderDTO;
            }).collect(Collectors.toList());
            return newMaterialsApplicationMaterialOrderDTOList;
        }
        return newMaterialsApplicationMaterialOrderDTOList;
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString);
        return String.format("%03d", ++number);
    }

    public String getMaterialsNumber() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String formatDate = simpleDateFormat.format(date);
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(MaterialsApplicationMaterialOrderDO::getItemRequisitionNumber, (Object)("WZSQ-" + formatDate))).orderByDesc(MaterialsApplicationMaterialOrderDO::getCreateTime);
        if (ObjectUtil.isEmpty((Object)this.list((Wrapper)eq))) {
            return "WZSQ-" + formatDate + "-001";
        }
        String itemRequisitionNumber = ((MaterialsApplicationMaterialOrderDO)this.list((Wrapper)eq).get(0)).getItemRequisitionNumber();
        String[] number = itemRequisitionNumber.split("-");
        String threeNumber = this.incrementString(number[4]);
        return "WZSQ-" + formatDate + "-" + threeNumber;
    }

    public LambdaQueryWrapper getWrapper(MaterialApplicationQuery materialApplicationQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)materialApplicationQuery.getItemRequisitionNumber()), MaterialsApplicationMaterialOrderDO::getItemRequisitionNumber, (Object)materialApplicationQuery.getItemRequisitionNumber())).like(ObjectUtil.isNotEmpty((Object)materialApplicationQuery.getProject()), MaterialsApplicationMaterialOrderDO::getProjectName, (Object)materialApplicationQuery.getProject())).like(ObjectUtil.isNotEmpty((Object)materialApplicationQuery.getApplicant()), MaterialsApplicationMaterialOrderDO::getApplicant, (Object)materialApplicationQuery.getApplicant())).eq(ObjectUtil.isNotEmpty((Object)materialApplicationQuery.getDepartment()), MaterialsApplicationMaterialOrderDO::getDepartment, (Object)materialApplicationQuery.getDepartment())).eq(ObjectUtil.isNotEmpty((Object)materialApplicationQuery.getApplicationType()), MaterialsApplicationMaterialOrderDO::getApplicationType, (Object)materialApplicationQuery.getApplicationType())).ge(ObjectUtil.isNotEmpty((Object)materialApplicationQuery.getStartTime()), MaterialsApplicationMaterialOrderDO::getApplicationDate, (Object)materialApplicationQuery.getStartTime())).le(ObjectUtil.isNotEmpty((Object)materialApplicationQuery.getEndTime()), MaterialsApplicationMaterialOrderDO::getApplicationDate, (Object)materialApplicationQuery.getEndTime())).orderByDesc(MaterialsApplicationMaterialOrderDO::getCreateTime);
        return wrapper;
    }
}

