/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.workFlow.impl;

import com.alibaba.fastjson.JSONObject;
import com.ruoyi.feignClientApi.WorkFlowClient;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.service.workFlow.impl.JsonRootDTO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkFlowServiceImpl
implements WorkFlowService {
    private static final Logger log = LoggerFactory.getLogger(WorkFlowServiceImpl.class);
    @Resource
    private WorkFlowClient workFlowClient;

    @Transactional(rollbackFor={Exception.class})
    public String startProcess(ProcessEnum processEnum, ProcessDTO processDTO, Object ... urlParams) throws Exception {
        processDTO.setProcessDefinitionKey(processEnum.getProcessDefinitionKey());
        if (urlParams != null) {
            processDTO.setFormUrl(String.format(processEnum.getFormUrl(), urlParams));
        }
        log.info("WorkFlowServiceImpl-startProcess:Parameter:{}", (Object)processDTO);
        JSONObject jsonObject = this.workFlowClient.startProcessInstance(processDTO);
        log.info("WorkFlowServiceImpl-startProcess:Result:{}", (Object)jsonObject);
        String code = jsonObject.getString("code");
        if (!"0".equals(code)) {
            throw new Exception(jsonObject.getString("msg"));
        }
        JSONObject data = jsonObject.getJSONObject("data");
        return data.getString("id");
    }

    @Transactional(rollbackFor={Exception.class})
    public String startProcessTwo(ProcessDTO processDTO) throws Exception {
        log.info("WorkFlowServiceImpl-startProcess:Parameter:{}", (Object)processDTO);
        JSONObject jsonObject = this.workFlowClient.startProcessInstance(processDTO);
        log.info("WorkFlowServiceImpl-startProcess:Result:{}", (Object)jsonObject);
        String code = jsonObject.getString("code");
        if (!"0".equals(code)) {
            throw new Exception(jsonObject.getString("msg"));
        }
        JSONObject data = jsonObject.getJSONObject("data");
        return data.getString("id");
    }

    @Transactional(rollbackFor={Exception.class})
    public JSONObject pushUndoTask(ProcessEnum processEnum, JsonRootDTO jsonRootDTO, Object ... urlParams) {
        if (urlParams != null) {
            jsonRootDTO.setTargetUrl(String.format(processEnum.getFormUrl(), urlParams));
        }
        log.info("WorkFlowServiceImpl-pushUndoTask:Parameter:{}", (Object)jsonRootDTO);
        JSONObject jsonObject = this.workFlowClient.pushUndoTask(jsonRootDTO);
        log.info("WorkFlowServiceImpl-pushUndoTask:Result:{}", (Object)jsonObject);
        return jsonObject;
    }
}

