/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelToMap {
    public static List<Map<String, String>> readExcelToMap(String excelFilePath, int sheetIndex, int headerRowIndex) throws Exception {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(excelFilePath));
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        Row headerRow = sheet.getRow(headerRowIndex);
        int lastRowNum = sheet.getLastRowNum();
        for (int i = headerRowIndex + 1; i <= lastRowNum; ++i) {
            Row currentRow = sheet.getRow(i);
            if (currentRow == null) continue;
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (int j = 0; j < headerRow.getLastCellNum(); ++j) {
                Cell headerCell = headerRow.getCell(j);
                Cell currentCell = currentRow.getCell(j);
                if (headerCell == null || currentCell == null) continue;
                try {
                    String headerValue = headerCell.getStringCellValue();
                    String currentValue = currentCell.getStringCellValue();
                    dataMap.put(headerValue, currentValue);
                    continue;
                }
                catch (Exception e) {
                    String headerValue = headerCell.getStringCellValue();
                    double currentValue = currentCell.getNumericCellValue();
                    dataMap.put(headerValue, currentValue + "");
                }
            }
            list.add(dataMap);
        }
        workbook.close();
        return list;
    }
}

