/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.shaded.com.google.gson.Gson;
import com.ruoyi.dto.supply.KuaiDiCodeDTO;
import com.ruoyi.kuaidi100.request.QueryTrackParam;
import com.ruoyi.kuaidi100.utils.SignUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class KuaiDi100Utils {
    @Resource
    private RestTemplate restTemplate;
    private static final String AUTONUMBER_AUTO_URL = "http://www.kuaidi100.com/autonumber/auto?num=NUM&key=KEY";
    private static final String POLL_QUERY_URL = "https://poll.kuaidi100.com/poll/query.do";
    private static final String KEY = "ljpczvty6501";
    private static final String CUSTOMER = "E305A08BF58A638FF9E2D6318A1E5E0E";

    public List<KuaiDiCodeDTO> findKuaiDiCode(String orderId) {
        String url = AUTONUMBER_AUTO_URL.replace("NUM", orderId).replace("KEY", KEY);
        LinkedMultiValueMap sendBody = new LinkedMultiValueMap();
        sendBody.add((Object)"num", (Object)orderId);
        sendBody.add((Object)"key", (Object)KEY);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-type", "application/x-www-form-urlencoded");
        HttpEntity formEntity = new HttpEntity((Object)sendBody, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
        ArrayList<KuaiDiCodeDTO> kuaiDiCode = new ArrayList<KuaiDiCodeDTO>();
        String body1 = (String)result.getBody();
        if (result.getBody() != null && ((String)result.getBody()).length() > 0) {
            ArrayList body = (ArrayList)JSON.parseObject((String)((String)result.getBody()), ArrayList.class);
            body.forEach(i -> kuaiDiCode.add((KuaiDiCodeDTO)JSON.parseObject((String)JSON.toJSONString((Object)i), KuaiDiCodeDTO.class)));
        }
        return kuaiDiCode;
    }

    public String findOrder(String num, String com) throws Exception {
        QueryTrackParam queryTrackParam = new QueryTrackParam();
        String trackParam = new Gson().toJson((Object)queryTrackParam);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("com", com);
        param.put("num", num);
        String mgsData = JSON.toJSONString(param);
        LinkedMultiValueMap sendBody = new LinkedMultiValueMap();
        sendBody.add((Object)"customer", (Object)CUSTOMER);
        sendBody.add((Object)"sign", (Object)SignUtils.querySign((String)mgsData, (String)KEY, (String)CUSTOMER));
        sendBody.add((Object)"param", (Object)mgsData);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-type", "application/x-www-form-urlencoded");
        HttpEntity formEntity = new HttpEntity((Object)sendBody, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.postForEntity(POLL_QUERY_URL, (Object)formEntity, String.class, new Object[0]);
        return (String)result.getBody();
    }

    private String genDigest(String mgsData, String key, String customer) {
        return DigestUtils.md5Hex((String)(mgsData + key + customer)).toUpperCase();
    }
}

