/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.gateway.filter;

import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.gateway.config.properties.XssProperties;
import com.ruoyi.gateway.filter.XssFilter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnProperty(value={"security.xss.enabled"}, havingValue="true")
public class XssFilter
implements GlobalFilter,
Ordered {
    @Autowired
    private XssProperties xss;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (!this.xss.getEnabled().booleanValue()) {
            return chain.filter(exchange);
        }
        HttpMethod method = request.getMethod();
        if (method == null || method == HttpMethod.GET || method == HttpMethod.DELETE) {
            return chain.filter(exchange);
        }
        if (!this.isJsonRequest(exchange)) {
            return chain.filter(exchange);
        }
        String url = request.getURI().getPath();
        if (StringUtils.matches((String)url, (List)this.xss.getExcludeUrls())) {
            return chain.filter(exchange);
        }
        ServerHttpRequestDecorator httpRequestDecorator = this.requestDecorator(exchange);
        return chain.filter(exchange.mutate().request((ServerHttpRequest)httpRequestDecorator).build());
    }

    private ServerHttpRequestDecorator requestDecorator(ServerWebExchange exchange) {
        1 serverHttpRequestDecorator = new /* Unavailable Anonymous Inner Class!! */;
        return serverHttpRequestDecorator;
    }

    public boolean isJsonRequest(ServerWebExchange exchange) {
        String header = exchange.getRequest().getHeaders().getFirst("Content-Type");
        return StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)"application/json");
    }

    public int getOrder() {
        return -100;
    }
}

