/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.query.AppletOpinionReplyQuery;
import com.ruoyi.query.OpinionReplyQuery;
import com.ruoyi.service.CustomerServiceOpinionReplyService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.opinionreply.AppletOpinionReplyVO;
import com.ruoyi.vo.opinionreply.CustomerServiceReplyVO;
import com.ruoyi.vo.opinionreply.FeedbackVO;
import com.ruoyi.vo.opinionreply.OpinionReplyExportVO;
import com.ruoyi.vo.opinionreply.OpinionReplyInfoVO;
import com.ruoyi.vo.opinionreply.OpinionReplyVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u610f\u89c1\u53cd\u9988"})
@RequestMapping(value={"/opinionReply"})
@RestController
public class CustomerServiceOpinionReplyController {
    private static final Logger log = LoggerFactory.getLogger(CustomerServiceOpinionReplyController.class);
    @Autowired
    private CustomerServiceOpinionReplyService customerServiceOpinionReplyService;

    @PostMapping(value={"/feedback"})
    @ApiOperation(value="\u4e00\u952e\u53cd\u9988")
    public R feedback(@RequestBody FeedbackVO feedbackVO) {
        try {
            this.customerServiceOpinionReplyService.feedback(feedbackVO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5217\u8868")
    public R<List<OpinionReplyVO>> list() {
        try {
            List list = this.customerServiceOpinionReplyService.list().stream().map(c -> {
                OpinionReplyVO vo = new OpinionReplyVO();
                BeanUtil.copyProperties((Object)c, (Object)vo, (String[])new String[0]);
                vo.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)c.getCreateTime()));
                return vo;
            }).collect(Collectors.toList());
            return R.ok(list);
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u5206\u9875\u5217\u8868")
    public R<PageResultVo<OpinionReplyVO>> pageList(@RequestBody OpinionReplyQuery query) {
        try {
            PageResultVo pageList = this.customerServiceOpinionReplyService.pageList(query);
            return R.ok((Object)pageList);
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/info/{id}"})
    @ApiOperation(value="\u5355\u6761\u4fe1\u606f")
    public R<OpinionReplyInfoVO> info(@PathVariable String id) {
        try {
            return R.ok((Object)this.customerServiceOpinionReplyService.info(id));
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/reply"})
    @ApiOperation(value="\u56de\u590d")
    public R reply(@RequestBody CustomerServiceReplyVO replyVO) {
        try {
            this.customerServiceOpinionReplyService.reply(replyVO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportExcel(@RequestBody OpinionReplyQuery query, HttpServletResponse response) {
        try {
            List list = this.customerServiceOpinionReplyService.exportList(query);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u610f\u89c1\u53cd\u9988", "\u610f\u89c1\u53cd\u9988", ExcelType.XSSF), OpinionReplyExportVO.class, (Collection)list);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u610f\u89c1\u53cd\u9988");
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/applet/pageList"})
    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u5927B\u7aef-\u5206\u9875\u5217\u8868")
    public R<PageResultVo<AppletOpinionReplyVO>> pageList(@RequestBody AppletOpinionReplyQuery query) {
        try {
            PageResultVo pageList = this.customerServiceOpinionReplyService.pageList(query);
            return R.ok((Object)pageList);
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            return R.failed((String)e.getLocalizedMessage());
        }
    }
}

