/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.entity.CustomerServiceMarketLedger;
import com.ruoyi.entity.CustomerServiceMarketLedgerFile;
import com.ruoyi.mapper.CustomerServiceMarketLedgerFileMapper;
import com.ruoyi.mapper.CustomerServiceMarketLedgerMapper;
import com.ruoyi.query.MarketLedgerQuery;
import com.ruoyi.service.CustomerServiceMarketLedgerService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.marketledger.MarketLedgerEditVO;
import com.ruoyi.vo.marketledger.MarketLedgerExportVO;
import com.ruoyi.vo.marketledger.MarketLedgerInfoVO;
import com.ruoyi.vo.marketledger.MarketLedgerSaveVO;
import com.ruoyi.vo.marketledger.MarketLedgerVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceMarketLedgerServiceImpl
extends ServiceImpl<CustomerServiceMarketLedgerMapper, CustomerServiceMarketLedger>
implements CustomerServiceMarketLedgerService {
    @Autowired
    private CustomerServiceMarketLedgerFileMapper customerServiceMarketLedgerFileMapper;

    private LambdaQueryWrapper<CustomerServiceMarketLedger> getQueryWrapperByMarketLedgerQuery(MarketLedgerQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)query.getProjectName())) {
            wrapper.like(CustomerServiceMarketLedger::getProjectName, (Object)query.getProjectName());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getPaymentType())) {
            wrapper.eq(CustomerServiceMarketLedger::getPaymentType, (Object)query.getPaymentType());
        }
        if (null != query.getHasReconciliation()) {
            wrapper.eq(CustomerServiceMarketLedger::getHasReconciliation, (Object)query.getHasReconciliation());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getHappenStartDate())) {
            wrapper.ge(CustomerServiceMarketLedger::getHappenDate, (Object)query.getHappenStartDate());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getHappenEndDate())) {
            wrapper.le(CustomerServiceMarketLedger::getHappenDate, (Object)query.getHappenEndDate());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRoomNo())) {
            wrapper.like(CustomerServiceMarketLedger::getRoomNo, (Object)query.getRoomNo());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getPackageName())) {
            wrapper.like(CustomerServiceMarketLedger::getPackageName, (Object)query.getPackageName());
        }
        wrapper.orderByDesc(CustomerServiceMarketLedger::getCreateTime);
        return wrapper;
    }

    public PageResultVo<MarketLedgerVO> getPageList(MarketLedgerQuery query) {
        LambdaQueryWrapper wrapper = this.getQueryWrapperByMarketLedgerQuery(query);
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        this.page((IPage)page, (Wrapper)wrapper);
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            MarketLedgerVO marketLedgerVO = new MarketLedgerVO();
            BeanUtil.copyProperties((Object)r, (Object)marketLedgerVO, (String[])new String[0]);
            resultList.add(marketLedgerVO);
        });
        return new PageResultVo(page, resultList);
    }

    public MarketLedgerInfoVO info(String id) {
        CustomerServiceMarketLedger marketLedger = (CustomerServiceMarketLedger)this.getById((Serializable)Long.valueOf(Long.parseLong(id)));
        if (null == marketLedger) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        MarketLedgerInfoVO info = new MarketLedgerInfoVO();
        BeanUtil.copyProperties((Object)marketLedger, (Object)info, (String[])new String[0]);
        info.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)marketLedger.getCreateTime()));
        List files = this.customerServiceMarketLedgerFileMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerServiceMarketLedgerFile::getLedgerId, (Object)Long.parseLong(id))).eq(CustomerServiceMarketLedgerFile::getIsDelete, (Object)0)).orderByAsc(CustomerServiceMarketLedgerFile::getId));
        info.setFilePaths(files.stream().map(CustomerServiceMarketLedgerFile::getFilePath).collect(Collectors.toList()));
        return info;
    }

    public void save(MarketLedgerSaveVO saveVO) {
        CustomerServiceMarketLedger marketLedger = new CustomerServiceMarketLedger();
        BeanUtil.copyProperties((Object)saveVO, (Object)marketLedger, (String[])new String[0]);
        marketLedger.setHasReconciliation(Integer.valueOf(0));
        this.save((Object)marketLedger);
        this.saveFile(saveVO.getFilePaths(), marketLedger.getId());
    }

    private void saveFile(List<String> filePaths, Long marketLedgerId) {
        if (CollUtil.isNotEmpty(filePaths)) {
            ArrayList marketLedgerFiles = new ArrayList();
            filePaths.forEach(path -> {
                CustomerServiceMarketLedgerFile file = new CustomerServiceMarketLedgerFile();
                file.setId(Long.valueOf(IdWorker.getId((Object)file)));
                file.setLedgerId(marketLedgerId);
                file.setFilePath(path);
                file.setIsDelete(Integer.valueOf(0));
                marketLedgerFiles.add(file);
            });
            this.customerServiceMarketLedgerFileMapper.saveBatch(marketLedgerFiles);
        }
    }

    public void edit(MarketLedgerEditVO editVO) {
        if (StrUtil.isBlank((CharSequence)editVO.getId())) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        CustomerServiceMarketLedger marketLedger = (CustomerServiceMarketLedger)this.getById((Serializable)Long.valueOf(Long.parseLong(editVO.getId())));
        if (null == marketLedger) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        BeanUtil.copyProperties((Object)editVO, (Object)marketLedger, (String[])new String[0]);
        marketLedger.setUpdateId(SecurityUtils.getLoginUser().getUserid());
        marketLedger.setUpdateName(SecurityUtils.getLoginUser().getUsername());
        marketLedger.setUpdateTime(LocalDateTime.now());
        this.updateById((Object)marketLedger);
        List marketLedgerFiles = this.customerServiceMarketLedgerFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerServiceMarketLedgerFile::getId, (Object)marketLedger.getMarketerId())).eq(CustomerServiceMarketLedgerFile::getIsDelete, (Object)0));
        List oldFilePaths = marketLedgerFiles.stream().map(CustomerServiceMarketLedgerFile::getFilePath).collect(Collectors.toList());
        if (CollUtil.isNotEmpty((Collection)editVO.getFilePaths())) {
            if (!oldFilePaths.containsAll(editVO.getFilePaths())) {
                this.customerServiceMarketLedgerFileMapper.deleteByLedgerId(marketLedger.getId());
                this.saveFile(editVO.getFilePaths(), marketLedger.getId());
            }
        } else {
            this.customerServiceMarketLedgerFileMapper.deleteByLedgerId(marketLedger.getId());
        }
    }

    public List<MarketLedgerExportVO> exportList(MarketLedgerQuery query) {
        LambdaQueryWrapper wrapper = this.getQueryWrapperByMarketLedgerQuery(query);
        List marketLedgerList = this.list((Wrapper)wrapper);
        ArrayList<MarketLedgerExportVO> resultList = new ArrayList<MarketLedgerExportVO>();
        marketLedgerList.forEach(r -> {
            MarketLedgerExportVO exportVO = new MarketLedgerExportVO();
            BeanUtil.copyProperties((Object)r, (Object)exportVO, (String[])new String[0]);
            exportVO.setHasReconciliation(r.getHasReconciliation() == 1 ? "\u662f" : "\u5426");
            resultList.add(exportVO);
        });
        return resultList;
    }
}

